/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.jobs.IBackgroundProcessingQueue;
import org.eclipse.m2e.core.internal.jobs.MavenJob;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.jdt.internal.BuildPathManager;
import org.eclipse.m2e.jdt.internal.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DownloadSourcesJob
extends MavenJob
implements IBackgroundProcessingQueue {
    private static Logger log = LoggerFactory.getLogger(DownloadSourcesJob.class);
    private static final long SCHEDULE_INTERVAL = 1000L;
    private final IMaven maven;
    private final BuildPathManager manager;
    private final IMavenProjectRegistry projectManager;
    private final BlockingQueue<DownloadRequest> queue = new LinkedBlockingQueue<DownloadRequest>();
    private Set<DownloadRequest> requests = new HashSet<DownloadRequest>();
    private final Set<IProject> toUpdateMavenProjects = new HashSet<IProject>();
    private final Map<IPackageFragmentRoot, Attachments> toUpdateAttachments = new HashMap<IPackageFragmentRoot, Attachments>();

    public DownloadSourcesJob(BuildPathManager manager) {
        super(Messages.DownloadSourcesJob_job_download);
        this.manager = manager;
        this.maven = MavenPlugin.getMaven();
        this.projectManager = MavenPlugin.getMavenProjectRegistry();
    }

    public IStatus run(IProgressMonitor monitor) {
        int totalWork = 2 * this.queue.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
        while (!this.queue.isEmpty() && !monitor.isCanceled()) {
            DownloadRequest request = (DownloadRequest)this.queue.poll();
            try {
                IStatus status = (IStatus)this.maven.execute((context, aMonitor) -> this.downloadFilesAndPopulateToUpdate(request, aMonitor), (IProgressMonitor)subMonitor.split(1));
                if (status.isOK()) continue;
                this.queue.clear();
                this.requests.clear();
                this.toUpdateAttachments.clear();
                this.toUpdateMavenProjects.clear();
                return status;
            }
            catch (CoreException ex) {
                return ex.getStatus();
            }
        }
        if (monitor.isCanceled()) {
            this.queue.clear();
            this.requests.clear();
            this.toUpdateAttachments.clear();
            this.toUpdateMavenProjects.clear();
            return Status.CANCEL_STATUS;
        }
        if (!this.toUpdateAttachments.isEmpty() || !this.toUpdateMavenProjects.isEmpty()) {
            DownloadSourcesJob.updateClasspath(this.manager, this.toUpdateMavenProjects, this.toUpdateAttachments, (IProgressMonitor)subMonitor.split(totalWork / 2));
            this.toUpdateAttachments.clear();
            this.toUpdateMavenProjects.clear();
        }
        this.requests.clear();
        this.requests.addAll(this.queue);
        subMonitor.done();
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    private static void updateClasspath(BuildPathManager manager, Set<IProject> toUpdateMavenProjects, Map<IPackageFragmentRoot, Attachments> toUpdateAttachments, IProgressMonitor monitor) {
        SubMonitor updateMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DownloadSourcesJob_job_associateWithClasspath, (int)(1 + toUpdateMavenProjects.size() + toUpdateAttachments.size()));
        ISchedulingRule schedulingRule = ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
        DownloadSourcesJob.getJobManager().beginRule(schedulingRule, (IProgressMonitor)updateMonitor.split(1));
        try {
            for (IProject iProject : toUpdateMavenProjects) {
                updateMonitor.setTaskName(Messages.DownloadSourcesJob_job_associateWithClasspath + " - " + iProject.getName());
                manager.updateClasspath(iProject, (IProgressMonitor)updateMonitor.split(1));
            }
            for (Map.Entry entry : toUpdateAttachments.entrySet()) {
                updateMonitor.setTaskName(Messages.DownloadSourcesJob_job_associateWithClasspath + " - " + ((IPackageFragmentRoot)entry.getKey()).getElementName());
                manager.attachSourcesAndJavadoc((IPackageFragmentRoot)entry.getKey(), ((Attachments)entry.getValue()).sources, ((Attachments)entry.getValue()).javadoc, (IProgressMonitor)updateMonitor.split(1));
            }
        }
        finally {
            DownloadSourcesJob.getJobManager().endRule(schedulingRule);
            updateMonitor.done();
        }
    }

    IStatus downloadFilesAndPopulateToUpdate(DownloadRequest request, IProgressMonitor monitor) {
        SubMonitor requestMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)33);
        try {
            if (request.artifact != null) {
                requestMonitor.setTaskName(this.getName() + ": " + request.artifact.artifactId());
            } else if (request.project != null) {
                requestMonitor.setTaskName(this.getName() + ": " + request.project.getName());
            }
            IMavenProjectFacade projectFacade = this.projectManager.create(request.project, (IProgressMonitor)requestMonitor.split(1));
            if (projectFacade != null) {
                Attachments files = this.downloadMaven(projectFacade, request.artifact, request.downloadSources, request.downloadJavaDoc, (IProgressMonitor)requestMonitor.split(2));
                if (files != null && files.isNotEmpty()) {
                    this.toUpdateMavenProjects.add(request.project);
                }
            } else if (request.artifact != null) {
                List repositories = this.maven.getArtifactRepositories();
                Attachments files = this.downloadAttachments(request.artifact, repositories, request.downloadSources, request.downloadJavaDoc, (IProgressMonitor)requestMonitor.split(2));
                if (request.fragment == null) {
                    log.warn("IPackageFragmentRoot is missing, skipping javadoc/source attachment for project " + String.valueOf(request.project));
                } else {
                    this.toUpdateAttachments.put(request.fragment, files);
                }
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (CoreException ex) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.m2e.jdt", -1, new IStatus[]{ex.getStatus()}, "Could not download sources or javadoc", null);
            return multiStatus;
        }
        finally {
            requestMonitor.done();
        }
    }

    private Attachments downloadMaven(IMavenProjectFacade projectFacade, ArtifactKey artifact, boolean downloadSources, boolean downloadJavadoc, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = projectFacade.getMavenProject(monitor);
        List repositories = mavenProject.getRemoteArtifactRepositories();
        Attachments files = null;
        if (artifact != null) {
            files = this.downloadAttachments(artifact, repositories, downloadSources, downloadJavadoc, monitor);
        } else {
            for (Artifact a : mavenProject.getArtifacts()) {
                ArtifactKey aKey = new ArtifactKey(a.getGroupId(), a.getArtifactId(), a.getBaseVersion(), a.getClassifier());
                files = this.downloadAttachments(aKey, repositories, downloadSources, downloadJavadoc, monitor);
            }
        }
        if (files != null && files.isNotEmpty()) {
            return files;
        }
        return null;
    }

    private Attachments downloadAttachments(ArtifactKey artifact, List<ArtifactRepository> repositories, boolean downloadSources, boolean downloadJavadoc, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            String message = "Downloading of sources/javadocs was canceled";
            log.debug(message);
            throw new OperationCanceledException(message);
        }
        ArtifactKey[] attached = this.manager.getAttachedSourcesAndJavadoc(artifact, repositories, downloadSources, downloadJavadoc);
        File source = null;
        if (attached[0] != null) {
            try {
                source = this.download(attached[0], repositories, monitor);
                log.info("Downloaded sources for " + artifact.toString());
            }
            catch (CoreException e) {
                log.error("Could not download sources for " + artifact.toString(), (Throwable)e);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        File javadoc = null;
        if (attached[1] != null) {
            try {
                javadoc = this.download(attached[1], repositories, monitor);
                log.info("Downloaded javadoc for " + artifact.toString());
            }
            catch (CoreException e) {
                log.error("Could not download javadoc for " + artifact.toString(), (Throwable)e);
            }
        }
        if (source == null && javadoc == null) {
            return null;
        }
        return new Attachments(javadoc, source);
    }

    private File download(ArtifactKey artifact, List<ArtifactRepository> repositories, IProgressMonitor monitor) throws CoreException {
        Artifact resolved = this.maven.resolve(artifact.groupId(), artifact.artifactId(), artifact.version(), "jar", artifact.classifier(), repositories, monitor);
        return resolved.getFile();
    }

    private void scheduleDownload(IProject project, IPackageFragmentRoot fragment, ArtifactKey artifact, boolean downloadSources, boolean downloadJavadoc) {
        if (project == null || !project.isAccessible()) {
            return;
        }
        DownloadRequest request = new DownloadRequest(project, fragment, artifact, downloadSources, downloadJavadoc);
        if (this.requests.add(request)) {
            this.queue.add(request);
            this.schedule(1000L);
        }
    }

    public void scheduleDownload(IProject project, ArtifactKey artifact, boolean downloadSources, boolean downloadJavadoc) {
        this.scheduleDownload(project, null, artifact, downloadSources, downloadJavadoc);
    }

    public void scheduleDownload(IPackageFragmentRoot fragment, ArtifactKey artifact, boolean downloadSources, boolean downloadJavadoc) {
        IProject project = fragment.getJavaProject().getProject();
        this.scheduleDownload(project, fragment, artifact, downloadSources, downloadJavadoc);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    private static final class Attachments {
        public final File javadoc;
        public final File sources;

        public Attachments(File javadoc, File sources) {
            this.javadoc = javadoc;
            this.sources = sources;
        }

        public boolean isNotEmpty() {
            return this.sources != null || this.javadoc != null;
        }
    }

    private static class DownloadRequest {
        final IProject project;
        final IPackageFragmentRoot fragment;
        final ArtifactKey artifact;
        final boolean downloadSources;
        final boolean downloadJavaDoc;

        public DownloadRequest(IProject project, IPackageFragmentRoot fragment, ArtifactKey artifact, boolean downloadSources, boolean downloadJavaDoc) {
            this.project = project;
            this.fragment = fragment;
            this.artifact = artifact;
            this.downloadSources = downloadSources;
            this.downloadJavaDoc = downloadJavaDoc;
        }

        public int hashCode() {
            return Objects.hash(this.project, this.fragment, this.artifact, this.downloadSources, this.downloadJavaDoc);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof DownloadRequest) {
                DownloadRequest other = (DownloadRequest)o;
                if (this.project.equals((Object)other.project) && Objects.equals(this.fragment, other.fragment) && Objects.equals(this.artifact, other.artifact) && this.downloadSources == other.downloadSources && this.downloadJavaDoc == other.downloadJavaDoc) {
                    return true;
                }
            }
            return false;
        }
    }
}

