/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ant.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.mylyn.wikitext.ant.MarkupTask;
import org.eclipse.mylyn.wikitext.ant.internal.Messages;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.HtmlParser;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.xml.sax.InputSource;

public class HtmlToMarkupTask
extends MarkupTask {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    protected File file;
    protected String outputFilenameFormat = "$1.$2";
    protected boolean overwrite = true;

    public void execute() throws BuildException {
        if (this.file == null && this.filesets.isEmpty()) {
            throw new BuildException(Messages.getString("MarkupToHtmlTask.1"));
        }
        if (this.file != null && !this.filesets.isEmpty()) {
            throw new BuildException(Messages.getString("MarkupToHtmlTask.2"));
        }
        if (this.file != null) {
            if (!this.file.exists()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.3"), this.file));
            }
            if (!this.file.isFile()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.4"), this.file));
            }
            if (!this.file.canRead()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.5"), this.file));
            }
        }
        MarkupLanguage markupLanguage = this.createMarkupLanguage();
        for (FileSet fileset : this.filesets) {
            File filesetBaseDir = fileset.getDir(this.getProject());
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            if (files == null) continue;
            File baseDir = ds.getBasedir();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File inputFile = new File(baseDir, file);
                try {
                    this.processFile(markupLanguage, filesetBaseDir, inputFile);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.11"), inputFile, e.getMessage()), (Throwable)e);
                }
                ++n2;
            }
        }
        if (this.file != null) {
            try {
                this.processFile(markupLanguage, this.file.getParentFile(), this.file);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.12"), this.file, e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processFile(MarkupLanguage markupLanguage, File folder, File source) {
        File outputFile;
        String name;
        this.log(MessageFormat.format(Messages.getString("MarkupToHtmlTask.14"), source), 3);
        if (this.isValidate()) {
            this.log(MessageFormat.format(Messages.getString("HtmlToMarkupTask.1"), source), 1);
        }
        if ((name = source.getName()).lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if ((outputFile = this.computeTargetFile(markupLanguage, source, name)).exists() && !this.overwrite && outputFile.lastModified() >= source.lastModified()) return;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)), StandardCharsets.UTF_8);){
                DocumentBuilder builder = markupLanguage.createDocumentBuilder((Writer)writer);
                try {
                    Throwable throwable2 = null;
                    Object var11_16 = null;
                    try {
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
                        try {
                            try (InputStreamReader input = this.getSourceEncoding() == null ? new InputStreamReader(in) : new InputStreamReader((InputStream)in, this.getSourceEncoding());){
                                new HtmlParser().parse(new InputSource(input), builder);
                            }
                            if (in == null) return;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            if (in == null) throw throwable2;
                            ((InputStream)in).close();
                            throw throwable2;
                        }
                        ((InputStream)in).close();
                        return;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        } else {
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("HtmlToMarkupTask.failedToProcessContent"), source, e.getMessage()), (Throwable)e);
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.16"), outputFile, e.getMessage()), (Throwable)e);
        }
    }

    private File computeTargetFile(MarkupLanguage markupLanguage, File source, String name) {
        return new File(source.getParentFile(), this.outputFilenameFormat.replace("$1", name).replace("$2", markupLanguage.getName().toLowerCase()));
    }

    public String getOutputFilenameFormat() {
        return this.outputFilenameFormat;
    }

    public void setOutputFilenameFormat(String outputFilenameFormat) {
        this.outputFilenameFormat = outputFilenameFormat;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }
}

