/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

final class KotlinComposeFilter
implements IFilter {
    KotlinComposeFilter() {
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (!KotlinComposeFilter.isComposable(methodNode)) {
            return;
        }
        for (AbstractInsnNode i : methodNode.instructions) {
            JumpInsnNode ji;
            if (i.getType() != 5) continue;
            MethodInsnNode mi = (MethodInsnNode)i;
            if ("androidx/compose/runtime/Composer".equals(mi.owner) && "getSkipping".equals(mi.name) && "()Z".equals(mi.desc) && mi.getNext().getOpcode() == 154) {
                ji = (JumpInsnNode)mi.getNext();
                output.ignore(methodNode.instructions.getFirst(), (AbstractInsnNode)ji);
                output.ignore((AbstractInsnNode)ji.label, methodNode.instructions.getLast());
                continue;
            }
            if ("androidx/compose/runtime/Composer".equals(mi.owner) && "endRestartGroup".equals(mi.name) && "()Landroidx/compose/runtime/ScopeUpdateScope;".equals(mi.desc) && mi.getNext().getOpcode() == 89 && mi.getNext().getNext().getOpcode() == 198) {
                ji = (JumpInsnNode)mi.getNext().getNext();
                AbstractInsnNode jumpTarget = AbstractMatcher.skipNonOpcodes((AbstractInsnNode)ji.label);
                if (jumpTarget.getOpcode() != 87) continue;
                output.ignore((AbstractInsnNode)ji, jumpTarget);
                continue;
            }
            if (!"androidx/compose/runtime/ComposerKt".equals(mi.owner) || !"isTraceInProgress".equals(mi.name) || !"()Z".equals(mi.desc) || mi.getNext().getOpcode() != 153) continue;
            ji = (JumpInsnNode)mi.getNext();
            output.ignore((AbstractInsnNode)ji, (AbstractInsnNode)ji.label);
        }
    }

    private static boolean isComposable(MethodNode methodNode) {
        if (methodNode.invisibleAnnotations == null) {
            return false;
        }
        for (AnnotationNode a : methodNode.invisibleAnnotations) {
            if (!"Landroidx/compose/runtime/Composable;".equals(a.desc)) continue;
            return true;
        }
        return false;
    }
}

