/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.core.operations;

import java.util.EnumSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;

public class OperationMonitor
implements IOperationMonitor {
    private EnumSet<IOperationMonitor.OperationFlag> flags;
    private final SubMonitor monitor;
    private final IOperationMonitor root;

    public OperationMonitor(IOperationMonitor root, IProgressMonitor monitor) {
        this.root = root;
        this.monitor = SubMonitor.convert((IProgressMonitor)monitor);
    }

    public OperationMonitor(IOperationMonitor root, IProgressMonitor monitor, String taskName, int work) {
        this.root = root;
        this.monitor = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)work);
    }

    @Override
    public synchronized void addFlag(IOperationMonitor.OperationFlag flag) {
        if (this.root != null) {
            this.root.addFlag(flag);
        } else if (this.flags == null) {
            this.flags = EnumSet.of(flag);
        } else {
            this.flags.add(flag);
        }
    }

    public void beginTask(String name, int totalWork) {
        this.monitor.beginTask(name, totalWork);
    }

    public void clearBlocked() {
        this.monitor.clearBlocked();
    }

    public void done() {
        this.monitor.done();
    }

    public boolean equals(Object obj) {
        return this.monitor.equals(obj);
    }

    @Override
    public synchronized boolean hasFlag(IOperationMonitor.OperationFlag flag) {
        if (this.root != null) {
            return this.root.hasFlag(flag);
        }
        if (this.flags != null) {
            return this.flags.contains((Object)flag);
        }
        return false;
    }

    public int hashCode() {
        return this.monitor.hashCode();
    }

    public void internalWorked(double work) {
        this.monitor.internalWorked(work);
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    @Override
    public IOperationMonitor newChild(int totalWork) {
        return new OperationMonitor(this.root == null ? this : this.root, (IProgressMonitor)this.monitor.newChild(totalWork));
    }

    @Override
    public IOperationMonitor newChild(int totalWork, int suppressFlags) {
        return new OperationMonitor(this.root == null ? this : this.root, (IProgressMonitor)this.monitor.newChild(totalWork, suppressFlags));
    }

    @Override
    public synchronized void removeFlag(IOperationMonitor.OperationFlag flag) {
        if (this.root != null) {
            this.root.removeFlag(flag);
        } else if (this.flags != null) {
            this.flags.remove((Object)flag);
        }
    }

    public void setBlocked(IStatus reason) {
        this.monitor.setBlocked(reason);
    }

    public void setCanceled(boolean b) {
        this.monitor.setCanceled(b);
    }

    public void setTaskName(String name) {
        this.monitor.setTaskName(name);
    }

    @Override
    public IOperationMonitor setWorkRemaining(int workRemaining) {
        this.monitor.setWorkRemaining(workRemaining);
        return this;
    }

    public void subTask(String name) {
        this.monitor.subTask(name);
    }

    public String toString() {
        return this.monitor.toString();
    }

    public void worked(int work) {
        this.monitor.worked(work);
    }
}

