/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.index.ui;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.internal.tasks.index.core.TaskListIndex;
import org.eclipse.mylyn.internal.tasks.index.ui.ContentProposalProvider;
import org.eclipse.mylyn.internal.tasks.index.ui.IndexReference;
import org.eclipse.mylyn.internal.tasks.index.ui.IndexedSubstringPatternFilter;
import org.eclipse.mylyn.internal.tasks.index.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.search.AbstractSearchHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskSchema;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class IndexSearchHandler
extends AbstractSearchHandler {
    private IndexReference reference = new IndexReference();

    public Composite createSearchComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(container);
        final Button button = new Button(container, 32);
        button.setText(Messages.IndexSearchHandler_summaryOnly);
        button.setToolTipText(Messages.IndexSearchHandler_summaryOnly_tooltip);
        button.setSelection(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTaskSchema.Field newDefaultField = button.getSelection() ? TaskListIndex.FIELD_SUMMARY : TaskListIndex.FIELD_CONTENT;
                IndexSearchHandler.this.reference.index().setDefaultField(newDefaultField);
                IndexSearchHandler.this.fireFilterChanged();
            }
        });
        return container;
    }

    public PatternFilter createFilter() {
        return new IndexedSubstringPatternFilter(this.reference.index());
    }

    public void adaptTextSearchControl(Text textControl) {
        if (textControl.getParent().getLayout() instanceof GridLayout) {
            ((GridLayout)textControl.getParent().getLayout()).marginLeft = 6;
        }
        textControl.getDisplay().asyncExec(() -> {
            if (!textControl.isDisposed()) {
                this.adaptTextSearchControlInternal(textControl);
            }
        });
    }

    private void adaptTextSearchControlInternal(Text textControl) {
        Listener[] traverseListeners;
        ContentProposalProvider proposalProvider = new ContentProposalProvider(TasksUiPlugin.getTaskList(), this.reference);
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)textControl, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)proposalProvider, null, new char[0], true);
        adapter.setProposalAcceptanceStyle(2);
        Listener[] listenerArray = traverseListeners = textControl.getListeners(31);
        int n = traverseListeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            if (listener.getClass() == TypedListener.class) {
                textControl.removeListener(31, listener);
                textControl.addListener(31, event -> {
                    if (!adapter.isProposalPopupOpen()) {
                        listener.handleEvent(event);
                    }
                });
            }
            ++n2;
        }
    }

    public void dispose() {
        this.reference.dispose();
        this.reference = null;
    }
}

