/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.service;

import java.util.Hashtable;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.service.IGDBFocusSynchronizer;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MINotifyAsyncOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class GDBFocusSynchronizer
extends AbstractDsfService
implements IGDBFocusSynchronizer,
IEventListener {
    private IDMContext fCurrentGDBFocus;
    private IStack fStackService;
    private IGDBProcesses fProcesses;
    private IGDBControl fGdbcontrol;
    private CommandFactory fCommandFactory;
    private static final String THREAD_ID_DEFAULT = "1";

    public GDBFocusSynchronizer(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBFocusSynchronizer.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fProcesses = (IGDBProcesses)this.getServicesTracker().getService(IGDBProcesses.class);
        this.fStackService = (IStack)this.getServicesTracker().getService(IStack.class);
        this.fGdbcontrol = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.fCommandFactory = this.fGdbcontrol.getCommandFactory();
        this.register(new String[]{IGDBFocusSynchronizer.class.getName()}, new Hashtable());
        this.fGdbcontrol.addEventListener(this);
        this.getSession().addServiceEventListener((Object)this, null);
        this.fCurrentGDBFocus = this.createThreadContextFromThreadId(THREAD_ID_DEFAULT);
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.fGdbcontrol.removeEventListener(this);
        this.getSession().removeServiceEventListener((Object)this);
        this.unregister();
        super.shutdown(requestMonitor);
    }

    @Override
    public void setFocus(IDMContext[] focus, final RequestMonitor rm) {
        assert (focus != null);
        IDMContext elem = focus[0];
        if (elem instanceof IStack.IFrameDMContext) {
            final IStack.IFrameDMContext finalFrameCtx = (IStack.IFrameDMContext)elem;
            this.setFrameFocus(finalFrameCtx, (RequestMonitor)new ImmediateRequestMonitor(rm){

                public void handleSuccess() {
                    GDBFocusSynchronizer.this.fCurrentGDBFocus = finalFrameCtx;
                    rm.done();
                }
            });
        } else if (elem instanceof IMIExecutionDMContext) {
            final IMIExecutionDMContext finalThreadCtx = (IMIExecutionDMContext)elem;
            this.setThreadFocus(finalThreadCtx, (RequestMonitor)new ImmediateRequestMonitor(rm){

                protected void handleSuccess() {
                    GDBFocusSynchronizer.this.fCurrentGDBFocus = finalThreadCtx;
                    rm.done();
                }
            });
        } else if (elem instanceof IMIContainerDMContext) {
            this.setProcessFocus((IMIContainerDMContext)elem, rm);
        } else {
            assert (false);
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context to set focus to", null));
            return;
        }
    }

    protected void setProcessFocus(final IMIContainerDMContext newProc, final RequestMonitor rm) {
        if (newProc == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "GdbFocusSynchronizer unable to resolve process context for the selected element", null));
            return;
        }
        this.fProcesses.getProcessesBeingDebugged((IDMContext)newProc, (DataRequestMonitor)new ImmediateDataRequestMonitor<IDMContext[]>(rm){

            protected void handleSuccess() {
                if (((IDMContext[])this.getData()).length > 0) {
                    final IDMContext finalThread = ((IDMContext[])this.getData())[0];
                    if (finalThread instanceof IMIExecutionDMContext) {
                        GDBFocusSynchronizer.this.setThreadFocus((IMIExecutionDMContext)finalThread, (RequestMonitor)new ImmediateRequestMonitor(rm){

                            protected void handleSuccess() {
                                (this).GDBFocusSynchronizer.this.fCurrentGDBFocus = finalThread;
                                rm.done();
                            }
                        });
                        return;
                    }
                    rm.done();
                } else {
                    String miInferiorId = newProc.getGroupId();
                    String cliInferiorId = miInferiorId.substring(1, miInferiorId.length());
                    ICommand<MIInfo> command = GDBFocusSynchronizer.this.fCommandFactory.createCLIInferior(GDBFocusSynchronizer.this.fGdbcontrol.getContext(), cliInferiorId);
                    GDBFocusSynchronizer.this.fGdbcontrol.queueCommand(command, (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

                        protected void handleSuccess() {
                            (this).GDBFocusSynchronizer.this.fCurrentGDBFocus = newProc;
                            rm.done();
                        }
                    });
                }
            }
        });
    }

    protected void setThreadFocus(IMIExecutionDMContext newThread, RequestMonitor rm) {
        if (newThread == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "GdbFocusSynchronizer unable to resolve thread context for the selected element", null));
            return;
        }
        ICommand<MIInfo> command = this.fCommandFactory.createMIThreadSelect((IDMContext)this.fGdbcontrol.getContext(), newThread.getThreadId());
        this.fGdbcontrol.queueCommand(command, (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
    }

    protected void setFrameFocus(IStack.IFrameDMContext newFrame, RequestMonitor rm) {
        if (newFrame == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "GdbFocusSynchronizer unable to resolve frame context for the selected element", null));
            return;
        }
        IMIExecutionDMContext threadDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)newFrame, IMIExecutionDMContext.class);
        if (this.isThreadSuspended(threadDmc)) {
            ICommand<MIInfo> command = this.fCommandFactory.createMIStackSelectFrame((IDMContext)threadDmc, newFrame.getLevel());
            this.fGdbcontrol.queueCommand(command, (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
        } else {
            rm.done();
        }
    }

    private boolean isThreadSuspended(IRunControl.IExecutionDMContext ctx) {
        assert (ctx != null);
        IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        if (runControl != null) {
            return runControl.isSuspended(ctx);
        }
        return false;
    }

    public void eventReceived(Object output) {
        MIOOBRecord[] mIOOBRecordArray = ((MIOutput)output).getMIOOBRecords();
        int n = mIOOBRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            MINotifyAsyncOutput out;
            String miEvent;
            MIOOBRecord oobr = mIOOBRecordArray[n2];
            if (oobr instanceof MINotifyAsyncOutput && "thread-selected".equals(miEvent = (out = (MINotifyAsyncOutput)oobr).getAsyncClass())) {
                MIResult[] results = out.getMIResults();
                String tid = null;
                String frameLevel = null;
                int i = 0;
                while (i < results.length) {
                    String var = results[i].getVariable();
                    MIValue val = results[i].getMIValue();
                    if (var.equals("frame") && val instanceof MITuple) {
                        MIResult[] res = ((MITuple)val).getMIResults();
                        int j = 0;
                        while (j < res.length) {
                            var = res[j].getVariable();
                            val = res[j].getMIValue();
                            if (var.equals("level") && val instanceof MIConst) {
                                frameLevel = ((MIConst)val).getString();
                            }
                            ++j;
                        }
                    } else if (var.equals("id") && val instanceof MIConst) {
                        tid = ((MIConst)val).getString();
                    }
                    ++i;
                }
                assert (tid != null);
                if (tid == null) {
                    return;
                }
                if (frameLevel == null) {
                    this.fCurrentGDBFocus = this.createThreadContextFromThreadId(tid);
                    this.createAndDispatchGDBFocusChangedEvent();
                } else {
                    int intFrameNum = 0;
                    try {
                        intFrameNum = Integer.parseInt(frameLevel);
                    }
                    catch (NumberFormatException e) {
                        GdbPlugin.log(e);
                    }
                    final String finalTid = tid;
                    this.fStackService.getFrames((IDMContext)this.createThreadContextFromThreadId(finalTid), intFrameNum, intFrameNum, (DataRequestMonitor)new ImmediateDataRequestMonitor<IStack.IFrameDMContext[]>(){

                        protected void handleCompleted() {
                            GDBFocusSynchronizer.this.fCurrentGDBFocus = this.isSuccess() && ((IStack.IFrameDMContext[])this.getData()).length > 0 ? ((IStack.IFrameDMContext[])this.getData())[0] : GDBFocusSynchronizer.this.createThreadContextFromThreadId(finalTid);
                            GDBFocusSynchronizer.this.createAndDispatchGDBFocusChangedEvent();
                        }
                    });
                }
            }
            ++n2;
        }
    }

    private void createAndDispatchGDBFocusChangedEvent() {
        assert (this.fCurrentGDBFocus != null);
        this.fGdbcontrol.getSession().dispatchEvent((Object)new GDBFocusChangedEvent(this.fCurrentGDBFocus), this.fGdbcontrol.getProperties());
    }

    private IMIExecutionDMContext createThreadContextFromThreadId(String tid) {
        assert (tid != null);
        IMIContainerDMContext parentContainer = this.fProcesses.createContainerContextFromThreadId(this.fGdbcontrol.getContext(), tid);
        IProcesses.IProcessDMContext processDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)parentContainer, IProcesses.IProcessDMContext.class);
        IProcesses.IThreadDMContext threadDmc = this.fProcesses.createThreadContext(processDmc, tid);
        return this.fProcesses.createExecutionContext(parentContainer, threadDmc, tid);
    }

    @Override
    public void sessionSelected() {
        this.createAndDispatchGDBFocusChangedEvent();
    }

    @Override
    public IDMContext[] getFocus() {
        return new IDMContext[]{this.fCurrentGDBFocus};
    }

    @DsfServiceEventHandler
    public void updateContexts(DataModelInitializedEvent event) {
        final IMIExecutionDMContext threadCtx = this.createThreadContextFromThreadId(THREAD_ID_DEFAULT);
        if (!this.isThreadSuspended(threadCtx)) {
            this.fCurrentGDBFocus = threadCtx;
        } else {
            this.fStackService.getTopFrame((IDMContext)threadCtx, (DataRequestMonitor)new ImmediateDataRequestMonitor<IStack.IFrameDMContext>(){

                protected void handleCompleted() {
                    GDBFocusSynchronizer.this.fCurrentGDBFocus = this.isSuccess() ? (IDMContext)this.getData() : threadCtx;
                }
            });
        }
    }

    private class GDBFocusChangedEvent
    extends AbstractDMEvent<IDMContext>
    implements IGDBFocusSynchronizer.IGDBFocusChangedEvent {
        public GDBFocusChangedEvent(IDMContext ctx) {
            super(ctx);
        }
    }
}

