/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.wizards.toc;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.wizards.toc.TocHTMLOperation;
import org.eclipse.pde.internal.ua.ui.wizards.toc.TocHTMLWizardPage;
import org.eclipse.pde.internal.ua.ui.wizards.toc.TocWizardMessages;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public class TocHTMLWizard
extends BasicNewFileResourceWizard {
    protected IFile fNewFile;

    public void addPages() {
        TocHTMLWizardPage mainPage = new TocHTMLWizardPage("newHTMLPage1", this.getSelection());
        mainPage.setTitle(TocWizardMessages.TocHTMLWizard_title);
        mainPage.setDescription(TocWizardMessages.TocHTMLWizard_description);
        this.addPage((IWizardPage)mainPage);
    }

    public boolean performFinish() {
        IWizardPage mainPage = this.getPage("newHTMLPage1");
        if (!(mainPage instanceof TocHTMLWizardPage)) {
            return false;
        }
        this.fNewFile = ((TocHTMLWizardPage)mainPage).createNewFile();
        if (this.fNewFile == null) {
            return false;
        }
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)this.getOperation());
            this.selectAndReveal((IResource)this.fNewFile);
        }
        catch (InvocationTargetException e) {
            PDEUserAssistanceUIPlugin.logException(e);
            this.fNewFile = null;
            return false;
        }
        catch (InterruptedException e) {
            this.fNewFile = null;
            return false;
        }
        return true;
    }

    private WorkspaceModifyOperation getOperation() {
        return new TocHTMLOperation(this.fNewFile);
    }

    public IFile getNewResource() {
        return this.fNewFile;
    }
}

