/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.agent;

import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentConstants;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferException;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.sshd.agent.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshAgentClient
implements SshAgent {
    private static final Logger LOG = LoggerFactory.getLogger(SshAgentClient.class);
    private static final int MAX_NUMBER_OF_KEYS = 2048;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Connector connector;

    public SshAgentClient(Connector connector) {
        this.connector = connector;
    }

    private boolean open(boolean debugging) throws IOException {
        boolean connected;
        if (this.closed.get()) {
            if (debugging) {
                LOG.debug("SSH agent connection already closed");
            }
            return false;
        }
        try {
            boolean bl = connected = this.connector != null && this.connector.connect();
            if (!connected && debugging) {
                LOG.debug("No SSH agent");
            }
        }
        catch (IOException e) {
            if (debugging) {
                LOG.debug("No SSH agent", (Throwable)e);
            }
            throw e;
        }
        return connected;
    }

    public void close() throws IOException {
        if (!this.closed.getAndSet(true) && this.connector != null) {
            this.connector.close();
        }
    }

    public Iterable<? extends Map.Entry<PublicKey, String>> getIdentities() throws IOException {
        boolean debugging = LOG.isDebugEnabled();
        if (!this.open(debugging)) {
            return Collections.emptyList();
        }
        if (debugging) {
            LOG.debug("Requesting identities from SSH agent");
        }
        try {
            Buffer reply = this.rpc((byte)11);
            byte cmd = reply.getByte();
            if (cmd != 12) {
                throw new SshException(MessageFormat.format(SshdText.get().sshAgentReplyUnexpected, SshAgentConstants.getCommandMessageName((int)cmd)));
            }
            int numberOfKeys = reply.getInt();
            if (numberOfKeys < 0 || numberOfKeys > 2048) {
                throw new SshException(MessageFormat.format(SshdText.get().sshAgentWrongNumberOfKeys, Integer.toString(numberOfKeys)));
            }
            if (numberOfKeys == 0) {
                if (debugging) {
                    LOG.debug("SSH agent has no keys");
                }
                return Collections.emptyList();
            }
            if (debugging) {
                LOG.debug("Got {} key(s) from the SSH agent", (Object)Integer.toString(numberOfKeys));
            }
            boolean tracing = LOG.isTraceEnabled();
            ArrayList<AbstractMap.SimpleImmutableEntry<PublicKey, String>> keys = new ArrayList<AbstractMap.SimpleImmutableEntry<PublicKey, String>>(numberOfKeys);
            int i = 0;
            while (i < numberOfKeys) {
                PublicKey key = SshAgentClient.readKey(reply);
                String comment = reply.getString();
                if (key != null) {
                    if (tracing) {
                        LOG.trace("Got SSH agent {} key: {} {}", new Object[]{KeyUtils.getKeyType((Key)key), KeyUtils.getFingerPrint((PublicKey)key), comment});
                    }
                    keys.add(new AbstractMap.SimpleImmutableEntry<PublicKey, String>(key, comment));
                }
                ++i;
            }
            return keys;
        }
        catch (BufferException e) {
            throw new SshException(SshdText.get().sshAgentShortReadBuffer, (Throwable)e);
        }
    }

    public Map.Entry<String, byte[]> sign(SessionContext session, PublicKey key, String algorithm, byte[] data) throws IOException {
        Buffer reply;
        byte cmd;
        String signatureAlgorithm;
        boolean debugging = LOG.isDebugEnabled();
        String keyType = KeyUtils.getKeyType((Key)key);
        if (algorithm != null) {
            if (!KeyUtils.getCanonicalKeyType((String)algorithm).equals(keyType)) {
                throw new IllegalArgumentException(MessageFormat.format(SshdText.get().invalidSignatureAlgorithm, algorithm, keyType));
            }
            signatureAlgorithm = algorithm;
        } else {
            signatureAlgorithm = keyType;
        }
        if (!this.open(debugging)) {
            return null;
        }
        int flags = 0;
        switch (signatureAlgorithm) {
            case "rsa-sha2-512-cert-v01@openssh.com": 
            case "rsa-sha2-512": {
                flags = 4;
                break;
            }
            case "rsa-sha2-256": 
            case "rsa-sha2-256-cert-v01@openssh.com": {
                flags = 2;
                break;
            }
        }
        ByteArrayBuffer msg = new ByteArrayBuffer();
        msg.putInt(0L);
        msg.putByte((byte)13);
        msg.putPublicKey(key);
        msg.putBytes(data);
        msg.putInt((long)flags);
        if (debugging) {
            LOG.debug("sign({}): signing request to SSH agent for {} key, {} signature; flags={}", new Object[]{session, keyType, signatureAlgorithm, Integer.toString(flags)});
        }
        if ((cmd = (reply = this.rpc((byte)13, msg.getCompactData())).getByte()) != 14) {
            throw new SshException(MessageFormat.format(SshdText.get().sshAgentReplyUnexpected, SshAgentConstants.getCommandMessageName((int)cmd)));
        }
        try {
            ByteArrayBuffer signatureReply = new ByteArrayBuffer(reply.getBytes());
            String actualAlgorithm = signatureReply.getString();
            byte[] signature = signatureReply.getBytes();
            if (LOG.isTraceEnabled()) {
                LOG.trace("sign({}): signature reply from SSH agent for {} key: {} signature={}", new Object[]{session, keyType, actualAlgorithm, BufferUtils.toHex((char)':', (byte[])signature)});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("sign({}): signature reply from SSH agent for {} key, {} signature", new Object[]{session, keyType, actualAlgorithm});
            }
            return new AbstractMap.SimpleImmutableEntry<String, byte[]>(actualAlgorithm, signature);
        }
        catch (BufferException e) {
            throw new SshException(SshdText.get().sshAgentShortReadBuffer, (Throwable)e);
        }
    }

    public void addIdentity(KeyPair key, String comment, SshAgentKeyConstraint ... constraints) throws IOException {
        Buffer reply;
        boolean debugging = LOG.isDebugEnabled();
        if (!this.open(debugging)) {
            return;
        }
        byte cmd = constraints != null && constraints.length > 0 ? (byte)25 : 17;
        byte[] message = null;
        ByteArrayBuffer msg = new ByteArrayBuffer();
        try {
            msg.putInt(0L);
            msg.putByte(cmd);
            String keyType = KeyUtils.getKeyType((KeyPair)key);
            if ("ssh-ed25519".equals(keyType)) {
                SshAgentClient.putEd25519Key((Buffer)msg, key);
            } else {
                msg.putKeyPair(key);
            }
            msg.putString(comment == null ? "" : comment);
            if (constraints != null) {
                SshAgentKeyConstraint[] sshAgentKeyConstraintArray = constraints;
                int n = constraints.length;
                int n2 = 0;
                while (n2 < n) {
                    SshAgentKeyConstraint constraint = sshAgentKeyConstraintArray[n2];
                    constraint.put((Buffer)msg);
                    ++n2;
                }
            }
            if (debugging) {
                LOG.debug("addIdentity: adding {} key {} to SSH agent; comment {}", new Object[]{keyType, KeyUtils.getFingerPrint((PublicKey)key.getPublic()), comment});
            }
            message = msg.getCompactData();
        }
        finally {
            msg.clear();
        }
        try {
            reply = this.rpc(cmd, message);
        }
        finally {
            Arrays.fill(message, (byte)0);
        }
        int replyLength = reply.available();
        if (replyLength != 1) {
            throw new SshException(MessageFormat.format(SshdText.get().sshAgentReplyUnexpected, MessageFormat.format(SshdText.get().sshAgentPayloadLengthError, 1, replyLength)));
        }
        cmd = reply.getByte();
        if (cmd != 6) {
            throw new SshException(MessageFormat.format(SshdText.get().sshAgentReplyUnexpected, SshAgentConstants.getCommandMessageName((int)cmd)));
        }
    }

    private static void putEd25519Key(Buffer msg, KeyPair key) throws IOException {
        ByteArrayBuffer tmp = new ByteArrayBuffer(36);
        tmp.putRawPublicKeyBytes(key.getPublic());
        byte[] publicBytes = tmp.getBytes();
        msg.putString("ssh-ed25519");
        msg.putBytes(publicBytes);
        PrivateKey pk = key.getPrivate();
        String format = pk.getFormat();
        if (!"PKCS#8".equalsIgnoreCase(format)) {
            throw new IOException(MessageFormat.format(SshdText.get().sshAgentEdDSAFormatError, format));
        }
        byte[] privateBytes = null;
        byte[] encoded = pk.getEncoded();
        try {
            privateBytes = SshAgentClient.asn1Parse(encoded, 32);
            byte[] combined = Arrays.copyOf(privateBytes, 64);
            Arrays.fill(privateBytes, (byte)0);
            privateBytes = combined;
            System.arraycopy(publicBytes, 0, privateBytes, 32, 32);
            msg.putBytes(privateBytes);
        }
        finally {
            if (privateBytes != null) {
                Arrays.fill(privateBytes, (byte)0);
            }
            Arrays.fill(encoded, (byte)0);
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] asn1Parse(byte[] encoded, int n) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PublicKey readKey(Buffer buffer) throws BufferException {
        int endOfBuffer = buffer.wpos();
        int keyLength = buffer.getInt();
        if (keyLength <= 0 || keyLength > buffer.available()) {
            throw new BufferException(MessageFormat.format(SshdText.get().sshAgentWrongKeyLength, Integer.toString(keyLength), Integer.toString(buffer.rpos()), Integer.toString(endOfBuffer)));
        }
        int afterKey = buffer.rpos() + keyLength;
        buffer.wpos(afterKey);
        try {
            PublicKey publicKey = buffer.getRawPublicKey(BufferPublicKeyParser.DEFAULT);
            return publicKey;
        }
        catch (Exception e) {
            LOG.warn(SshdText.get().sshAgentUnknownKey, (Throwable)e);
            return null;
        }
        finally {
            buffer.wpos(endOfBuffer);
            buffer.rpos(afterKey);
        }
    }

    private Buffer rpc(byte command, byte[] message) throws IOException {
        return new ByteArrayBuffer(this.connector.rpc(command, message));
    }

    private Buffer rpc(byte command) throws IOException {
        return new ByteArrayBuffer(this.connector.rpc(command));
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    public void removeIdentity(PublicKey key) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void removeAllIdentities() throws IOException {
        throw new UnsupportedOperationException();
    }
}

