/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.pdf;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.model.planpro.Basisobjekte.Bearbeitungsvermerk;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.CompareCellContent;
import org.eclipse.set.model.tablemodel.CompareFootnoteContainer;
import org.eclipse.set.model.tablemodel.CompareTableCellContent;
import org.eclipse.set.model.tablemodel.FootnoteContainer;
import org.eclipse.set.model.tablemodel.MultiColorCellContent;
import org.eclipse.set.model.tablemodel.MultiColorContent;
import org.eclipse.set.model.tablemodel.SimpleFootnoteContainer;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableContent;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.CellContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableCellExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.titlebox.PlanningOffice;
import org.eclipse.set.model.titlebox.StringField;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.export.xsl.siteplan.SiteplanXSL;
import org.eclipse.set.utils.table.TableSpanUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableToTableDocument {
    private static final Logger logger = LoggerFactory.getLogger(TableToTableDocument.class);
    private final Document doc;
    private String tablename;
    private int groupNumber;
    private TableSpanUtils spanUtils;
    private boolean remarkTextInlnie = true;
    private final HashMap<ArrayList<?>, Element> _createCache_transform = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_1 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_2 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_3 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Attr> _createCache_transformToGroupNumber = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_4 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_5 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_6 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_7 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transform_8 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transformToSignificantInformation = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Element> _createCache_transformToFootnotes = CollectionLiterals.newHashMap();

    private TableToTableDocument() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
    }

    public static TableToTableDocument createTransformation() throws ParserConfigurationException {
        return new TableToTableDocument();
    }

    public Document transformToDocument(BufferedImage imageData, Titlebox titleBox, FreeFieldInfo freeFieldInfo, double ppm) {
        this.tablename = "siteplan export";
        logger.debug("transform siteplan to document");
        Element rootNode = this.doc.createElement("Siteplan");
        rootNode.appendChild(this.transform(imageData, ppm));
        rootNode.appendChild(this.transform(titleBox));
        rootNode.appendChild(this.transform(freeFieldInfo));
        this.doc.appendChild(rootNode);
        return this.doc;
    }

    public Document transformToDocument(Table table, Titlebox titlebox, FreeFieldInfo freeFieldInfo) {
        ColumnDescriptor _rootDescriptor = null;
        if (table != null) {
            _rootDescriptor = TableExtensions.getRootDescriptor((Table)table);
        }
        String _label = null;
        if (_rootDescriptor != null) {
            _label = _rootDescriptor.getLabel();
        }
        this.tablename = _label;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("tablename=");
        _builder.append(this.tablename);
        logger.debug(_builder.toString());
        this.doc.appendChild(this.transform(table, titlebox, freeFieldInfo));
        return this.doc;
    }

    public Document transformToDocument(Titlebox titlebox) {
        this.tablename = "titlebox export";
        this.doc.appendChild(this.transform(titlebox));
        return this.doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(Table table, Titlebox titlebox, FreeFieldInfo freeFieldInfo) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{table, titlebox, freeFieldInfo});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform.containsKey(_cacheKey)) {
                return this._createCache_transform.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Table");
            this._createCache_transform.put(_cacheKey, _result);
        }
        this._init_transform(_result, table, titlebox, freeFieldInfo);
        return _result;
    }

    private void _init_transform(Element it, Table table, Titlebox titlebox, FreeFieldInfo freeFieldInfo) {
        this.remarkTextInlnie = TableExtensions.isInlineFootnote((Table)table);
        it.appendChild(this.transform(table.getTablecontent()));
        if (!this.remarkTextInlnie) {
            it.appendChild(this.transformToFootnotes(table));
        }
        it.appendChild(this.transform(titlebox));
        it.appendChild(this.transform(freeFieldInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(TableContent content) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new TableContent[]{content});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_1;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_1.containsKey(_cacheKey)) {
                return this._createCache_transform_1.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Rows");
            this._createCache_transform_1.put(_cacheKey, _result);
        }
        this._init_transform(_result, content);
        return _result;
    }

    private void _init_transform(Element it, TableContent content) {
        TableSpanUtils _tableSpanUtils;
        Element rowsElement = it;
        List rows = TableExtensions.getTableRows((Table)TableContentExtensions.getTable((TableContent)content));
        this.spanUtils = _tableSpanUtils = new TableSpanUtils(rows);
        Consumer<TableRow> _function = it_1 -> rowsElement.appendChild(this.transform((TableRow)it_1, rows));
        rows.forEach(_function);
        if (ToolboxConfiguration.isPdfExportTestFilling() && content.getRowgroups().isEmpty()) {
            rowsElement.appendChild(this.createTestRowElement(it, "1", content));
            rowsElement.appendChild(this.createTestRowElement(it, "2", content));
            rowsElement.appendChild(this.createTestRowElement(it, "3", content));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(BufferedImage imageData, double ppm) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{imageData, ppm});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_2;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_2.containsKey(_cacheKey)) {
                return this._createCache_transform_2.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Image");
            this._createCache_transform_2.put(_cacheKey, _result);
        }
        this._init_transform(_result, imageData, ppm);
        return _result;
    }

    private void _init_transform(Element it, BufferedImage imageData, double ppm) {
        try {
            Element widthElement = this.doc.createElement("Width");
            String _string = Double.valueOf(SiteplanXSL.pxToMilimeter((double)imageData.getWidth(), (double)ppm)).toString();
            String _plus = _string + "mm";
            widthElement.setTextContent(_plus);
            it.appendChild(widthElement);
            Element heightElement = this.doc.createElement("Height");
            String _string_1 = Double.valueOf(SiteplanXSL.pxToMilimeter((double)imageData.getHeight(), (double)ppm)).toString();
            String _plus_1 = _string_1 + "mm";
            heightElement.setTextContent(_plus_1);
            it.appendChild(heightElement);
            Element byteElement = this.doc.createElement("Byte");
            Attr type = this.doc.createAttribute("type");
            type.setValue("image/png");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)imageData, "png", byteArrayOutputStream);
            byte[] imageBytes = byteArrayOutputStream.toByteArray();
            byteElement.setAttributeNode(type);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("data:image/png;base64,");
            String _encodeToString = Base64.getEncoder().encodeToString(imageBytes);
            _builder.append(_encodeToString);
            _builder.append(">");
            byteElement.setTextContent(_builder.toString());
            it.appendChild(byteElement);
            return;
        }
        catch (Throwable _t) {
            if (!(_t instanceof IOException)) {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            IOException e = (IOException)_t;
            logger.error("Transform imageData to String error", (Throwable)e);
            return;
        }
    }

    private Element createTestRowElement(Element rowsElement, String groupNumber, TableContent content) {
        Element rowElement = this.doc.createElement("Row");
        Attr numberAttr = this.doc.createAttribute("group-number");
        numberAttr.setValue(groupNumber);
        rowElement.setAttributeNode(numberAttr);
        Consumer<Pair> _function = it -> {
            Integer _key = (Integer)it.getKey();
            int _plus = _key + 1;
            rowElement.appendChild(this.createTestCell(_plus));
        };
        IterableExtensions.indexed((Iterable)TableExtensions.getColumns((Table)TableContentExtensions.getTable((TableContent)content))).forEach(_function);
        return rowElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(TableRow row, List<TableRow> rows) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{row, rows});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_3;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_3.containsKey(_cacheKey)) {
                return this._createCache_transform_3.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Row");
            this._createCache_transform_3.put(_cacheKey, _result);
        }
        this._init_transform_1(_result, row, rows);
        return _result;
    }

    private void _init_transform_1(Element it, TableRow row, List<TableRow> rows) {
        it.setAttributeNode(this.transformToGroupNumber(row, rows));
        Element rowElement = it;
        int rowIndex = rows.indexOf(row);
        List cells = TableRowExtensions.getContent((TableRow)row);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("groupNumber=");
        _builder.append((Object)this.groupNumber);
        _builder.append(" (");
        boolean _hasElements = false;
        for (CellContent c : cells) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" ", "");
            }
            String _plainStringValue = CellContentExtensions.getPlainStringValue((CellContent)c);
            _builder.append(_plainStringValue);
        }
        _builder.append(")");
        logger.debug(_builder.toString());
        Consumer<Pair> _function = it_1 -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("column=");
            Integer _key = (Integer)it_1.getKey();
            _builder_1.append((Object)_key);
            logger.debug(_builder_1.toString());
            boolean isRemarkColumn = this.isRemarkColumn((CellContent)it_1.getValue(), cells);
            int rowSpan = 1;
            boolean _isMergeAllowed = this.spanUtils.isMergeAllowed(((Integer)it_1.getKey()).intValue(), rowIndex);
            if (_isMergeAllowed) {
                int spanUp = this.spanUtils.getRowSpanUp(((Integer)it_1.getKey()).intValue(), rowIndex);
                int spanDown = this.spanUtils.getRowSpanDown(((Integer)it_1.getKey()).intValue(), rowIndex);
                if (spanUp == 0 && spanDown > 0) {
                    rowSpan = spanDown + 1;
                } else if (spanUp > 0) {
                    rowSpan = 0;
                }
            }
            if (rowSpan > 0) {
                FootnoteContainer _footnotes = row.getFootnotes();
                Integer _key_1 = (Integer)it_1.getKey();
                int _plus = _key_1 + 1;
                Element cellElement = this.createCell((CellContent)it_1.getValue(), _footnotes, _plus, rowSpan, isRemarkColumn);
                boolean _isTopologicalCalculation = TableCellExtensions.getFormat((TableCell)CellContentExtensions.getTableCell((EObject)((EObject)it_1.getValue()))).isTopologicalCalculation();
                if (_isTopologicalCalculation) {
                    cellElement.setAttribute("cellType", "topologicalCell");
                }
                rowElement.appendChild(cellElement);
            }
        };
        IterableExtensions.indexed((Iterable)cells).forEach(_function);
    }

    private Element createTestCell(int columnNumber) {
        Element cellElement = this.doc.createElement("Cell");
        cellElement.setAttributeNode(this.createColumnAttribute(columnNumber));
        cellElement.appendChild(this.createTestContent(columnNumber));
        return cellElement;
    }

    private Element _createCell(CellContent content, FootnoteContainer fc, int columnNumber, int rowSpan, boolean isRemarkColumn) {
        Element cellElement = this.doc.createElement("Cell");
        cellElement.setAttributeNode(this.createColumnAttribute(columnNumber));
        cellElement.setAttributeNode(this.createRowSpanAttribute(rowSpan));
        cellElement.appendChild(this.createContent(content, fc, columnNumber, isRemarkColumn));
        return cellElement;
    }

    private Element _createCell(Void content, FootnoteContainer fc, int columnNumber, int rowSpan, boolean isRemarkColumn) {
        Element cellElement = this.doc.createElement("Cell");
        cellElement.setAttributeNode(this.createColumnAttribute(columnNumber));
        cellElement.setAttributeNode(this.createRowSpanAttribute(rowSpan));
        cellElement.appendChild(this.createContent(null, fc, columnNumber, isRemarkColumn));
        return cellElement;
    }

    private boolean isRemarkColumn(CellContent content, List<CellContent> rowContent) {
        CellContent _last = rowContent.getLast();
        return _last == content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attr transformToGroupNumber(TableRow row, List<TableRow> rows) {
        Attr _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{row, rows});
        HashMap<ArrayList<?>, Attr> hashMap = this._createCache_transformToGroupNumber;
        synchronized (hashMap) {
            Attr _createAttribute;
            if (this._createCache_transformToGroupNumber.containsKey(_cacheKey)) {
                return this._createCache_transformToGroupNumber.get(_cacheKey);
            }
            _result = _createAttribute = this.doc.createAttribute("group-number");
            this._createCache_transformToGroupNumber.put(_cacheKey, _result);
        }
        this._init_transformToGroupNumber(_result, row, rows);
        return _result;
    }

    private void _init_transformToGroupNumber(Attr it, TableRow row, List<TableRow> rows) {
        int _plus;
        int _indexOf = rows.indexOf(row);
        this.groupNumber = _plus = _indexOf + 1;
        it.setValue(Integer.valueOf(this.groupNumber).toString());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("group-number=");
        String _value = it.getValue();
        _builder.append(_value);
        logger.debug(_builder.toString());
    }

    private String checkForTestOutput(String text, int columnNumber) {
        if (ToolboxConfiguration.isPdfExportTestFilling() && StringExtensions.isNullOrEmpty((String)text)) {
            return Integer.toString(columnNumber);
        }
        return text;
    }

    private Element createTestContent(int columnNumber) {
        Element element = this.doc.createElement("StringContent");
        element.setTextContent(Integer.toString(columnNumber));
        return element;
    }

    private Element _createContent(CellContent content, FootnoteContainer fc, int columnNumber, boolean isRemarkColumn) {
        Element element = this.doc.createElement("StringContent");
        if (isRemarkColumn) {
            element = this.doc.createElement("DiffContent");
        }
        String stringValue = CellContentExtensions.getPlainStringValue((CellContent)content);
        if (isRemarkColumn) {
            Element child = this.doc.createElement("UnchangedValue");
            this.addContentToElement(stringValue, child, columnNumber, isRemarkColumn);
            this.addFootnoteContent(element, fc, columnNumber, isRemarkColumn);
        } else {
            element.setTextContent(org.eclipse.set.utils.StringExtensions.intersperseWithZeroSpacesSC((String)this.checkForTestOutput(stringValue, columnNumber)));
        }
        return element;
    }

    private Element _createContent(Void content, FootnoteContainer fc, int columnNumber, boolean isRemarkColumn) {
        Element element = this.doc.createElement("StringContent");
        element.setTextContent(this.checkForTestOutput("", columnNumber));
        if (isRemarkColumn) {
            this.addFootnoteContent(element, fc, columnNumber, isRemarkColumn);
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("no content at groupNumber=");
            _builder.append((Object)this.groupNumber);
            _builder.append(" column=");
            _builder.append((Object)columnNumber);
            logger.warn(_builder.toString());
        }
        return element;
    }

    private Element createCompareValueElement(String warning_mark, String value) {
        block13: {
            if (warning_mark == null) break block13;
            switch (warning_mark) {
                case "<!-- warning-mark-black -->": {
                    return this.doc.createElement("UnchangedValue");
                }
                case "<!-- warning-mark-yellow -->": {
                    return this.doc.createElement("OldValue");
                }
                case "<!-- warning-mark-red -->": {
                    return this.doc.createElement("NewValue");
                }
            }
            return null;
        }
        return null;
    }

    private Element _createContent(CompareCellContent content, FootnoteContainer fc, int columnNumber, boolean isRemarkColumn) {
        Element element = this.doc.createElement("DiffContent");
        Function<String, Element> _function = it -> this.doc.createElement("OldValue");
        Function<String, Element> _function_1 = it -> this.doc.createElement("UnchangedValue");
        Function<String, Element> _function_2 = it -> this.doc.createElement("NewValue");
        BiFunction<String, Element, Element> _function_3 = (text, child) -> this.addContentToElement((String)text, (Element)child, columnNumber, isRemarkColumn);
        Consumer<Element> _function_4 = it -> element.appendChild((Node)it);
        CellContentExtensions.formatCompareContent((Iterable)content.getOldValue(), (Iterable)content.getNewValue(), _function, _function_1, _function_2, _function_3).forEach(_function_4);
        if (isRemarkColumn) {
            this.addFootnoteContent(element, fc, columnNumber, isRemarkColumn);
        }
        return element;
    }

    private Element _createContent(MultiColorCellContent content, FootnoteContainer fc, int columnNumber, boolean isRemarkColumn) {
        Element element = this.doc.createElement("MultiColorContent");
        int i = 0;
        while (i < content.getValue().size()) {
            boolean _lessThan;
            element.appendChild(this.createMultiColorElement((MultiColorContent)content.getValue().get(i), columnNumber, isRemarkColumn));
            int _size = content.getValue().size();
            int _minus = _size - 1;
            boolean bl = _lessThan = i < _minus;
            if (_lessThan) {
                Element separator = this.doc.createElement("SimpleValue");
                separator.setTextContent(content.getSeparator());
                element.appendChild(separator);
            }
            ++i;
        }
        if (isRemarkColumn) {
            this.addFootnoteContent(element, fc, columnNumber, isRemarkColumn);
        }
        return element;
    }

    private Element _createContent(CompareTableCellContent content, FootnoteContainer fc, int columnNumber, boolean isRemarkColumn) {
        Element element = this.doc.createElement("CompareProjectContent");
        Element mainContentElement = this.createContent(content.getMainPlanCellContent(), fc, columnNumber, isRemarkColumn);
        element.appendChild(mainContentElement);
        return element;
    }

    private void addFootnoteChild(Element element, String content, String mark, int columnNumber, boolean isRemarkColumn) {
        Element child = this.createCompareValueElement(mark, content);
        element.appendChild(this.addContentToElement(content, child, columnNumber, isRemarkColumn));
    }

    private void _addFootnoteContent(Element element, Void fc, int columnNumber, boolean isRemarkColumn) {
    }

    private void _addFootnoteContent(Element element, SimpleFootnoteContainer fc, int columnNumber, boolean isRemarkColumn) {
        Functions.Function1 _function = it -> TableExtensions.getFootnoteInfo((EObject)fc, (Bearbeitungsvermerk)it);
        Iterable footNotesInfo = IterableExtensions.filterNull((Iterable)ListExtensions.map((List)fc.getFootnotes(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> {
            String _xifexpression = null;
            _xifexpression = this.remarkTextInlnie ? it.toText() : it.toShorthand();
            return _xifexpression;
        };
        String footnotes = CellContentExtensions.iterableToString((Iterable)IterableExtensions.map((Iterable)footNotesInfo, (Functions.Function1)_function_1), (String)"; ");
        this.addFootnoteChild(element, footnotes, "<!-- warning-mark-black -->", columnNumber, isRemarkColumn);
    }

    private void _addFootnoteContent(Element element, CompareFootnoteContainer fc, int columnNumber, boolean isRemarkColumn) {
        Functions.Function1 _function = it -> TableExtensions.getFootnoteInfo((EObject)fc, (Bearbeitungsvermerk)it);
        Functions.Function1 _function_1 = it -> {
            String _xifexpression = null;
            _xifexpression = this.remarkTextInlnie ? it.toText() : it.toShorthand();
            return _xifexpression;
        };
        String oldFootnotes = CellContentExtensions.iterableToString((Iterable)ListExtensions.map((List)ListExtensions.map((List)fc.getOldFootnotes(), (Functions.Function1)_function), (Functions.Function1)_function_1), (String)"; ");
        Functions.Function1 _function_2 = it -> TableExtensions.getFootnoteInfo((EObject)fc, (Bearbeitungsvermerk)it);
        Functions.Function1 _function_3 = it -> {
            String _xifexpression = null;
            _xifexpression = this.remarkTextInlnie ? it.toText() : it.toShorthand();
            return _xifexpression;
        };
        String newFootnotes = CellContentExtensions.iterableToString((Iterable)ListExtensions.map((List)ListExtensions.map((List)fc.getNewFootnotes(), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (String)"; ");
        Functions.Function1 _function_4 = it -> TableExtensions.getFootnoteInfo((EObject)fc, (Bearbeitungsvermerk)it);
        Functions.Function1 _function_5 = it -> {
            String _xifexpression = null;
            _xifexpression = this.remarkTextInlnie ? it.toText() : it.toShorthand();
            return _xifexpression;
        };
        String unchangedFootnotes = CellContentExtensions.iterableToString((Iterable)ListExtensions.map((List)ListExtensions.map((List)fc.getUnchangedFootnotes(), (Functions.Function1)_function_4), (Functions.Function1)_function_5), (String)"; ");
        this.addFootnoteChild(element, oldFootnotes, "<!-- warning-mark-yellow -->", columnNumber, isRemarkColumn);
        this.addFootnoteChild(element, unchangedFootnotes, "<!-- warning-mark-black -->", columnNumber, isRemarkColumn);
        this.addFootnoteChild(element, newFootnotes, "<!-- warning-mark-red -->", columnNumber, isRemarkColumn);
    }

    private Element createMultiColorElement(MultiColorContent content, int columnNumber, boolean isRemarkColumn) {
        if (content.getMultiColorValue() == null || content.isDisableMultiColor()) {
            String _stringFormat = content.getStringFormat();
            String _elvis = null;
            String _multiColorValue = content.getMultiColorValue();
            _elvis = _multiColorValue != null ? _multiColorValue : "";
            String cellValue = String.format(_stringFormat, _elvis);
            return this.createContentElement(cellValue, "SimpleValue", columnNumber, isRemarkColumn);
        }
        String multiColorValue = content.getStringFormat();
        Element multiColorElement = this.createContentElement(multiColorValue.replace("%s", ""), "MultiColorValue", columnNumber, isRemarkColumn);
        multiColorElement.setAttribute("multicolorValue", content.getMultiColorValue());
        return multiColorElement;
    }

    private Attr createColumnAttribute(int columnNumber) {
        Attr columnAttr = this.doc.createAttribute("column-number");
        columnAttr.setValue(Integer.toString(columnNumber));
        return columnAttr;
    }

    private Attr createRowSpanAttribute(int rowSpan) {
        Attr attr = this.doc.createAttribute("number-rows-spanned");
        attr.setValue(Integer.toString(rowSpan));
        return attr;
    }

    private Element createContentElement(String content, String elementName, int columnNumber, boolean isRemarkColumn) {
        Element element = this.doc.createElement(elementName);
        return this.addContentToElement(content, element, columnNumber, isRemarkColumn);
    }

    private Element addContentToElement(String content, Element element, int columnNumber, boolean isRemarkColumn) {
        String checkOutput = this.checkForTestOutput(content, columnNumber);
        String _xifexpression = null;
        _xifexpression = isRemarkColumn ? checkOutput : org.eclipse.set.utils.StringExtensions.intersperseWithZeroSpacesSC((String)checkOutput);
        element.setTextContent(_xifexpression);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(Titlebox titlebox) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Titlebox[]{titlebox});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_4;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_4.containsKey(_cacheKey)) {
                return this._createCache_transform_4.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("TitleBox");
            this._createCache_transform_4.put(_cacheKey, _result);
        }
        this._init_transform_1(_result, titlebox);
        return _result;
    }

    private void _init_transform_1(Element it, Titlebox titlebox) {
        Element titleboxElement = it;
        Consumer<Pair> _function = it_1 -> titleboxElement.appendChild(this.transform((Integer)it_1.getKey(), (String)it_1.getValue()));
        IterableExtensions.indexed((Iterable)((Iterable)Conversions.doWrapArray((Object)titlebox.getField()))).forEach(_function);
        titleboxElement.appendChild(this.transform(titlebox.getPlanningOffice()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(PlanningOffice po) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new PlanningOffice[]{po});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_5;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_5.containsKey(_cacheKey)) {
                return this._createCache_transform_5.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("PlanningOffice");
            this._createCache_transform_5.put(_cacheKey, _result);
        }
        this._init_transform_2(_result, po);
        return _result;
    }

    private void _init_transform_2(Element it, PlanningOffice po) {
        it.setAttributeNode(this.transformToAttr(po.getVariant(), "variant"));
        it.setAttributeNode(this.transformToAttr(po.getLogo(), "logo"));
        it.appendChild(this.transform(po.getName(), "Name"));
        it.appendChild(this.transform(po.getGroup(), "Group"));
        it.appendChild(this.transform(po.getLocation(), "Location"));
        it.appendChild(this.transform(po.getPhone(), "Phone"));
        it.appendChild(this.transform(po.getEmail(), "Email"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(StringField sf, String name) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{sf, name});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_6;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_6.containsKey(_cacheKey)) {
                return this._createCache_transform_6.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement(name);
            this._createCache_transform_6.put(_cacheKey, _result);
        }
        this._init_transform_2(_result, sf, name);
        return _result;
    }

    private void _init_transform_2(Element it, StringField sf, String name) {
        it.setTextContent(sf.getText());
        it.setAttributeNode(this.transformToAttr(sf.getFontsize(), "fontsize"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(int index, String value) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Serializable[]{Integer.valueOf(index), value});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_7;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_7.containsKey(_cacheKey)) {
                return this._createCache_transform_7.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Field");
            this._createCache_transform_7.put(_cacheKey, _result);
        }
        this._init_transform_3(_result, index, value);
        return _result;
    }

    private void _init_transform_3(Element it, int index, String value) {
        it.setAttributeNode(this.transformToAddressAttr(index));
        String _intersperseWithZeroSpacesSC = null;
        if (value != null) {
            _intersperseWithZeroSpacesSC = org.eclipse.set.utils.StringExtensions.intersperseWithZeroSpacesSC((String)value);
        }
        it.setTextContent(_intersperseWithZeroSpacesSC);
    }

    private Attr transformToAddressAttr(int index) {
        int address = index + 1;
        return this.transformToAttr(Integer.valueOf(address).toString(), "address");
    }

    private Attr transformToAttr(String value, String attr) {
        Attr it = this.doc.createAttribute(attr);
        it.setValue(value);
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transform(FreeFieldInfo freeFieldInfo) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new FreeFieldInfo[]{freeFieldInfo});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transform_8;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transform_8.containsKey(_cacheKey)) {
                return this._createCache_transform_8.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Freefield");
            this._createCache_transform_8.put(_cacheKey, _result);
        }
        this._init_transform_3(_result, freeFieldInfo);
        return _result;
    }

    private void _init_transform_3(Element it, FreeFieldInfo freeFieldInfo) {
        String significantInformation = freeFieldInfo.getSignificantInformation();
        if (significantInformation != null) {
            it.appendChild(this.transformToSignificantInformation(significantInformation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transformToSignificantInformation(String significantInformation) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new String[]{significantInformation});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transformToSignificantInformation;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transformToSignificantInformation.containsKey(_cacheKey)) {
                return this._createCache_transformToSignificantInformation.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("SignificantInformation");
            this._createCache_transformToSignificantInformation.put(_cacheKey, _result);
        }
        this._init_transformToSignificantInformation(_result, significantInformation);
        return _result;
    }

    private void _init_transformToSignificantInformation(Element it, String significantInformation) {
        it.setTextContent(significantInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element transformToFootnotes(Table table) {
        Element _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Table[]{table});
        HashMap<ArrayList<?>, Element> hashMap = this._createCache_transformToFootnotes;
        synchronized (hashMap) {
            Element _createElement;
            if (this._createCache_transformToFootnotes.containsKey(_cacheKey)) {
                return this._createCache_transformToFootnotes.get(_cacheKey);
            }
            _result = _createElement = this.doc.createElement("Footnotes");
            this._createCache_transformToFootnotes.put(_cacheKey, _result);
        }
        this._init_transformToFootnotes(_result, table);
        return _result;
    }

    private void _init_transformToFootnotes(Element it, Table table) {
        Element element = it;
        Consumer<TableExtensions.FootnoteInfo> _function = it_1 -> element.appendChild(this.transform((TableExtensions.FootnoteInfo)it_1));
        TableExtensions.getAllFootnotes((Table)table).forEach(_function);
    }

    private Element transform(TableExtensions.FootnoteInfo footnote) {
        Element it = this.doc.createElement("Footnote");
        Element footNoteType = this.doc.createElement(footnote.type.toString());
        footNoteType.setAttributeNode(this.createFootnoteAttribute(footnote.index));
        footNoteType.setTextContent(footnote.toText());
        it.appendChild(footNoteType);
        return it;
    }

    private Attr createFootnoteAttribute(Integer number) {
        Attr footnoteAttr = this.doc.createAttribute("footnote-number");
        footnoteAttr.setValue(Integer.toString(number));
        return footnoteAttr;
    }

    @XbaseGenerated
    private Element createCell(CellContent content, FootnoteContainer fc, int columnNumber, int rowSpan, boolean isRemarkColumn) {
        if (content != null) {
            return this._createCell(content, fc, columnNumber, rowSpan, isRemarkColumn);
        }
        if (content == null) {
            return this._createCell((Void)null, fc, columnNumber, rowSpan, isRemarkColumn);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(content, fc, columnNumber, rowSpan, isRemarkColumn).toString());
    }

    @XbaseGenerated
    private Element createContent(CellContent content, FootnoteContainer fc, int columnNumber, boolean isRemarkColumn) {
        if (content instanceof CompareCellContent) {
            return this._createContent((CompareCellContent)content, fc, columnNumber, isRemarkColumn);
        }
        if (content instanceof CompareTableCellContent) {
            return this._createContent((CompareTableCellContent)content, fc, columnNumber, isRemarkColumn);
        }
        if (content instanceof MultiColorCellContent) {
            return this._createContent((MultiColorCellContent)content, fc, columnNumber, isRemarkColumn);
        }
        if (content != null) {
            return this._createContent(content, fc, columnNumber, isRemarkColumn);
        }
        if (content == null) {
            return this._createContent((Void)null, fc, columnNumber, isRemarkColumn);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(content, fc, columnNumber, isRemarkColumn).toString());
    }

    @XbaseGenerated
    private void addFootnoteContent(Element element, FootnoteContainer fc, int columnNumber, boolean isRemarkColumn) {
        if (fc instanceof CompareFootnoteContainer) {
            this._addFootnoteContent(element, (CompareFootnoteContainer)fc, columnNumber, isRemarkColumn);
            return;
        }
        if (fc instanceof SimpleFootnoteContainer) {
            this._addFootnoteContent(element, (SimpleFootnoteContainer)fc, columnNumber, isRemarkColumn);
            return;
        }
        if (fc == null) {
            this._addFootnoteContent(element, (Void)null, columnNumber, isRemarkColumn);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element, fc, columnNumber, isRemarkColumn).toString());
    }
}

