/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.sszw;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.graph.TopologicalGraphService;
import org.eclipse.set.feature.table.pt1.AbstractPlanPro2TableModelTransformator;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Aussenelementansteuerung;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Aussenelementansteuerung_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Bezeichnung_AEA_TypeClass;
import org.eclipse.set.model.planpro.Ansteuerung_Element.ESTW_Zentraleinheit;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.planpro.Balisentechnik_ETCS.ETCS_W_Kr;
import org.eclipse.set.model.planpro.BasisTypen.BasisAttribut_AttributeGroup;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Tabelle_TypeClass;
import org.eclipse.set.model.planpro.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_Strecke_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Strecke_Km_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.Geodaten.Bezeichnung_Strecke_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.ENUMTOPAnschluss;
import org.eclipse.set.model.planpro.Geodaten.Oertlichkeit_Abkuerzung_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.Oertlichkeit_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.Strecke;
import org.eclipse.set.model.planpro.Geodaten.Strecke_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Signale.Signal;
import org.eclipse.set.model.planpro.Verweise.ID_Aussenelementansteuerung_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Grenzzeichen_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Strecke_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_W_Kr_Anlage_ohne_Proxy_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.ENUMWKrArt;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.ENUMWKrGspStellart;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Geschwindigkeit_L_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Geschwindigkeit_R_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Kreuzung_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Kreuzungsgleis_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Anlage;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Anlage_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Art_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Grundform_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Element_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Stellart_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Weiche_Element_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.ppmodel.extensions.AussenelementansteuerungExtensions;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.ESTW_ZentraleinheitExtensions;
import org.eclipse.set.ppmodel.extensions.ETCSWKrExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.StellBereichExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.UrObjectExtensions;
import org.eclipse.set.ppmodel.extensions.WKrAnlageExtensions;
import org.eclipse.set.ppmodel.extensions.WKrGspElementExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.geometry.GEOKanteGeometryExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Case;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;
import org.eclipse.set.utils.math.AgateRounding;
import org.eclipse.set.utils.math.BigDecimalExtensions;
import org.eclipse.set.utils.table.AbstractTableModelTransformator;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.osgi.service.event.EventAdmin;

public class SszwTransformator
extends AbstractPlanPro2TableModelTransformator {
    private TMFactory factory = null;
    private TopologicalGraphService topGraphService;
    private String tableShortcut;
    private final HashMap<ArrayList<?>, Table> _createCache_transform = CollectionLiterals.newHashMap();

    public SszwTransformator(Set<ColumnDescriptor> cols, EnumTranslationService enumTranslationService, EventAdmin eventAdmin, String tableShortcut) {
        super(cols, enumTranslationService, eventAdmin);
        this.topGraphService = Services.getTopGraphService();
        this.tableShortcut = tableShortcut;
    }

    public Table transformTableContent(MultiContainer_AttributeGroup container, TMFactory factory, Stell_Bereich controlArea) {
        this.factory = factory;
        return this.transform(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table transform(MultiContainer_AttributeGroup contanier) {
        Table _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new MultiContainer_AttributeGroup[]{contanier});
        HashMap<ArrayList<?>, Table> hashMap = this._createCache_transform;
        synchronized (hashMap) {
            Table _table;
            if (this._createCache_transform.containsKey(_cacheKey)) {
                return this._createCache_transform.get(_cacheKey);
            }
            _result = _table = this.factory.getTable();
            this._createCache_transform.put(_cacheKey, _result);
        }
        this._init_transform(_result, contanier);
        return _result;
    }

    private void _init_transform(Table it, MultiContainer_AttributeGroup contanier) {
        Functions.Function1 _function = it_1 -> UrObjectExtensions.isPlanningObject((Ur_Objekt)it_1);
        Consumer<ETCS_W_Kr> _function_1 = it_1 -> {
            boolean _isInterrupted = Thread.currentThread().isInterrupted();
            if (_isInterrupted) {
                return;
            }
            ID_W_Kr_Anlage_ohne_Proxy_TypeClass _iDWKrAnlage = it_1.getIDWKrAnlage();
            W_Kr_Anlage _value = null;
            if (_iDWKrAnlage != null) {
                _value = _iDWKrAnlage.getValue();
            }
            Consumer<W_Kr_Gsp_Element> _function_2 = gspElement -> this.transform((ETCS_W_Kr)it_1, (W_Kr_Gsp_Element)gspElement);
            WKrAnlageExtensions.getWKrGspElemente((W_Kr_Anlage)_value).forEach(_function_2);
        };
        org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)contanier.getETCSWKr(), (Functions.Function1)_function).forEach(_function_1);
    }

    private void transform(ETCS_W_Kr etcsWkr, W_Kr_Gsp_Element wKrGspElement) {
        TableRow row = this.factory.newTableRow((Ur_Objekt)etcsWkr);
        ID_W_Kr_Anlage_ohne_Proxy_TypeClass _iDWKrAnlage = etcsWkr.getIDWKrAnlage();
        W_Kr_Anlage _value = null;
        if (_iDWKrAnlage != null) {
            _value = _iDWKrAnlage.getValue();
        }
        W_Kr_Anlage refWKrAnlage = _value;
        Functions.Function1 _function = it -> {
            Bezeichnung_Element_AttributeGroup _bezeichnung = it.getBezeichnung();
            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
            if (_bezeichnung != null) {
                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
            }
            String _wert = null;
            if (_bezeichnungTabelle != null) {
                _wert = _bezeichnungTabelle.getWert();
            }
            return _wert;
        };
        this.fill(row, this.getColumn(this.cols, "A"), wKrGspElement, _function);
        Functions.Function1 _function_1 = it -> {
            String _elvis = null;
            W_Kr_Anlage_Allg_AttributeGroup _wKrAnlageAllg = it.getWKrAnlageAllg();
            W_Kr_Art_TypeClass _wKrArt = null;
            if (_wKrAnlageAllg != null) {
                _wKrArt = _wKrAnlageAllg.getWKrArt();
            }
            String _translate = null;
            if (_wKrArt != null) {
                _translate = this.translate((BasisAttribut_AttributeGroup)_wKrArt);
            }
            _elvis = _translate != null ? _translate : "";
            return _elvis;
        };
        this.fill(row, this.getColumn(this.cols, "B"), refWKrAnlage, _function_1);
        Functions.Function1 _function_2 = it -> {
            String _elvis = null;
            W_Kr_Anlage_Allg_AttributeGroup _wKrAnlageAllg = it.getWKrAnlageAllg();
            W_Kr_Grundform_TypeClass _wKrGrundform = null;
            if (_wKrAnlageAllg != null) {
                _wKrGrundform = _wKrAnlageAllg.getWKrGrundform();
            }
            String _wert = null;
            if (_wKrGrundform != null) {
                _wert = _wKrGrundform.getWert();
            }
            _elvis = _wert != null ? _wert : "";
            return _elvis;
        };
        this.fill(row, this.getColumn(this.cols, "C"), refWKrAnlage, _function_2);
        List<Pair<String, Optional<String>>> streckeInfos = this.getStreckeInfo(etcsWkr);
        Functions.Function1 _function_3 = it -> {
            Functions.Function1 _function_4 = it_1 -> (String)it_1.getKey();
            return ListExtensions.map((List)streckeInfos, (Functions.Function1)_function_4);
        };
        this.fillIterable(row, this.getColumn(this.cols, "D"), etcsWkr, _function_3, null);
        Functions.Function0 _function_4 = () -> GEOKanteGeometryExtensions.isFindGeometryComplete() || org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)ListExtensions.map((List)streckeInfos, it -> (Optional)it.getValue()), it -> it.isPresent());
        Functions.Function1 _function_5 = it -> {
            Functions.Function1 _function_6 = it_1 -> (Optional)it_1.getValue();
            Functions.Function1 _function_7 = it_1 -> it_1.isPresent();
            Functions.Function1 _function_8 = it_1 -> (String)it_1.get();
            List kmValues = org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)ListExtensions.map((List)streckeInfos, (Functions.Function1)_function_6), (Functions.Function1)_function_7), (Functions.Function1)_function_8));
            return kmValues;
        };
        this.fillIterableSingleCellWhenAllowed(row, this.getColumn(this.cols, "E"), etcsWkr, (Functions.Function0<? extends Boolean>)_function_4, _function_5, null, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, this.tableShortcut);
        Functions.Function1 _function_6 = it -> WKrAnlageExtensions.isSimpleTrackSwitch((W_Kr_Anlage)it);
        Functions.Function1 _function_7 = it -> {
            Punkt_Objekt_TOP_Kante_AttributeGroup potk = (Punkt_Objekt_TOP_Kante_AttributeGroup)IterableExtensions.getFirstOrNull((Iterable)it.getPunktObjektTOPKante());
            if (!(potk.getAbstand().getWert() == BigDecimal.ZERO && TopKanteExtensions.getTOPAnschlussA((TOP_Kante)PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)potk)) == ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS || potk.getAbstand().getWert() != BigDecimal.ZERO && TopKanteExtensions.getTOPAnschlussB((TOP_Kante)PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)potk)) == ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS)) {
                return false;
            }
            return true;
        };
        List<W_Kr_Gsp_Komponente> wKomponentEW_L = this.getGspKomponente(refWKrAnlage, wKrGspElement, (Functions.Function1<? super W_Kr_Anlage, ? extends Boolean>)_function_6, (Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends Boolean>)_function_7);
        Functions.Function1 _function_8 = it -> WKrAnlageExtensions.isSimpleTrackSwitch((W_Kr_Anlage)it);
        Functions.Function1 _function_9 = it -> {
            Punkt_Objekt_TOP_Kante_AttributeGroup potk = (Punkt_Objekt_TOP_Kante_AttributeGroup)IterableExtensions.getFirstOrNull((Iterable)it.getPunktObjektTOPKante());
            if (!(potk.getAbstand().getWert() == BigDecimal.ZERO && TopKanteExtensions.getTOPAnschlussA((TOP_Kante)PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)potk)) == ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS || potk.getAbstand().getWert() != BigDecimal.ZERO && TopKanteExtensions.getTOPAnschlussB((TOP_Kante)PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)potk)) == ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS)) {
                return false;
            }
            return true;
        };
        List<W_Kr_Gsp_Komponente> wKomponentEW_R = this.getGspKomponente(refWKrAnlage, wKrGspElement, (Functions.Function1<? super W_Kr_Anlage, ? extends Boolean>)_function_8, (Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends Boolean>)_function_9);
        Functions.Function1 _function_10 = it -> WKrAnlageExtensions.isCrossSwitch((W_Kr_Anlage)it);
        Functions.Function1 _function_11 = it -> {
            Zungenpaar_AttributeGroup _zungenpaar = it.getZungenpaar();
            Kreuzungsgleis_TypeClass _kreuzungsgleis = null;
            if (_zungenpaar != null) {
                _kreuzungsgleis = _zungenpaar.getKreuzungsgleis();
            }
            ENUMLinksRechts _wert = null;
            if (_kreuzungsgleis != null) {
                _wert = _kreuzungsgleis.getWert();
            }
            return _wert == ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS;
        };
        List<W_Kr_Gsp_Komponente> wKomponentDKW_EKW_L = this.getGspKomponente(refWKrAnlage, wKrGspElement, (Functions.Function1<? super W_Kr_Anlage, ? extends Boolean>)_function_10, (Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends Boolean>)_function_11);
        Functions.Function1 _function_12 = it -> WKrAnlageExtensions.isCrossSwitch((W_Kr_Anlage)it);
        Functions.Function1 _function_13 = it -> {
            Zungenpaar_AttributeGroup _zungenpaar = it.getZungenpaar();
            Kreuzungsgleis_TypeClass _kreuzungsgleis = null;
            if (_zungenpaar != null) {
                _kreuzungsgleis = _zungenpaar.getKreuzungsgleis();
            }
            ENUMLinksRechts _wert = null;
            if (_kreuzungsgleis != null) {
                _wert = _kreuzungsgleis.getWert();
            }
            return _wert == ENUMLinksRechts.ENUM_LINKS_RECHTS_RECHTS;
        };
        List<W_Kr_Gsp_Komponente> wKomponentDKW_EKW_R = this.getGspKomponente(refWKrAnlage, wKrGspElement, (Functions.Function1<? super W_Kr_Anlage, ? extends Boolean>)_function_12, (Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends Boolean>)_function_13);
        ColumnDescriptor _column = this.getColumn(this.cols, "F");
        Functions.Function1 _function_14 = it -> {
            boolean _isNullOrEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isNullOrEmpty((Iterable)wKomponentEW_L);
            return !_isNullOrEmpty;
        };
        Functions.Function1 _function_15 = it -> this.getWKrLaenge((W_Kr_Gsp_Element)it, wKomponentEW_L);
        Case _case = new Case(_function_14, _function_15);
        Functions.Function1 _function_16 = it -> {
            boolean _isNullOrEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isNullOrEmpty((Iterable)wKomponentDKW_EKW_L);
            return !_isNullOrEmpty;
        };
        Functions.Function1 _function_17 = it -> this.getWKrLaenge((W_Kr_Gsp_Element)it, wKomponentDKW_EKW_L);
        Case _case_1 = new Case(_function_16, _function_17);
        this.fillSwitch(row, _column, wKrGspElement, new Case[]{_case, _case_1});
        ColumnDescriptor _column_1 = this.getColumn(this.cols, "G");
        Functions.Function1 _function_18 = it -> {
            boolean _isNullOrEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isNullOrEmpty((Iterable)wKomponentEW_R);
            return !_isNullOrEmpty;
        };
        Functions.Function1 _function_19 = it -> this.getWKrLaenge((W_Kr_Gsp_Element)it, wKomponentEW_R);
        Case _case_2 = new Case(_function_18, _function_19);
        Functions.Function1 _function_20 = it -> {
            boolean _isNullOrEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isNullOrEmpty((Iterable)wKomponentDKW_EKW_R);
            return !_isNullOrEmpty;
        };
        Functions.Function1 _function_21 = it -> this.getWKrLaenge((W_Kr_Gsp_Element)it, wKomponentDKW_EKW_R);
        Case _case_3 = new Case(_function_20, _function_21);
        this.fillSwitch(row, _column_1, wKrGspElement, new Case[]{_case_2, _case_3});
        List trackSwitchTypes = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ENUMWKrArt[]{ENUMWKrArt.ENUMW_KR_ART_EW, ENUMWKrArt.ENUMW_KR_ART_IBW, ENUMWKrArt.ENUMW_KR_ART_ABW, ENUMWKrArt.ENUMW_KR_ART_DW, ENUMWKrArt.ENUMW_KR_ART_KLOTHOIDENWEICHE, ENUMWKrArt.ENUMW_KR_ART_KORBBOGENWEICHE, ENUMWKrArt.ENUMW_KR_ART_SONSTIGE, ENUMWKrArt.ENUMW_KR_ART_EKW, ENUMWKrArt.ENUMW_KR_ART_DKW}));
        Functions.Function1 _function_22 = it -> {
            Functions.Function1 _function_23 = it_1 -> {
                Zungenpaar_AttributeGroup _zungenpaar = it_1.getZungenpaar();
                Geschwindigkeit_L_TypeClass _geschwindigkeitL = null;
                if (_zungenpaar != null) {
                    _geschwindigkeitL = _zungenpaar.getGeschwindigkeitL();
                }
                BigInteger _wert = null;
                if (_geschwindigkeitL != null) {
                    _wert = _geschwindigkeitL.getWert();
                }
                return _wert;
            };
            Functions.Function1 _function_24 = it_1 -> {
                Zungenpaar_AttributeGroup _zungenpaar = it_1.getZungenpaar();
                Geschwindigkeit_L_TypeClass _geschwindigkeitL = null;
                if (_zungenpaar != null) {
                    _geschwindigkeitL = _zungenpaar.getGeschwindigkeitL();
                }
                BigInteger _wert = null;
                if (_geschwindigkeitL != null) {
                    _wert = _geschwindigkeitL.getWert();
                }
                return _wert;
            };
            Functions.Function1 _function_25 = it_1 -> trackSwitchTypes.contains(it_1);
            return this.getWKrGeschwindigkeit((W_Kr_Anlage)it, wKrGspElement, (Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends BigInteger>)_function_23, (Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends BigInteger>)_function_24, (Functions.Function1<? super ENUMWKrArt, ? extends Boolean>)_function_25, ENUMLinksRechts.ENUM_LINKS_RECHTS_RECHTS);
        };
        this.fill(row, this.getColumn(this.cols, "H"), refWKrAnlage, _function_22);
        Functions.Function1 _function_23 = it -> {
            Functions.Function1 _function_24 = it_1 -> {
                Zungenpaar_AttributeGroup _zungenpaar = it_1.getZungenpaar();
                Geschwindigkeit_R_TypeClass _geschwindigkeitR = null;
                if (_zungenpaar != null) {
                    _geschwindigkeitR = _zungenpaar.getGeschwindigkeitR();
                }
                BigInteger _wert = null;
                if (_geschwindigkeitR != null) {
                    _wert = _geschwindigkeitR.getWert();
                }
                return _wert;
            };
            Functions.Function1 _function_25 = it_1 -> {
                Zungenpaar_AttributeGroup _zungenpaar = it_1.getZungenpaar();
                Geschwindigkeit_R_TypeClass _geschwindigkeitR = null;
                if (_zungenpaar != null) {
                    _geschwindigkeitR = _zungenpaar.getGeschwindigkeitR();
                }
                BigInteger _wert = null;
                if (_geschwindigkeitR != null) {
                    _wert = _geschwindigkeitR.getWert();
                }
                return _wert;
            };
            Functions.Function1 _function_26 = it_1 -> trackSwitchTypes.contains(it_1);
            return this.getWKrGeschwindigkeit((W_Kr_Anlage)it, wKrGspElement, (Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends BigInteger>)_function_24, (Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends BigInteger>)_function_25, (Functions.Function1<? super ENUMWKrArt, ? extends Boolean>)_function_26, ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS);
        };
        this.fill(row, this.getColumn(this.cols, "I"), refWKrAnlage, _function_23);
        List crossTypes = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ENUMWKrArt[]{ENUMWKrArt.ENUMW_KR_ART_FLACHKREUZUNG, ENUMWKrArt.ENUMW_KR_ART_KR, ENUMWKrArt.ENUMW_KR_ART_SONSTIGE, ENUMWKrArt.ENUMW_KR_ART_EKW, ENUMWKrArt.ENUMW_KR_ART_DKW}));
        Functions.Function1 _function_24 = it -> {
            Functions.Function1 _function_25 = it_1 -> {
                Kreuzung_AttributeGroup _kreuzung = it_1.getKreuzung();
                Geschwindigkeit_L_TypeClass _geschwindigkeitL = null;
                if (_kreuzung != null) {
                    _geschwindigkeitL = _kreuzung.getGeschwindigkeitL();
                }
                BigInteger _wert = null;
                if (_geschwindigkeitL != null) {
                    _wert = _geschwindigkeitL.getWert();
                }
                return _wert;
            };
            Functions.Function1 _function_26 = it_1 -> {
                Zungenpaar_AttributeGroup _zungenpaar = it_1.getZungenpaar();
                Geschwindigkeit_L_TypeClass _geschwindigkeitL = null;
                if (_zungenpaar != null) {
                    _geschwindigkeitL = _zungenpaar.getGeschwindigkeitL();
                }
                BigInteger _wert = null;
                if (_geschwindigkeitL != null) {
                    _wert = _geschwindigkeitL.getWert();
                }
                return _wert;
            };
            Functions.Function1 _function_27 = it_1 -> crossTypes.contains(it_1);
            return this.getWKrGeschwindigkeit((W_Kr_Anlage)it, wKrGspElement, (Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends BigInteger>)_function_25, (Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends BigInteger>)_function_26, (Functions.Function1<? super ENUMWKrArt, ? extends Boolean>)_function_27, ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS);
        };
        this.fill(row, this.getColumn(this.cols, "H"), refWKrAnlage, _function_24);
        Functions.Function1 _function_25 = it -> {
            Functions.Function1 _function_26 = it_1 -> {
                Kreuzung_AttributeGroup _kreuzung = it_1.getKreuzung();
                Geschwindigkeit_R_TypeClass _geschwindigkeitR = null;
                if (_kreuzung != null) {
                    _geschwindigkeitR = _kreuzung.getGeschwindigkeitR();
                }
                BigInteger _wert = null;
                if (_geschwindigkeitR != null) {
                    _wert = _geschwindigkeitR.getWert();
                }
                return _wert;
            };
            Functions.Function1 _function_27 = it_1 -> {
                Zungenpaar_AttributeGroup _zungenpaar = it_1.getZungenpaar();
                Geschwindigkeit_R_TypeClass _geschwindigkeitR = null;
                if (_zungenpaar != null) {
                    _geschwindigkeitR = _zungenpaar.getGeschwindigkeitR();
                }
                BigInteger _wert = null;
                if (_geschwindigkeitR != null) {
                    _wert = _geschwindigkeitR.getWert();
                }
                return _wert;
            };
            Functions.Function1 _function_28 = it_1 -> crossTypes.contains(it_1);
            return this.getWKrGeschwindigkeit((W_Kr_Anlage)it, wKrGspElement, (Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends BigInteger>)_function_26, (Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends BigInteger>)_function_27, (Functions.Function1<? super ENUMWKrArt, ? extends Boolean>)_function_28, ENUMLinksRechts.ENUM_LINKS_RECHTS_RECHTS);
        };
        this.fill(row, this.getColumn(this.cols, "K"), refWKrAnlage, _function_25);
        Functions.Function1 _function_26 = it -> {
            Aussenelementansteuerung _aussenelementansteuerung = WKrGspElementExtensions.getAussenelementansteuerung((W_Kr_Gsp_Element)it);
            return _aussenelementansteuerung != null;
        };
        Functions.Function1 _function_27 = it -> {
            Functions.Function1 _function_28 = it_1 -> ESTW_ZentraleinheitExtensions.getOertlichkeitAbkuerzung((ESTW_Zentraleinheit)it_1);
            return org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)Iterables.filter((Iterable)WKrGspElementExtensions.getAussenelementansteuerung((W_Kr_Gsp_Element)it).getIDInformationPrimaer(), ESTW_Zentraleinheit.class), (Functions.Function1)_function_28));
        };
        this.fillIterableWithConditional(row, this.getColumn(this.cols, "L"), wKrGspElement, _function_26, _function_27, null, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
        Functions.Function1 _function_28 = it -> {
            Aussenelementansteuerung outsideControl = WKrGspElementExtensions.getAussenelementansteuerung((W_Kr_Gsp_Element)wKrGspElement);
            Functions.Function1 _function_29 = it_1 -> {
                ID_Aussenelementansteuerung_TypeClass _iDAussenelementansteuerung = it_1.getIDAussenelementansteuerung();
                Aussenelementansteuerung _value_1 = null;
                if (_iDAussenelementansteuerung != null) {
                    _value_1 = _iDAussenelementansteuerung.getValue();
                }
                return _value_1 == outsideControl;
            };
            boolean _exists = org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)BasisAttributExtensions.getContainer((EObject)it).getStellBereich(), (Functions.Function1)_function_29);
            if (_exists) {
                String _elvis = null;
                Oertlichkeit_Bezeichnung_AttributeGroup _bezeichnung = AussenelementansteuerungExtensions.getOertlichkeitNamensgebend((Aussenelementansteuerung)outsideControl).getBezeichnung();
                Oertlichkeit_Abkuerzung_TypeClass _oertlichkeitAbkuerzung = null;
                if (_bezeichnung != null) {
                    _oertlichkeitAbkuerzung = _bezeichnung.getOertlichkeitAbkuerzung();
                }
                String _wert = null;
                if (_oertlichkeitAbkuerzung != null) {
                    _wert = _oertlichkeitAbkuerzung.getWert();
                }
                if (_wert != null) {
                    _elvis = _wert;
                } else {
                    Aussenelementansteuerung_Bezeichnung_AttributeGroup _bezeichnung_1 = outsideControl.getBezeichnung();
                    Bezeichnung_AEA_TypeClass _bezeichnungAEA = null;
                    if (_bezeichnung_1 != null) {
                        _bezeichnungAEA = _bezeichnung_1.getBezeichnungAEA();
                    }
                    String _wert_1 = null;
                    if (_bezeichnungAEA != null) {
                        _wert_1 = _bezeichnungAEA.getWert();
                    }
                    _elvis = _wert_1;
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_elvis}));
            }
            Stell_Bereich _stellbereich = this.getStellbereich((ETCS_W_Kr)it);
            String _oertlichkeitBezeichnung = null;
            if (_stellbereich != null) {
                _oertlichkeitBezeichnung = StellBereichExtensions.getOertlichkeitBezeichnung((Stell_Bereich)_stellbereich);
            }
            return org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_oertlichkeitBezeichnung})));
        };
        this.fillIterable(row, this.getColumn(this.cols, "M"), etcsWkr, _function_28, null);
        Functions.Function1 _function_29 = it -> {
            W_Kr_Gsp_Element_Allg_AttributeGroup _wKrGspElementAllg = it.getWKrGspElementAllg();
            W_Kr_Gsp_Stellart_TypeClass _wKrGspStellart = null;
            if (_wKrGspElementAllg != null) {
                _wKrGspStellart = _wKrGspElementAllg.getWKrGspStellart();
            }
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ENUMWKrGspStellart[]{ENUMWKrGspStellart.ENUMW_KR_GSP_STELLART_ELEKTRISCH_ORTSGESTELLT, ENUMWKrGspStellart.ENUMW_KR_GSP_STELLART_MECHANISCH_ORTSGESTELLT})).contains(_wKrGspStellart.getWert());
        };
        Functions.Function1 _function_30 = it -> "x";
        this.fillConditional(row, this.getColumn(this.cols, "N"), wKrGspElement, _function_29, _function_30);
        Functions.Function1 _function_31 = it -> null;
        this.fill(row, this.getColumn(this.cols, "O"), etcsWkr, _function_31);
        this.fillFootnotes(row, (Basis_Objekt)etcsWkr);
    }

    private List<Pair<String, Optional<String>>> getStreckeInfo(ETCS_W_Kr etcsWKr) {
        ID_W_Kr_Anlage_ohne_Proxy_TypeClass _iDWKrAnlage = etcsWKr.getIDWKrAnlage();
        W_Kr_Anlage _value = null;
        if (_iDWKrAnlage != null) {
            _value = _iDWKrAnlage.getValue();
        }
        ENUMWKrArt _wKrAnlageArt = null;
        if (_value != null) {
            _wKrAnlageArt = WKrAnlageExtensions.getWKrAnlageArt((W_Kr_Anlage)_value);
        }
        if (_wKrAnlageArt != null) {
            switch (_wKrAnlageArt) {
                case ENUMW_KR_ART_ABW: 
                case ENUMW_KR_ART_DW: 
                case ENUMW_KR_ART_EW: 
                case ENUMW_KR_ART_IBW: 
                case ENUMW_KR_ART_KLOTHOIDENWEICHE: 
                case ENUMW_KR_ART_KORBBOGENWEICHE: {
                    W_Kr_Gsp_Komponente gspKomponent = (W_Kr_Gsp_Komponente)IterableExtensions.getFirstOrNull((Iterable)ETCSWKrExtensions.getWKrGspKomponents((ETCS_W_Kr)etcsWKr));
                    EList _punktObjektStrecke = null;
                    if (gspKomponent != null) {
                        _punktObjektStrecke = gspKomponent.getPunktObjektStrecke();
                    }
                    Punkt_Objekt_Strecke_AttributeGroup _firstOrNull = null;
                    if (_punktObjektStrecke != null) {
                        _firstOrNull = (Punkt_Objekt_Strecke_AttributeGroup)IterableExtensions.getFirstOrNull((Iterable)_punktObjektStrecke);
                    }
                    ID_Strecke_TypeClass _iDStrecke = null;
                    if (_firstOrNull != null) {
                        _iDStrecke = _firstOrNull.getIDStrecke();
                    }
                    Strecke _value_1 = null;
                    if (_iDStrecke != null) {
                        _value_1 = _iDStrecke.getValue();
                    }
                    Strecke strecke = _value_1;
                    String _elvis = null;
                    Strecke_Bezeichnung_AttributeGroup _bezeichnung = null;
                    if (strecke != null) {
                        _bezeichnung = strecke.getBezeichnung();
                    }
                    Bezeichnung_Strecke_TypeClass _bezeichnungStrecke = null;
                    if (_bezeichnung != null) {
                        _bezeichnungStrecke = _bezeichnung.getBezeichnungStrecke();
                    }
                    String _wert = null;
                    if (_bezeichnungStrecke != null) {
                        _wert = _bezeichnungStrecke.getWert();
                    }
                    _elvis = _wert != null ? _wert : "";
                    String bezeichnung = _elvis;
                    EList _punktObjektStrecke_1 = null;
                    if (gspKomponent != null) {
                        _punktObjektStrecke_1 = gspKomponent.getPunktObjektStrecke();
                    }
                    Punkt_Objekt_Strecke_AttributeGroup _firstOrNull_1 = null;
                    if (_punktObjektStrecke_1 != null) {
                        _firstOrNull_1 = (Punkt_Objekt_Strecke_AttributeGroup)IterableExtensions.getFirstOrNull((Iterable)_punktObjektStrecke_1);
                    }
                    Strecke_Km_TypeClass _streckeKm = _firstOrNull_1.getStreckeKm();
                    String _wert_1 = null;
                    if (_streckeKm != null) {
                        _wert_1 = _streckeKm.getWert();
                    }
                    String km = _wert_1;
                    Optional<String> _ofNullable = Optional.ofNullable(km);
                    Pair _mappedTo = Pair.of((Object)bezeichnung, _ofNullable);
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo}));
                }
                case ENUMW_KR_ART_DKW: 
                case ENUMW_KR_ART_EKW: 
                case ENUMW_KR_ART_FLACHKREUZUNG: 
                case ENUMW_KR_ART_KR: {
                    return this.getStreckeInfoOfCrossSwitch(etcsWKr);
                }
            }
            return null;
        }
        return null;
    }

    private List<Pair<String, Optional<String>>> getStreckeInfoOfCrossSwitch(ETCS_W_Kr etcsWKr) {
        boolean _tripleEquals;
        boolean _or = false;
        ID_W_Kr_Anlage_ohne_Proxy_TypeClass _iDWKrAnlage = null;
        if (etcsWKr != null) {
            _iDWKrAnlage = etcsWKr.getIDWKrAnlage();
        }
        W_Kr_Anlage _value = null;
        if (_iDWKrAnlage != null) {
            _value = _iDWKrAnlage.getValue();
        }
        boolean bl = _tripleEquals = _value == null;
        if (_tripleEquals) {
            _or = true;
        } else {
            boolean _isCrossSwitch;
            boolean _not;
            ID_W_Kr_Anlage_ohne_Proxy_TypeClass _iDWKrAnlage_1 = etcsWKr.getIDWKrAnlage();
            W_Kr_Anlage _value_1 = null;
            if (_iDWKrAnlage_1 != null) {
                _value_1 = _iDWKrAnlage_1.getValue();
            }
            _or = _not = !(_isCrossSwitch = WKrAnlageExtensions.isCrossSwitch(_value_1));
        }
        if (_or) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Functions.Function1 _function = potk -> {
            Functions.Function1 _function_1 = route -> {
                Optional<Object> routeKm = Optional.empty();
                boolean _isFindGeometryComplete = GEOKanteGeometryExtensions.isFindGeometryComplete();
                if (_isFindGeometryComplete) {
                    BigDecimal _streckeKmThroughProjection = PunktObjektTopKanteExtensions.getStreckeKmThroughProjection((Object)potk, (Strecke)route);
                    String _tableDecimal = null;
                    if (_streckeKmThroughProjection != null) {
                        _tableDecimal = BigDecimalExtensions.toTableDecimal((BigDecimal)_streckeKmThroughProjection);
                    }
                    routeKm = Optional.ofNullable(_tableDecimal);
                }
                Strecke_Bezeichnung_AttributeGroup _bezeichnung = route.getBezeichnung();
                Bezeichnung_Strecke_TypeClass _bezeichnungStrecke = null;
                if (_bezeichnung != null) {
                    _bezeichnungStrecke = _bezeichnung.getBezeichnungStrecke();
                }
                String _wert = null;
                if (_bezeichnungStrecke != null) {
                    _wert = _bezeichnungStrecke.getWert();
                }
                return Pair.of((Object)_wert, routeKm);
            };
            return ListExtensions.map((List)PunktObjektTopKanteExtensions.getStreckenThroughBereichObjekt((Punkt_Objekt_TOP_Kante_AttributeGroup)potk), (Functions.Function1)_function_1);
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.flatMap((Iterable)ETCSWKrExtensions.getPunktsObjektTopKante((ETCS_W_Kr)etcsWKr), (Functions.Function1)_function));
    }

    private List<W_Kr_Gsp_Komponente> getGspKomponente(W_Kr_Anlage wkrAnlage, W_Kr_Gsp_Element gspElement, Functions.Function1<? super W_Kr_Anlage, ? extends Boolean> wkrArtCondition, Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends Boolean> leftRightCondition) {
        boolean _not;
        Boolean _apply = (Boolean)wkrArtCondition.apply((Object)wkrAnlage);
        boolean bl = _not = _apply == false;
        if (_not) {
            return Collections.emptyList();
        }
        List gspKomponenten = WKrGspElementExtensions.getWKrGspKomponenten((W_Kr_Gsp_Element)gspElement);
        Functions.Function1 _function = it -> (Boolean)leftRightCondition.apply(it);
        return org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)gspKomponenten, (Functions.Function1)_function));
    }

    private String getWKrLaenge(W_Kr_Gsp_Element gspElement, List<W_Kr_Gsp_Komponente> gspKomponente) {
        Signal signal;
        Weiche_Element_AttributeGroup _weicheElement = gspElement.getWeicheElement();
        ID_Grenzzeichen_TypeClass _iDGrenzzeichen = null;
        if (_weicheElement != null) {
            _iDGrenzzeichen = _weicheElement.getIDGrenzzeichen();
        }
        Signal _value = null;
        if (_iDGrenzzeichen != null) {
            _value = _iDGrenzzeichen.getValue();
        }
        if ((signal = _value) == null) {
            return "";
        }
        TopPoint signalTopPoint = new TopPoint((Punkt_Objekt)signal);
        Functions.Function1 _function = it -> new TopPoint((Punkt_Objekt)it);
        Functions.Function1 _function_1 = gspPoint -> this.topGraphService.findShortestDistance(signalTopPoint, gspPoint);
        Functions.Function1 _function_2 = it -> it.orElse(null);
        Iterable distance = org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)ListExtensions.map((List)ListExtensions.map((List)ListExtensions.map(gspKomponente, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        String _xifexpression = null;
        boolean _isNullOrEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isNullOrEmpty((Iterable)distance);
        _xifexpression = _isNullOrEmpty ? "" : Long.valueOf(AgateRounding.roundDown((double)((BigDecimal)org.eclipse.xtext.xbase.lib.IterableExtensions.min((Iterable)distance)).doubleValue())).toString();
        return _xifexpression;
    }

    private String getWKrGeschwindigkeit(W_Kr_Anlage wKrAnlage, W_Kr_Gsp_Element gspElement, Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends BigInteger> allowSpeed, Functions.Function1<? super W_Kr_Gsp_Komponente, ? extends BigInteger> allowSpeedEKW_DKW, Functions.Function1<? super ENUMWKrArt, ? extends Boolean> typeCondition, ENUMLinksRechts leftRightCross) {
        boolean _not;
        ENUMWKrArt type = WKrAnlageExtensions.getWKrAnlageArt((W_Kr_Anlage)wKrAnlage);
        Boolean _apply = (Boolean)typeCondition.apply((Object)WKrAnlageExtensions.getWKrAnlageArt((W_Kr_Anlage)wKrAnlage));
        boolean bl = _not = _apply == false;
        if (_not) {
            return "";
        }
        if (type != null) {
            switch (type) {
                case ENUMW_KR_ART_DKW: 
                case ENUMW_KR_ART_EKW: {
                    Functions.Function1 _function = it -> {
                        Zungenpaar_AttributeGroup _zungenpaar = it.getZungenpaar();
                        Kreuzungsgleis_TypeClass _kreuzungsgleis = null;
                        if (_zungenpaar != null) {
                            _kreuzungsgleis = _zungenpaar.getKreuzungsgleis();
                        }
                        ENUMLinksRechts _wert = null;
                        if (_kreuzungsgleis != null) {
                            _wert = _kreuzungsgleis.getWert();
                        }
                        return _wert == leftRightCross;
                    };
                    W_Kr_Gsp_Komponente gspKomponent = (W_Kr_Gsp_Komponente)org.eclipse.xtext.xbase.lib.IterableExtensions.findFirst((Iterable)WKrGspElementExtensions.getWKrGspKomponenten((W_Kr_Gsp_Element)gspElement), (Functions.Function1)_function);
                    String _elvis = null;
                    BigInteger _apply_1 = (BigInteger)allowSpeedEKW_DKW.apply((Object)gspKomponent);
                    String _string = null;
                    if (_apply_1 != null) {
                        _string = _apply_1.toString();
                    }
                    _elvis = _string != null ? _string : "";
                    return _elvis;
                }
                case ENUMW_KR_ART_ABW: 
                case ENUMW_KR_ART_DW: 
                case ENUMW_KR_ART_EW: 
                case ENUMW_KR_ART_FLACHKREUZUNG: 
                case ENUMW_KR_ART_IBW: 
                case ENUMW_KR_ART_KLOTHOIDENWEICHE: 
                case ENUMW_KR_ART_KORBBOGENWEICHE: 
                case ENUMW_KR_ART_KR: 
                case ENUMW_KR_ART_SONSTIGE: {
                    W_Kr_Gsp_Komponente gspKomponent_1 = (W_Kr_Gsp_Komponente)IterableExtensions.getFirstOrNull((Iterable)WKrGspElementExtensions.getWKrGspKomponenten((W_Kr_Gsp_Element)gspElement));
                    String _elvis_1 = null;
                    BigInteger _apply_2 = (BigInteger)allowSpeed.apply((Object)gspKomponent_1);
                    String _string_1 = null;
                    if (_apply_2 != null) {
                        _string_1 = _apply_2.toString();
                    }
                    _elvis_1 = _string_1 != null ? _string_1 : "";
                    return _elvis_1;
                }
            }
        }
        return null;
    }

    private Stell_Bereich getStellbereich(ETCS_W_Kr etcsWKr) {
        ID_W_Kr_Anlage_ohne_Proxy_TypeClass _iDWKrAnlage = etcsWKr.getIDWKrAnlage();
        W_Kr_Anlage _value = null;
        if (_iDWKrAnlage != null) {
            _value = _iDWKrAnlage.getValue();
        }
        ENUMWKrArt _wKrAnlageArt = null;
        if (_value != null) {
            _wKrAnlageArt = WKrAnlageExtensions.getWKrAnlageArt((W_Kr_Anlage)_value);
        }
        if (_wKrAnlageArt != null) {
            switch (_wKrAnlageArt) {
                case ENUMW_KR_ART_ABW: 
                case ENUMW_KR_ART_DW: 
                case ENUMW_KR_ART_EW: 
                case ENUMW_KR_ART_IBW: 
                case ENUMW_KR_ART_KLOTHOIDENWEICHE: 
                case ENUMW_KR_ART_KORBBOGENWEICHE: {
                    List gspKomponenten = ETCSWKrExtensions.getWKrGspKomponents((ETCS_W_Kr)etcsWKr);
                    Functions.Function1 _function = area -> {
                        Functions.Function1 _function_1 = it -> StellBereichExtensions.isInControlArea((Stell_Bereich)area, (Basis_Objekt)it);
                        return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)gspKomponenten, (Functions.Function1)_function_1);
                    };
                    return (Stell_Bereich)IterableExtensions.getFirstOrNull((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)etcsWKr).getStellBereich(), (Functions.Function1)_function)));
                }
                case ENUMW_KR_ART_DKW: 
                case ENUMW_KR_ART_EKW: 
                case ENUMW_KR_ART_FLACHKREUZUNG: 
                case ENUMW_KR_ART_KR: {
                    List potks = ETCSWKrExtensions.getPunktsObjektTopKante((ETCS_W_Kr)etcsWKr);
                    Functions.Function1 _function_1 = area -> {
                        Functions.Function1 _function_2 = it -> PunktObjektTopKanteExtensions.isBelongToBereichObjekt((Punkt_Objekt_TOP_Kante_AttributeGroup)it, (Bereich_Objekt)area);
                        return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)potks, (Functions.Function1)_function_2);
                    };
                    return (Stell_Bereich)IterableExtensions.getFirstOrNull((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)etcsWKr).getStellBereich(), (Functions.Function1)_function_1)));
                }
            }
            return null;
        }
        return null;
    }
}

