/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import java.util.Optional;
import org.eclipse.set.model.planpro.PlanPro.Ausgabe_Fachdaten;
import org.eclipse.set.model.planpro.PlanPro.ENUMUntergewerkArt;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.planpro.PlanPro.Planung_Einzel;
import org.eclipse.set.model.planpro.PlanPro.Planung_Gruppe;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.PlanungEinzelExtensions;

public class AusgabeFachdatenExtensions {
    private AusgabeFachdatenExtensions() {
    }

    public static Optional<Ausgabe_Fachdaten> getAusgabeFachdaten(PlanPro_Schnittstelle schnittstelle) {
        return AusgabeFachdatenExtensions.getAusgabeFachdaten(schnittstelle, Optional.empty());
    }

    public static Optional<Ausgabe_Fachdaten> getAusgabeFachdaten(PlanPro_Schnittstelle schnittstelle, Planung_Gruppe planungGruppe) {
        return AusgabeFachdatenExtensions.getAusgabeFachdaten(schnittstelle, Optional.of(planungGruppe));
    }

    public static Optional<Ausgabe_Fachdaten> getAusgabeFachdaten(PlanPro_Schnittstelle schnittstelle, Optional<Planung_Gruppe> planungGruppe) {
        if (!PlanProSchnittstelleExtensions.isPlanning(schnittstelle)) {
            throw new UnsupportedOperationException("Single state plan not exist subwork");
        }
        if (planungGruppe.isEmpty()) {
            return Optional.of((Ausgabe_Fachdaten)schnittstelle.getLSTPlanung().getFachdaten().getAusgabeFachdaten().getFirst());
        }
        Optional<Planung_Einzel> lstPlanungEinzel = Optional.ofNullable(planungGruppe.get().getLSTPlanungEinzel());
        if (lstPlanungEinzel.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(PlanungEinzelExtensions.getAusgabeFachdaten(lstPlanungEinzel.get()));
    }

    public static Optional<Ausgabe_Fachdaten> getAusgabeFachdaten(PlanPro_Schnittstelle schnittstelle, ENUMUntergewerkArt subworkType) {
        if (!PlanProSchnittstelleExtensions.isPlanning(schnittstelle)) {
            throw new UnsupportedOperationException("Single state plan not exist subwork");
        }
        return schnittstelle.getLSTPlanung().getFachdaten().getAusgabeFachdaten().stream().filter(subwork -> subwork.getUntergewerkArt() != null && subwork.getUntergewerkArt().getWert() != null).filter(subwork -> subwork.getUntergewerkArt().getWert().equals((Object)subworkType)).findFirst();
    }
}

