/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.fileservice;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.PlanProFileResource;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.core.fileservice.AbstractToolboxFile;
import org.eclipse.set.core.fileservice.ToolboxIDResolver;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.model.planpro.PlanPro.DocumentRoot;
import org.eclipse.set.model.planpro.PlanPro.util.PlanProResourceImpl;

public class PlainToolboxFile
extends AbstractToolboxFile {
    private Path commonPath;
    private final EditingDomain editingDomain;
    private static final String TECHNICAL_RESOURCE_TYPE_NAME = "content";
    private final ToolboxFile.Format format;
    private boolean loadable;
    private final SessionService sessionService;
    private final ToolboxFileRole role;

    public PlainToolboxFile(PlainToolboxFile toolboxFile) {
        this.sessionService = toolboxFile.sessionService;
        this.commonPath = toolboxFile.commonPath;
        this.format = toolboxFile.format;
        this.editingDomain = toolboxFile.editingDomain;
        this.addResource(PathExtensions.getBaseFileName((Path)toolboxFile.getPath()), toolboxFile.getPlanProResource());
        this.loadable = false;
        this.role = toolboxFile.getRole();
    }

    PlainToolboxFile(SessionService sessionService, Path path, ToolboxFile.Format format, EditingDomain editingDomain, boolean loadable, ToolboxFileRole role) {
        this.sessionService = sessionService;
        this.commonPath = path;
        this.format = format;
        this.editingDomain = editingDomain;
        this.loadable = loadable;
        this.role = role;
    }

    public void copyAllMedia(ToolboxFile toolboxfile) {
        throw new UnsupportedOperationException();
    }

    public void copyMedia(ToolboxFile toolboxfile, String id) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void createMedia(Guid guid, byte[] data) {
        throw new UnsupportedOperationException();
    }

    public void delete(boolean close) throws IOException {
        Files.delete(this.commonPath);
    }

    public void deleteMedia(Guid guid) {
        throw new UnsupportedOperationException();
    }

    public Path getMediaPath(Guid guid) {
        throw new UnsupportedOperationException();
    }

    public List<String> getAllMedia() throws IOException {
        return new ArrayList<String>();
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public ToolboxFile.Format getFormat() {
        return this.format;
    }

    public byte[] getMedia(Guid guid) {
        throw new UnsupportedOperationException();
    }

    public Path getModelPath() {
        return this.commonPath;
    }

    public Path getPath() {
        return this.commonPath;
    }

    public boolean hasDetachedAttachments() {
        return false;
    }

    public boolean hasMedia(String id) {
        return false;
    }

    public boolean isLoadable() {
        return this.loadable;
    }

    public void openModel() throws IOException {
        if (!this.isLoadable()) {
            throw new IllegalStateException("Toolbox file not loadable.");
        }
        this.generateMD5CheckSum();
        this.loadResource(this.getModelPath(), this.editingDomain, Services.getPlanProVersionService());
        DocumentRoot doc = (DocumentRoot)this.getPlanProResource().getContents().getFirst();
        ToolboxIDResolver.resolveIDReferences(doc.getPlanProSchnittstelle());
    }

    @Override
    public void saveResource(XMLResource resource) throws IOException {
        if (!(resource instanceof PlanProResourceImpl) || !resource.getURI().isFile()) {
            throw new IllegalStateException(Optional.ofNullable(resource.getURI()).map(u -> "Illegal uri " + u.toString()).orElse("no uri"));
        }
        resource.save(null);
        this.editingDomain.getCommandStack().flush();
        this.loadable = true;
    }

    public void setPath(Path path) {
        this.commonPath = path;
        this.setResourcePath((Resource)this.getPlanProResource(), path);
    }

    public void setRole(ToolboxFileRole role) {
        throw new UnsupportedOperationException();
    }

    public void setTemporaryDirectory(Path path) {
    }

    @Override
    protected String getContentType(Path modelPath) {
        return modelPath == null ? TECHNICAL_RESOURCE_TYPE_NAME : PathExtensions.getBaseFileName((Path)modelPath);
    }

    public PlanProFileResource getPlanProResource() {
        Iterator resourcesIte = this.resources.values().iterator();
        return resourcesIte.hasNext() ? (PlanProFileResource)resourcesIte.next() : null;
    }

    public PlanProFileResource getLayoutResource() {
        throw new UnsupportedOperationException();
    }

    public Path getLayoutPath() {
        return null;
    }

    public void openLayout() throws IOException {
        throw new UnsupportedOperationException();
    }

    public ToolboxFileRole getRole() {
        return this.role;
    }
}

