/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.dialogservice;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractFileDialog
extends Dialog {
    protected AbstractFileDialog(Shell parentShell) {
        super(parentShell);
    }

    public int open() {
        this.create();
        Shell shell = this.getShell();
        Point size = this.getSize();
        int width = size.x;
        int height = size.y;
        shell.setSize(width, height);
        Shell parentShell = this.getParentShell();
        Point parentSize = parentShell.getSize();
        Point parentLocation = parentShell.getLocation();
        shell.setLocation(parentLocation.x + (parentSize.x - width) / 2, parentLocation.y + (parentSize.y - height) / 2);
        return super.open();
    }

    protected Point getSize() {
        Shell shell = this.getShell();
        Point size = shell.getSize();
        return new Point(size.x / 3, size.y * 2);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, this.getCloseLabel(), true);
        this.createButton(parent, 0, this.getOpenLabel(), false);
    }

    protected abstract String getOpenLabel();

    protected abstract String getCloseLabel();

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(this.getDialogTitle());
        Composite container = (Composite)super.createDialogArea(parent);
        Text text = new Text(container, 74);
        text.setLayoutData((Object)new GridData(1808));
        text.setText(this.getDialogMessage());
        return container;
    }

    protected abstract String getDialogTitle();

    protected abstract String getDialogMessage();
}

