/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.graph;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.basis.graph.TopPath;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.graph.BankService;
import org.eclipse.set.core.services.graph.TopologicalGraphService;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.Ueberhoehung;
import org.eclipse.set.model.planpro.Geodaten.Ueberhoehungslinie;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.MultiContainer_AttributeGroupExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.graph.TopObjectIterator;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=modelsession/change/topmodel", "event.topics=modelsession/close"}, service={EventHandler.class, BankService.class})
public class BankServiceImpl
implements BankService,
EventHandler {
    @Reference
    private TopologicalGraphService topGraph;
    @Reference
    private EventAdmin eventAdmin;
    @Reference
    private SessionService sessionService;
    private final Map<PlanPro_Schnittstelle, BankingInformationSession> bankingSessiones = new HashMap<PlanPro_Schnittstelle, BankingInformationSession>();
    private boolean isComplete = false;
    private static final Logger logger = LoggerFactory.getLogger(BankServiceImpl.class);
    private Thread findBankingThread;

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        if (topic.equals("modelsession/change/topmodel")) {
            final PlanPro_Schnittstelle planProSchnittstelle = (PlanPro_Schnittstelle)event.getProperty("org.eclipse.e4.data");
            final BankingInformationSession collection = this.getBankingSession(planProSchnittstelle);
            collection.getBankingInformations().clear();
            collection.getTopEdgeBanking().clear();
            this.findBankingThread = new Thread(){

                @Override
                public void run() {
                    try {
                        BankServiceImpl.this.isComplete = false;
                        BankServiceImpl.this.addBankingForContainer(collection, PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planProSchnittstelle, (ContainerType)ContainerType.INITIAL));
                        BankServiceImpl.this.addBankingForContainer(collection, PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planProSchnittstelle, (ContainerType)ContainerType.FINAL));
                        BankServiceImpl.this.addBankingForContainer(collection, PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planProSchnittstelle, (ContainerType)ContainerType.SINGLE));
                        BankServiceImpl.this.isComplete = true;
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("event.topics", "bankingservice/done");
                        BankServiceImpl.this.eventAdmin.sendEvent(new Event("bankingservice/done", properties));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            };
            this.findBankingThread.start();
        }
        if (topic.equals("modelsession/close")) {
            ToolboxFileRole role = (ToolboxFileRole)event.getProperty("org.eclipse.e4.data");
            if (role == ToolboxFileRole.SESSION) {
                this.bankingSessiones.clear();
            } else {
                PlanPro_Schnittstelle closed = this.sessionService.getLoadedSession(role).getPlanProSchnittstelle();
                this.bankingSessiones.remove(closed);
            }
            if (!this.isComplete) {
                this.findBankingThread.interrupt();
                this.isComplete = false;
            }
        }
    }

    private BankingInformationSession getBankingSession(Ur_Objekt object) {
        MultiContainer_AttributeGroup container = BasisAttributExtensions.getContainer((EObject)object);
        PlanPro_Schnittstelle planProSchnittstelle = MultiContainer_AttributeGroupExtensions.getPlanProSchnittstelle((MultiContainer_AttributeGroup)container);
        return this.getBankingSession(planProSchnittstelle);
    }

    private BankingInformationSession getBankingSession(PlanPro_Schnittstelle schnittStelle) {
        return this.bankingSessiones.computeIfAbsent(schnittStelle, k -> new BankingInformationSession());
    }

    private void addBankingForContainer(BankingInformationSession bankingSession, MultiContainer_AttributeGroup container) throws InterruptedException {
        if (container == null) {
            return;
        }
        for (Ueberhoehungslinie ueberhoehungslinie : container.getUeberhoehungslinie()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            try {
                BankService.BankingInformation bankingInformation = this.findTOPBanking(ueberhoehungslinie);
                if (bankingInformation == null) {
                    logger.debug("Can't find TopPath for Ueberhoehungslinie: {}", (Object)ueberhoehungslinie.getIdentitaet().getWert());
                    bankingSession.getBankingInformations().put(ueberhoehungslinie, Optional.empty());
                    continue;
                }
                logger.debug("Found TopPath for Ueberhoehungslinie: {}", (Object)ueberhoehungslinie.getIdentitaet().getWert());
                bankingSession.getBankingInformations().put(ueberhoehungslinie, Optional.of(bankingInformation));
            }
            catch (NullPointerException e) {
                logger.error(e.getMessage());
            }
        }
        for (Optional optional : bankingSession.getBankingInformations().values()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (optional.isEmpty()) continue;
            ((BankService.BankingInformation)optional.get()).path().edges().forEach(edge -> {
                bankingSession.getTopEdgeBanking().putIfAbsent((TOP_Kante)edge, new HashSet());
                bankingSession.getTopEdgeBanking().get(edge).add((BankService.BankingInformation)bankingInfo.get());
            });
        }
    }

    public BankService.BankingInformation findTOPBanking(Ueberhoehungslinie bankingLine) {
        Predicate<TopPath> predicate;
        BigDecimal distanceB;
        BigDecimal distanceA;
        BigDecimal topLengthDifference;
        BankingInformationSession bankingSession = this.getBankingSession((Ur_Objekt)bankingLine);
        Map<Ueberhoehungslinie, Optional<BankService.BankingInformation>> bankingInformations = bankingSession.getBankingInformations();
        if (bankingInformations.containsKey(bankingLine)) {
            Optional<BankService.BankingInformation> optional = bankingInformations.get(bankingLine);
            return optional.isEmpty() ? null : optional.get();
        }
        Ueberhoehung begin = bankingLine.getIDUeberhoehungA().getValue();
        Ueberhoehung end = bankingLine.getIDUeberhoehungB().getValue();
        if (begin == null || end == null) {
            return null;
        }
        BigDecimal bankingLineLength = bankingLine.getUeberhoehungslinieAllg().getUeberhoehungslinieLaenge().getWert();
        TOP_Kante beginEdge = ((Punkt_Objekt_TOP_Kante_AttributeGroup)begin.getPunktObjektTOPKante().get(0)).getIDTOPKante().getValue();
        if (beginEdge.equals(((Punkt_Objekt_TOP_Kante_AttributeGroup)end.getPunktObjektTOPKante().get(0)).getIDTOPKante().getValue()) && (topLengthDifference = (distanceA = ((Punkt_Objekt_TOP_Kante_AttributeGroup)begin.getPunktObjektTOPKante().get(0)).getAbstand().getWert()).subtract(distanceB = ((Punkt_Objekt_TOP_Kante_AttributeGroup)end.getPunktObjektTOPKante().get(0)).getAbstand().getWert()).abs().subtract(bankingLineLength).abs()).doubleValue() <= ToolboxConfiguration.getBankLineTopOffsetLimit()) {
            BigDecimal pathLength = beginEdge.getTOPKanteAllg().getTOPLaenge().getWert();
            return new BankService.BankingInformation(bankingLine, new TopPath(List.of(beginEdge), pathLength, pathLength));
        }
        int limit = (int)(bankingLineLength.doubleValue() + ToolboxConfiguration.getBankLineTopOffsetLimit() + 1.0);
        TopPath path = this.topGraph.findPathBetween(new TopPoint((Punkt_Objekt)begin), new TopPoint((Punkt_Objekt)end), limit, predicate = t -> {
            BigDecimal diff = t.length().subtract(bankingLineLength).abs();
            return diff.doubleValue() < ToolboxConfiguration.getBankLineTopOffsetLimit();
        });
        if (path == null) {
            return null;
        }
        return new BankService.BankingInformation(bankingLine, path);
    }

    public List<BankService.BankingInformation> findRelevantLineBankings(TopPoint point) {
        BankingInformationSession bankingSession = this.getBankingSession((Ur_Objekt)point.edge());
        Set<BankService.BankingInformation> bankingLines = bankingSession.getTopEdgeBanking().get(point.edge());
        return bankingLines.stream().filter(line -> line.isOnBankingLine(point)).toList();
    }

    public List<BigDecimal> findBankValue(TopPoint point) {
        List<BigDecimal> lineBankings;
        BankingInformationSession bankingSession = this.getBankingSession((Ur_Objekt)point.edge());
        if (bankingSession.getTopEdgeBanking().containsKey(point.edge()) && !(lineBankings = this.findRelevantLineBankings(point).stream().map(line -> BankServiceImpl.findBankingValue(point, line)).toList()).isEmpty()) {
            return lineBankings;
        }
        if (!this.isFindBankingComplete()) {
            return Collections.emptyList();
        }
        BigDecimal pointDistance = point.distance();
        Optional left = TopObjectIterator.getEdgeObjectsFromPoint((TOP_Kante)point.edge(), (boolean)false, (BigDecimal)pointDistance, Ueberhoehung.class).findFirst();
        Optional right = TopObjectIterator.getEdgeObjectsFromPoint((TOP_Kante)point.edge(), (boolean)true, (BigDecimal)pointDistance, Ueberhoehung.class).findFirst();
        if (!left.isPresent() || !right.isPresent()) {
            if (left.isPresent()) {
                return List.of(((Ueberhoehung)left.get()).getUeberhoehungAllg().getUeberhoehungHoehe().getWert());
            }
            if (right.isPresent()) {
                return List.of(((Ueberhoehung)right.get()).getUeberhoehungAllg().getUeberhoehungHoehe().getWert());
            }
            return List.of();
        }
        BigDecimal ueLeft = ((Ueberhoehung)left.get()).getUeberhoehungAllg().getUeberhoehungHoehe().getWert();
        BigDecimal ueRight = ((Ueberhoehung)right.get()).getUeberhoehungAllg().getUeberhoehungHoehe().getWert();
        BigDecimal leftPosition = ((Punkt_Objekt_TOP_Kante_AttributeGroup)((Ueberhoehung)left.get()).getPunktObjektTOPKante().get(0)).getAbstand().getWert();
        BigDecimal rightPosition = ((Punkt_Objekt_TOP_Kante_AttributeGroup)((Ueberhoehung)right.get()).getPunktObjektTOPKante().get(0)).getAbstand().getWert();
        BigDecimal length = leftPosition.subtract(rightPosition).abs();
        BigDecimal distanceLeft = leftPosition.subtract(pointDistance).abs();
        return List.of(BankServiceImpl.bankingDefault(ueRight.subtract(ueLeft), distanceLeft, length).add(ueLeft));
    }

    static BigDecimal findBankingValue(TopPoint point, BankService.BankingInformation bankInfo) {
        Ueberhoehungslinie bankingLine = bankInfo.line();
        BigDecimal pointDistance = (BigDecimal)bankInfo.path().getDistance(point).orElseThrow();
        BigDecimal ueLeft = bankingLine.getIDUeberhoehungA().getValue().getUeberhoehungAllg().getUeberhoehungHoehe().getWert();
        BigDecimal ueRight = bankingLine.getIDUeberhoehungB().getValue().getUeberhoehungAllg().getUeberhoehungHoehe().getWert();
        BigDecimal length = bankingLine.getUeberhoehungslinieAllg().getUeberhoehungslinieLaenge().getWert();
        BigDecimal leftPosition = (BigDecimal)bankInfo.path().getDistance(new TopPoint((Punkt_Objekt)bankingLine.getIDUeberhoehungA().getValue())).orElseThrow();
        BigDecimal rightPosition = (BigDecimal)bankInfo.path().getDistance(new TopPoint((Punkt_Objekt)bankingLine.getIDUeberhoehungB().getValue())).orElseThrow();
        BigDecimal distanceLeft = leftPosition.subtract(pointDistance).abs();
        BigDecimal distanceRight = rightPosition.subtract(pointDistance).abs();
        return BankServiceImpl.getBanking(bankingLine, ueLeft, ueRight, distanceLeft, distanceRight, length);
    }

    static BigDecimal getBanking(Ueberhoehungslinie bankingLine, BigDecimal left, BigDecimal right, BigDecimal distanceFromLeft, BigDecimal distanceFromRight, BigDecimal length) {
        BigDecimal h_start = left;
        BigDecimal h_end = right;
        BigDecimal h_between = h_end.subtract(h_start);
        switch (bankingLine.getUeberhoehungslinieAllg().getUeberhoehungslinieForm().getWert()) {
            case ENUM_UEBERHOEHUNGSLINIE_FORM_RAMPE_BLOSS: {
                return BankServiceImpl.bankingOfRampeBloss(h_between, distanceFromLeft, length).add(h_start);
            }
            case ENUM_UEBERHOEHUNGSLINIE_FORM_RAMPE_S: {
                return BankServiceImpl.bankingOfRampeS(h_between, distanceFromLeft, distanceFromRight, length).add(h_start);
            }
        }
        return BankServiceImpl.bankingDefault(h_between, distanceFromLeft, length).add(h_start);
    }

    private static BigDecimal bankingOfRampeBloss(BigDecimal h_between, BigDecimal distanceFromLeft, BigDecimal length) {
        if (distanceFromLeft.compareTo(length.divide(BigDecimal.valueOf(2L), 5, RoundingMode.HALF_UP)) > 0) {
            return BankServiceImpl.bankingDefault(h_between, distanceFromLeft, length);
        }
        BigDecimal a = h_between.multiply(BigDecimal.valueOf(3L)).multiply(distanceFromLeft.pow(2)).divide(length.pow(2), 5, RoundingMode.HALF_EVEN);
        BigDecimal b = h_between.multiply(BigDecimal.valueOf(2L)).multiply(distanceFromLeft.pow(3)).divide(length.pow(3), 5, RoundingMode.HALF_EVEN);
        return a.add(b.negate());
    }

    private static BigDecimal bankingOfRampeS(BigDecimal h_between, BigDecimal distanceFromLeft, BigDecimal distanceFromRight, BigDecimal length) {
        if (distanceFromLeft.compareTo(length.divide(BigDecimal.valueOf(2L), 5, RoundingMode.HALF_UP)) < 1) {
            return h_between.multiply(BigDecimal.valueOf(2L)).multiply(distanceFromLeft.pow(2)).divide(length.pow(2), 5, RoundingMode.HALF_UP);
        }
        return h_between.add(h_between.multiply(BigDecimal.valueOf(2L)).multiply(distanceFromRight.pow(2)).divide(length.pow(2), 5, RoundingMode.HALF_UP).negate());
    }

    private static BigDecimal bankingDefault(BigDecimal h_between, BigDecimal distanceFromLeft, BigDecimal length) {
        return h_between.multiply(distanceFromLeft).divide(length, 5, RoundingMode.HALF_EVEN);
    }

    public boolean isFindBankingComplete() {
        return this.isComplete;
    }

    private class BankingInformationSession {
        private final Map<TOP_Kante, Set<BankService.BankingInformation>> topEdgeBanking = new ConcurrentHashMap<TOP_Kante, Set<BankService.BankingInformation>>();
        private final Map<Ueberhoehungslinie, Optional<BankService.BankingInformation>> bankingInformations = new ConcurrentHashMap<Ueberhoehungslinie, Optional<BankService.BankingInformation>>();

        public Map<TOP_Kante, Set<BankService.BankingInformation>> getTopEdgeBanking() {
            return this.topEdgeBanking;
        }

        public Map<Ueberhoehungslinie, Optional<BankService.BankingInformation>> getBankingInformations() {
            return this.bankingInformations;
        }
    }
}

