/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.export.xsl.siteplan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.set.utils.export.xsl.siteplan.SiteplanXSLExtension;
import org.eclipse.set.utils.export.xsl.siteplan.SiteplanXSLPage;

public class SiteplanXSLPageBuilder {
    private final SiteplanXSLExtension.PageDIN pageDIN;
    private List<SiteplanXSLExtension.FoldingMark> builderFoldingMarks;
    private SiteplanXSLExtension.TitleBoxRegion builderTilteBox;
    private SiteplanXSLExtension.RegionBody builderRegionBody;
    private SiteplanXSLExtension.SignificantInformation builderSignificant;

    public SiteplanXSLPageBuilder(SiteplanXSLExtension.PageDIN pageDIN) {
        this.pageDIN = pageDIN;
        this.setFoldingMarks();
    }

    public SiteplanXSLPageBuilder setFoldingMarks(SiteplanXSLExtension.FoldingMark ... builderFoldingMarks) {
        Set positions = Arrays.stream(builderFoldingMarks).map(SiteplanXSLExtension.FoldingMark::position).collect(Collectors.toSet());
        if (positions.size() < builderFoldingMarks.length) {
            throw new IllegalArgumentException("Each region should have only a FoldingMark");
        }
        this.builderFoldingMarks = new ArrayList<SiteplanXSLExtension.FoldingMark>(Arrays.stream(builderFoldingMarks).toList());
        return this;
    }

    private void setFoldingMarks() {
        SiteplanXSLExtension.RegionPosition[] regionPositionArray = SiteplanXSLExtension.RegionPosition.values();
        int n = regionPositionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SiteplanXSLExtension.RegionPosition region = regionPositionArray[n2];
            if (region == SiteplanXSLExtension.RegionPosition.BEFORE || region == SiteplanXSLExtension.RegionPosition.AFTER) {
                this.setFoldingMarks(new SiteplanXSLExtension.FoldingMark(region, this.pageDIN.getFoldingMarkTopBottomWidth()));
            } else if (region == SiteplanXSLExtension.RegionPosition.START || region == SiteplanXSLExtension.RegionPosition.END) {
                this.setFoldingMarks(new SiteplanXSLExtension.FoldingMark(region, this.pageDIN.getFoldingMarkSide()));
            }
            ++n2;
        }
    }

    public SiteplanXSLPageBuilder setFoldingMarks(SiteplanXSLExtension.FoldingMark foldingMark) {
        if (this.builderFoldingMarks == null) {
            this.builderFoldingMarks = new ArrayList<SiteplanXSLExtension.FoldingMark>();
        }
        if (this.builderFoldingMarks.stream().anyMatch(mark -> mark.position() == foldingMark.position())) {
            throw new IllegalArgumentException("The FoldingMark for " + foldingMark.position().getRegionName() + " is already added");
        }
        this.builderFoldingMarks.add(foldingMark);
        return this;
    }

    public SiteplanXSLPageBuilder setTitleBoxRegion(SiteplanXSLExtension.TitleBoxRegion builderTitleBoxRegion) {
        this.builderTilteBox = builderTitleBoxRegion;
        return this;
    }

    public SiteplanXSLPageBuilder setTitleBoxRegion(SiteplanXSLExtension.RegionPosition position, double exent, double freefeldSize) {
        return this.setTitleBoxRegion(new SiteplanXSLExtension.TitleBoxRegion(position, exent, freefeldSize));
    }

    public SiteplanXSLPageBuilder setRegionBody(SiteplanXSLExtension.RegionBody regionBody) {
        this.builderRegionBody = regionBody;
        return this;
    }

    public SiteplanXSLPageBuilder setRegionBody(double width, double height) {
        return this.setRegionBody(new SiteplanXSLExtension.RegionBody(width, height));
    }

    public SiteplanXSLPageBuilder setSignificantInformation(SiteplanXSLExtension.SignificantInformation significant) {
        this.builderSignificant = significant;
        return this;
    }

    public SiteplanXSLPageBuilder setSignificantInformation(double width, double height) {
        return this.setSignificantInformation(new SiteplanXSLExtension.SignificantInformation(width, height));
    }

    public SiteplanXSLPageBuilder setSignificantInformation(double width) {
        return this.setSignificantInformation(new SiteplanXSLExtension.SignificantInformation(width));
    }

    public SiteplanXSLPage build() {
        return new SiteplanXSLPage(this.pageDIN, this.builderTilteBox, this.builderFoldingMarks, this.builderRegionBody, this.builderSignificant);
    }
}

