/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.emfforms;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.custom.model.VCustomControl;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.emfforms.spi.view.annotation.model.VAnnotation;
import org.eclipse.set.utils.StringExtensions;

public class Annotations {
    public static final String KEY_DEFAULT_VALUE = "Default";

    public static String getDomainModelValue(VControl element, String source, String key) {
        return Annotations.getDomainModelValue(element.getDomainModelReference(), source, key);
    }

    public static String getDomainModelValue(VDomainModelReference domainModelReference, String source, String key) {
        if (domainModelReference instanceof VFeaturePathDomainModelReference) {
            VFeaturePathDomainModelReference featureRef = (VFeaturePathDomainModelReference)domainModelReference;
            EStructuralFeature feature = featureRef.getDomainModelEFeature();
            return Annotations.getValue(feature, source, key);
        }
        return null;
    }

    public static String getValue(EStructuralFeature feature, String source, String key) {
        EList annotations = feature.getEAnnotations();
        for (EAnnotation annotation : annotations) {
            if (!StringExtensions.nullSafeEquals(annotation.getSource(), source)) continue;
            return (String)annotation.getDetails().get((Object)key);
        }
        return null;
    }

    public static String getViewModelValue(VElement element, String key) {
        EList attachments = element.getAttachments();
        for (VAttachment attachment : attachments) {
            VAnnotation annotation;
            if (!(attachment instanceof VAnnotation) || !(annotation = (VAnnotation)attachment).getKey().equals(key)) continue;
            return annotation.getValue();
        }
        return null;
    }

    public static List<String> getViewModelValues(VCustomControl element, String key) {
        LinkedList result = Lists.newLinkedList();
        EList attachments = element.getAttachments();
        for (VAttachment attachment : attachments) {
            VAnnotation annotation;
            if (!(attachment instanceof VAnnotation) || !(annotation = (VAnnotation)attachment).getKey().equals(key)) continue;
            result.add(annotation.getValue());
        }
        return result;
    }

    public static boolean hasDomainModelAnnotation(EStructuralFeature feature, String source) {
        EList annotations = feature.getEAnnotations();
        for (EAnnotation annotation : annotations) {
            if (!annotation.getSource().equals(source)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDomainModelAnnotation(VElement element, String source) {
        if (!(element instanceof VControl)) {
            return false;
        }
        VControl control = (VControl)element;
        VDomainModelReference modelRef = control.getDomainModelReference();
        if (!(modelRef instanceof VFeaturePathDomainModelReference)) {
            return false;
        }
        EStructuralFeature feature = ((VFeaturePathDomainModelReference)modelRef).getDomainModelEFeature();
        if (feature == null) {
            return false;
        }
        return Annotations.hasDomainModelAnnotation(feature, source);
    }

    public static boolean hasViewModelAnnotation(VElement element, String name) {
        EList attachments = element.getAttachments();
        for (VAttachment attachment : attachments) {
            VAnnotation annotation;
            if (!(attachment instanceof VAnnotation) || !(annotation = (VAnnotation)attachment).getKey().equals(name)) continue;
            return true;
        }
        return false;
    }
}

