/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.PlanPro.Ausgabe_Fachdaten;
import org.eclipse.set.model.planpro.PlanPro.ENUMUntergewerkArt;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class SubworkValid
implements PlazCheck {
    @Reference
    EnumTranslationService enumTranslationService;

    @Override
    public List<PlazError> run(IModelSession modelSession) {
        ArrayList<PlazError> errors = new ArrayList<PlazError>();
        Map<Ausgabe_Fachdaten, ENUMUntergewerkArt> subworkFromPlanGroup = SubworkValid.getSubworkFromPlanGroup(modelSession);
        if (!subworkFromPlanGroup.isEmpty()) {
            subworkFromPlanGroup.forEach((subwork, type) -> {
                PlazError error = this.validatePlanGroupSubwork((Ausgabe_Fachdaten)subwork, Optional.of(type));
                if (error != null) {
                    errors.add(error);
                }
            });
        }
        errors.addAll(this.validateSubworkTypeUnique(modelSession.getPlanProSchnittstelle()));
        return errors;
    }

    private PlazError validatePlanGroupSubwork(Ausgabe_Fachdaten subwork, Optional<ENUMUntergewerkArt> planGroupSubWorkType) {
        Optional subworkType = EObjectExtensions.getNullableObject((Object)subwork, s -> s.getUntergewerkArt().getWert());
        Map<String, String> subworkGuidMap = Map.of("GUID", subwork.getIdentitaet().getWert());
        if (subworkType.isPresent() && planGroupSubWorkType.isPresent() && subworkType.get() != planGroupSubWorkType.get()) {
            return this.createPlazError(subwork, "Die Ausgabe_Fachdaten {GUID} und die dazu geh\u00f6rige Planung_Gruppe haben verschiedene Untergewerk_Art", subworkGuidMap);
        }
        return null;
    }

    private List<PlazError> validateSubworkTypeUnique(PlanPro_Schnittstelle schnittstelle) {
        ArrayList<PlazError> errors = new ArrayList<PlazError>();
        Map<Optional, List<Ausgabe_Fachdaten>> groupBySubworkType = Streams.stream((Iterator)schnittstelle.eAllContents()).filter(Ausgabe_Fachdaten.class::isInstance).map(Ausgabe_Fachdaten.class::cast).collect(Collectors.groupingBy(subwork -> EObjectExtensions.getNullableObject((Object)subwork, s -> s.getUntergewerkArt().getWert())));
        groupBySubworkType.forEach((type, subworks) -> {
            Object t;
            Function<Ausgabe_Fachdaten, Map> getSubworkGuidMap = subwork -> Map.of("GUID", EObjectExtensions.getNullableObject((Object)subwork, s -> s.getIdentitaet().getWert()).orElse(""));
            if (type.isEmpty()) {
                subworks.forEach(ele -> {
                    boolean bl = errors.add(this.createPlazError((Ausgabe_Fachdaten)ele, "Die Ausgabe_Fachdaten {GUID} hat keine Untergewerk_Art", (Map)getSubworkGuidMap.apply((Ausgabe_Fachdaten)ele)));
                });
                return;
            }
            if (subworks.size() > 1 && (t = type.get()) instanceof ENUMUntergewerkArt) {
                ENUMUntergewerkArt untergewerkArt = (ENUMUntergewerkArt)t;
                String subworkTypeStr = this.enumTranslationService.translate((Enumerator)untergewerkArt).getAlternative();
                subworks.forEach(ele -> {
                    boolean bl = errors.add(this.createPlazError((Ausgabe_Fachdaten)ele, "Die Ausgabe_Fachdaten zu Untergewerk_Art {Type} ist nicht eindeutig.", Map.of("Type", subworkTypeStr)));
                });
            }
        });
        return errors;
    }

    private static Map<Ausgabe_Fachdaten, ENUMUntergewerkArt> getSubworkFromPlanGroup(IModelSession modelSession) {
        List lstPlanungProjekt = EObjectExtensions.getNullableObject((Object)modelSession, session -> session.getPlanProSchnittstelle().getLSTPlanung().getObjektmanagement().getLSTPlanungProjekt().stream().flatMap(lstPlanung -> lstPlanung.getLSTPlanungGruppe().stream()).toList()).orElse(Collections.emptyList());
        return lstPlanungProjekt.stream().map(group -> EObjectExtensions.getNullableObject((Object)group, g -> new Pair((Object)g.getLSTPlanungEinzel().getIDAusgabeFachdaten().getValue(), (Object)g.getPlanungGAllg().getUntergewerkArt().getWert()))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    private PlazError createPlazError(Ausgabe_Fachdaten subwork, String messages, Map<String, String> data) {
        PlazError plazError = PlazFactory.eINSTANCE.createPlazError();
        plazError.setObject((EObject)subwork);
        plazError.setType(this.checkType());
        plazError.setMessage(StringSubstitutor.replace((Object)messages, data, (String)"{", (String)"}"));
        return plazError;
    }

    @Override
    public String checkType() {
        return "Untergewerk Art";
    }

    @Override
    public String getDescription() {
        return "Jedes Untergewerk ist eindeutig und passt zu der zugeh\u00f6rigen Planung_Gruppe";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Die Untergewerke sind entweder nicht eindeutig oder passen nicht zu der zugeh\u00f6rigen Planung_Gruppe";
    }
}

