/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.Signale.Signal_Befestigung;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.osgi.service.component.annotations.Component;

@Component
public class SignalBefestigungReferencenValid
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public String checkType() {
        return "Signalbefestigungsketten";
    }

    @Override
    public String getDescription() {
        return "Die Verweisketten der Signalbefestigungen sind pausibel";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Die Signalbefestigung {GUID} enth\u00e4lt einen Ring in der Verweiskette";
    }

    @Override
    protected List<PlazError> run(MultiContainer_AttributeGroup container) {
        return Streams.stream((Iterable)container.getSignalBefestigung()).filter(mast -> {
            ArrayList<Signal_Befestigung> refChain = new ArrayList<Signal_Befestigung>();
            Optional current = Optional.of(mast);
            while (current.isPresent()) {
                if (refChain.contains(current.get())) {
                    return true;
                }
                refChain.add(current.get());
                current = EObjectExtensions.getNullableObject((Object)current.get(), e -> e.getIDSignalBefestigung().getValue());
            }
            return false;
        }).map(this::createError).toList();
    }

    private PlazError createError(Signal_Befestigung mast) {
        PlazError plazError = PlazFactory.eINSTANCE.createPlazError();
        String guid = EObjectExtensions.getNullableObject((Object)mast, e -> e.getIdentitaet().getWert()).orElse("");
        plazError.setSeverity(ValidationSeverity.ERROR);
        plazError.setObject((EObject)mast);
        plazError.setMessage(this.transformErrorMsg(Map.of("GUID", guid)));
        plazError.setType(this.checkType());
        return plazError;
    }
}

