/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.utils;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.set.basis.constants.ValidationResult;

public class ValidationOutcome {
    public static ValidationResult.FileValidateState getFileValidateState(List<ValidationResult> results) {
        ValidationResult.Outcome validationOutcome = ValidationOutcome.getValidationsOutcome(results, ValidationResult::getOutcome);
        if (validationOutcome == ValidationResult.Outcome.VALID || validationOutcome == ValidationResult.Outcome.NOT_SUPPORTED) {
            return ValidationResult.FileValidateState.VALID;
        }
        ValidationResult.Outcome xsdOutcome = ValidationOutcome.getValidationsOutcome(results, ValidationResult::getXsdOutcome);
        ValidationResult.Outcome emfOutcome = ValidationOutcome.getValidationsOutcome(results, ValidationResult::getEmfOutcome);
        if (!(xsdOutcome != ValidationResult.Outcome.VALID && xsdOutcome != ValidationResult.Outcome.NOT_SUPPORTED || emfOutcome != ValidationResult.Outcome.VALID && emfOutcome != ValidationResult.Outcome.NOT_SUPPORTED)) {
            return ValidationResult.FileValidateState.INCOMPLETE;
        }
        return ValidationResult.FileValidateState.INVALID;
    }

    public static ValidationResult.Outcome getValidationsOutcome(List<ValidationResult> results, Function<ValidationResult, ValidationResult.Outcome> outcome) {
        Stream<ValidationResult> resultsStream = results.stream().filter(Objects::nonNull);
        if (resultsStream.anyMatch(result -> outcome.apply((ValidationResult)result) == ValidationResult.Outcome.INVALID)) {
            return ValidationResult.Outcome.INVALID;
        }
        return ValidationResult.Outcome.VALID;
    }
}

