/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.edit;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.set.basis.emfforms.RendererContext;
import org.eclipse.set.feature.projectdata.Messages;
import org.eclipse.set.model.planpro.PlanPro.Akteur_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Name_Akteur_10_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Name_Akteur_5_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Name_Akteur_TypeClass;
import org.eclipse.set.ppmodel.extensions.utils.NameAkteurTransformation;
import org.eclipse.set.utils.ButtonAction;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class CopyNameButton
implements ButtonAction {
    private static final int BUTTON_WIDTH = 150;
    private final Messages messages;
    private final boolean enable;
    final Map<Button, RendererContext> buttonsToContext = Maps.newHashMap();

    public CopyNameButton(Messages messages, boolean enable) {
        this.messages = messages;
        this.enable = enable;
    }

    public String getText() {
        return this.messages.CopyNameButton_Text;
    }

    public int getWidth() {
        return 150;
    }

    public void register(RendererContext context) {
        Button button = (Button)context.get(Button.class);
        button.setEnabled(this.enable);
        this.buttonsToContext.put(button, context);
        button.addDisposeListener(e -> {
            RendererContext rendererContext = this.buttonsToContext.remove(button);
        });
    }

    public void refresh(Notification notification) {
        Name_Akteur_TypeClass nameAkteur;
        EObject eObject;
        Object notifier = notification.getNotifier();
        if (notifier instanceof Akteur_Allg_AttributeGroup) {
            Akteur_Allg_AttributeGroup akteurAllg = (Akteur_Allg_AttributeGroup)notifier;
            this.setButtonState(akteurAllg, akteurAllg.getNameAkteur());
        }
        if (notifier instanceof Name_Akteur_TypeClass && (eObject = (nameAkteur = (Name_Akteur_TypeClass)notifier).eContainer()) instanceof Akteur_Allg_AttributeGroup) {
            Akteur_Allg_AttributeGroup akteurAllg = (Akteur_Allg_AttributeGroup)eObject;
            this.setButtonState(akteurAllg, nameAkteur);
        }
    }

    private void setButtonState(Akteur_Allg_AttributeGroup aktuerAllg, Name_Akteur_TypeClass nameAkteur) {
        boolean shouldEnable = nameAkteur != null && nameAkteur.getWert() != null && !nameAkteur.getWert().isBlank();
        this.buttonsToContext.forEach((button, action) -> {
            Akteur_Allg_AttributeGroup buttonAkteurAllg;
            EObject eObject = (EObject)action.get(EObject.class);
            if (eObject instanceof Akteur_Allg_AttributeGroup && aktuerAllg == (buttonAkteurAllg = (Akteur_Allg_AttributeGroup)eObject) && !button.isDisposed() && button.getEnabled() != shouldEnable) {
                button.setEnabled(shouldEnable);
            }
        });
    }

    public void selected(SelectionEvent e) {
        RendererContext rendererContext = this.buttonsToContext.get(e.getSource());
        Akteur_Allg_AttributeGroup akteur = (Akteur_Allg_AttributeGroup)rendererContext.get(EObject.class);
        Name_Akteur_TypeClass nameAkteur = akteur.getNameAkteur();
        Text text = (Text)rendererContext.get(Text.class);
        NameAkteurTransformation transformation = new NameAkteurTransformation();
        VControl vControl = (VControl)rendererContext.get(VControl.class);
        VFeaturePathDomainModelReference domainModelReference = (VFeaturePathDomainModelReference)vControl.getDomainModelReference();
        Class type = domainModelReference.getDomainModelEFeature().getEType().getInstanceClass();
        Object transformed = transformation.transform(nameAkteur, type);
        if (transformed instanceof Name_Akteur_5_TypeClass) {
            Name_Akteur_5_TypeClass nameAkteur5 = (Name_Akteur_5_TypeClass)transformed;
            text.setText(nameAkteur5.getWert());
        } else if (transformed instanceof Name_Akteur_10_TypeClass) {
            Name_Akteur_10_TypeClass nameAkteur10 = (Name_Akteur_10_TypeClass)transformed;
            text.setText(nameAkteur10.getWert());
        }
    }
}

