/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.export;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.set.basis.export.CheckBoxTreeElement;
import org.eclipse.set.feature.export.checkboxmodel.CheckboxTreeModel;
import org.eclipse.set.ppmodel.extensions.utils.TableNameInfo;
import org.eclipse.set.services.table.TableService;
import org.eclipse.set.utils.table.TableInfo;

public class TableCheckboxTreeModel
extends CheckboxTreeModel {
    TableService tableService;

    public TableCheckboxTreeModel(List<CheckBoxTreeElement> elements, TableService tableService) {
        super(elements);
        this.tableService = tableService;
    }

    public CheckBoxTreeElement addElement(TableInfo info) {
        TableInfo.Pt1TableCategory category = info.category();
        CheckBoxTreeElement parent = Arrays.stream(this.getParentElements()).filter(ele -> ele.getId().equals(category.getId())).findFirst().orElse(null);
        if (parent == null) {
            parent = new CheckBoxTreeElement(category.getId(), category.toString());
            this.addElement(parent);
        }
        TableNameInfo nameInfo = this.tableService.getTableNameInfo(info.shortcut());
        CheckBoxTreeElement newElement = new CheckBoxTreeElement(nameInfo.getShortName().toLowerCase(), nameInfo.getFullDisplayName());
        this.addElement(parent, newElement);
        return newElement;
    }

    public Optional<CheckBoxTreeElement> getElement(TableInfo info) {
        TableNameInfo tableNameInfo = this.tableService.getTableNameInfo(info.shortcut());
        return this.getElement(info.category().getId(), tableNameInfo.getShortName().toLowerCase());
    }
}

