/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.siteplan;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.siteplan.SiteplanService;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.Schluesselabhaengigkeiten.Schloss;
import org.eclipse.set.model.siteplan.SiteplanObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=modelsession/change/model", "event.topics=siteplan/open", "event.topics=siteplan/open/firsttime"}, service={SiteplanService.class, EventHandler.class})
public class SiteplanServiceImpl
implements SiteplanService,
EventHandler {
    private Set<SiteplanObject> siteplanElements;
    private boolean isSiteplanLoading = false;
    private boolean isNotFirstTimeOpenSiteplan = false;

    /*
     * WARNING - void declaration
     */
    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "modelsession/change/model": {
                this.siteplanElements = new HashSet<SiteplanObject>();
                this.isNotFirstTimeOpenSiteplan = false;
                Services.setSiteplanService((SiteplanService)this);
                break;
            }
            case "siteplan/open": {
                void isLoading;
                Object object = event.getProperty("org.eclipse.e4.data");
                if (!(object instanceof Boolean)) break;
                Boolean bl = (Boolean)object;
                Boolean cfr_ignored_0 = (Boolean)object;
                this.isSiteplanLoading = isLoading.booleanValue();
                break;
            }
            case "siteplan/open/firsttime": {
                this.isNotFirstTimeOpenSiteplan = true;
                break;
            }
        }
    }

    public void addSiteplanElement(SiteplanObject object) {
        this.siteplanElements.add(object);
    }

    public Optional<SiteplanObject> getSiteplanElement(Ur_Objekt object) {
        if (object == null) {
            return Optional.empty();
        }
        Ur_Objekt ur_Objekt = object;
        Objects.requireNonNull(ur_Objekt);
        Ur_Objekt ur_Objekt2 = ur_Objekt;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Schloss.class}, (Object)ur_Objekt2, n)) {
            case 0 -> {
                Schloss schloss = (Schloss)ur_Objekt2;
                yield this.getSiteplanSspElement(schloss);
            }
            default -> this.findSiteplanElementWithGuid(object.getIdentitaet().getWert());
        };
    }

    public boolean isSiteplanElement(String guid) {
        if (!this.isNotFirstTimeOpenSiteplan) {
            return true;
        }
        Set guids = this.siteplanElements.stream().map(ele -> ele.getGuid()).filter(Objects::nonNull).collect(Collectors.toSet());
        return guids.contains(guid);
    }

    public boolean isSiteplanElement(Ur_Objekt object) {
        if (!this.isNotFirstTimeOpenSiteplan) {
            return true;
        }
        return this.getSiteplanElement(object).isPresent();
    }

    private Optional<SiteplanObject> getSiteplanSspElement(Schloss shloss) {
        if (shloss.getSchlossSsp() != null && shloss.getSchlossSsp().getIDSchluesselsperre() != null) {
            return this.findSiteplanElementWithGuid(shloss.getSchlossSsp().getIDSchluesselsperre().getWert());
        }
        return this.findSiteplanElementWithGuid(shloss.getIdentitaet().getWert());
    }

    private Optional<SiteplanObject> findSiteplanElementWithGuid(String guid) {
        return this.siteplanElements.stream().filter(ele -> ele.getGuid().equals(guid)).findFirst();
    }

    public boolean isSiteplanLoading() {
        return this.isSiteplanLoading;
    }

    public boolean isNotFirstTimeOpenSiteplan() {
        return this.isNotFirstTimeOpenSiteplan;
    }
}

