/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.dialogservice;

import java.util.List;
import org.eclipse.jface.dialogs.AbstractSelectionDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SelectValueDialog
extends AbstractSelectionDialog<String> {
    ListViewer listViewer;

    public SelectValueDialog(Shell parentShell, String dialogTitle, String dialogMessage, List<String> items) {
        super(parentShell);
        this.setTitle(dialogTitle);
        this.setMessage(dialogMessage);
        this.setInitialSelection(items);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        composite.setLayoutData((Object)data);
        this.listViewer = new ListViewer(composite, 2820);
        this.listViewer.getList().setLayoutData((Object)data);
        this.listViewer.getList().setFont(parent.getFont());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element == null ? "" : (String)element;
            }
        });
        this.listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listViewer.setInput((Object)this.getInitialSelection());
        this.listViewer.addSelectionChangedListener(event -> this.getButton(0).setEnabled(!event.getSelection().isEmpty()));
        this.listViewer.addDoubleClickListener(event -> this.okPressed());
        return composite;
    }

    protected void okPressed() {
        this.setResult((ISelection)this.listViewer.getStructuredSelection(), String.class);
        super.okPressed();
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 64);
        if (this.getMessage() != null && !this.getMessage().isEmpty()) {
            label.setText(this.getMessage());
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)label);
        }
        return label;
    }
}

