/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.BasisTypen.BasisAttribut_AttributeGroup;
import org.eclipse.set.model.planpro.BasisTypen.ID_Bearbeitungsvermerk_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.osgi.service.component.annotations.Component;

@Component
public class SonstigeRequiresBearbeitungsvermerk
implements PlazCheck {
    private static final String SONSTIGE_ENUM_WERT = "sonstige";
    private static final String ENUM_WERT_FEATURE_NAME = "wert";
    private static final String BEARBEITUNGSVERMERK_FEATURE_NAME = "iDBearbeitungsvermerk";

    @Override
    public List<PlazError> run(IModelSession modelSession) {
        TreeIterator contents = modelSession.getPlanProSchnittstelle().eAllContents();
        UnmodifiableIterator attributes = Iterators.filter((Iterator)contents, BasisAttribut_AttributeGroup.class);
        UnmodifiableIterator attributesWithSonstige = Iterators.filter((Iterator)attributes, this::isSonstigeEnumWert);
        UnmodifiableIterator attributesWithMissingBearbeitungsvermerk = Iterators.filter((Iterator)attributesWithSonstige, this::hasNoBearbeitungsVermerk);
        Iterator errors = Iterators.transform((Iterator)attributesWithMissingBearbeitungsvermerk, this::createError);
        return Lists.newArrayList((Iterator)errors);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSonstigeEnumWert(BasisAttribut_AttributeGroup attribute) {
        try {
            Object value;
            EStructuralFeature feature = attribute.eClass().getEStructuralFeature(ENUM_WERT_FEATURE_NAME);
            Object object = value = attribute.eGet(feature);
            if (object instanceof Enumerator) {
                void enumValue;
                Enumerator enumerator = (Enumerator)object;
                Enumerator cfr_ignored_0 = (Enumerator)object;
                if (enumValue.getLiteral().equals(SONSTIGE_ENUM_WERT)) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasNoBearbeitungsVermerk(EObject obj) {
        boolean hasBearbeitungsVermerk;
        Object object;
        EStructuralFeature feature = obj.eClass().getEStructuralFeature(BEARBEITUNGSVERMERK_FEATURE_NAME);
        if (feature != null && (object = obj.eGet(feature)) instanceof EList) {
            void list;
            EList eList = (EList)object;
            EList cfr_ignored_0 = (EList)object;
            if (!list.isEmpty() && list.get(0) instanceof ID_Bearbeitungsvermerk_TypeClass) {
                return false;
            }
        }
        boolean bl = hasBearbeitungsVermerk = false;
        if (!hasBearbeitungsVermerk && !(obj instanceof Ur_Objekt)) {
            return this.hasNoBearbeitungsVermerk(obj.eContainer());
        }
        if (!hasBearbeitungsVermerk) return true;
        return false;
    }

    private PlazError createError(BasisAttribut_AttributeGroup attribute) {
        PlazError err = PlazFactory.eINSTANCE.createPlazError();
        err.setMessage(this.getGeneralErrMsg());
        err.setType(this.checkType());
        err.setObject((EObject)attribute);
        err.setSeverity(ValidationSeverity.ERROR);
        return err;
    }

    @Override
    public String checkType() {
        return "Bearbeitungsvermerk";
    }

    @Override
    public String getDescription() {
        return String.format("Alles mit Referenz '%s' hat einen Bearbeitungsvermerk.", SONSTIGE_ENUM_WERT);
    }

    @Override
    public String getGeneralErrMsg() {
        return String.format("Fehlender Bearbeitungsvermerk bei Wert '%s'.", SONSTIGE_ENUM_WERT);
    }
}

