/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.ShortIterator;

public final class ShortIteratorIterate {
    private ShortIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(ShortIterator iterator, ShortProcedure procedure) {
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public static <R extends MutableShortCollection> R select(ShortIterator iterator, ShortPredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            short item = iterator.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableShortCollection> R reject(ShortIterator iterator, ShortPredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            short item = iterator.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(ShortIterator iterator, ShortToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator.hasNext()) {
            short item = iterator.next();
            targetCollection.add(function.valueOf(item));
        }
        return targetCollection;
    }

    public static short detectIfNone(ShortIterator iterator, ShortPredicate predicate, short ifNone) {
        while (iterator.hasNext()) {
            short item = iterator.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(ShortIterator iterator, ShortPredicate predicate) {
        int count = 0;
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    public static boolean anySatisfy(ShortIterator iterator, ShortPredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(ShortIterator iterator, ShortPredicate predicate) {
        while (iterator.hasNext()) {
            if (predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(ShortIterator iterator, ShortPredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(ShortIterator iterator, T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        while (iterator.hasNext()) {
            result = function.valueOf(result, iterator.next());
        }
        return result;
    }

    public static long sum(ShortIterator iterator) {
        long sum = 0L;
        while (iterator.hasNext()) {
            sum += (long)iterator.next();
        }
        return sum;
    }

    public static short max(ShortIterator iterator) {
        short max = iterator.next();
        while (iterator.hasNext()) {
            short next = iterator.next();
            if (max >= next) continue;
            max = next;
        }
        return max;
    }

    public static short min(ShortIterator iterator) {
        short min = iterator.next();
        while (iterator.hasNext()) {
            short next = iterator.next();
            if (next >= min) continue;
            min = next;
        }
        return min;
    }
}

