/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.internal;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.rap.e4.preferences.EPreference;
import org.eclipse.rap.e4.preferences.EPreferenceListener;
import org.eclipse.rap.e4.preferences.EPreferenceService;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class RAPPreferencesObjectSupplier
extends ExtendedObjectSupplier {
    private Map<String, List<PrefInjectionListener>> listenerCache = new HashMap<String, List<PrefInjectionListener>>();
    @Inject
    EPreferenceService preferenceService;

    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        if (descriptor == null) {
            return null;
        }
        Class<?> descriptorsClass = this.getDesiredClass(descriptor.getDesiredType());
        String nodePath = this.getNodePath(descriptor, requestor.getRequestingObjectClass());
        if (IEclipsePreferences.class.equals(descriptorsClass)) {
            return new WrappedPreference(this.getPreferencesService().getNode(nodePath));
        }
        if (EPreference.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getNode(nodePath);
        }
        String key = this.getKey(descriptor);
        if (key == null || nodePath == null || key.length() == 0 || nodePath.length() == 0) {
            return IInjector.NOT_A_VALUE;
        }
        if (track) {
            this.addListener(nodePath, requestor);
        }
        if (descriptorsClass.isPrimitive()) {
            if (descriptorsClass.equals(Boolean.TYPE)) {
                return this.getPreferencesService().getBoolean(nodePath, key, false);
            }
            if (descriptorsClass.equals(Integer.TYPE)) {
                return this.getPreferencesService().getInt(nodePath, key, 0);
            }
            if (descriptorsClass.equals(Double.TYPE)) {
                return this.getPreferencesService().getDouble(nodePath, key, 0.0);
            }
            if (descriptorsClass.equals(Float.TYPE)) {
                return Float.valueOf(this.getPreferencesService().getFloat(nodePath, key, 0.0f));
            }
            if (descriptorsClass.equals(Long.TYPE)) {
                return this.getPreferencesService().getLong(nodePath, key, 0L);
            }
        }
        if (String.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getString(nodePath, key);
        }
        if (Boolean.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getBoolean(nodePath, key, false);
        }
        if (Integer.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getInt(nodePath, key, 0);
        }
        if (Double.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getDouble(nodePath, key, 0.0);
        }
        if (Float.class.equals(descriptorsClass)) {
            return Float.valueOf(this.getPreferencesService().getFloat(nodePath, key, 0.0f));
        }
        if (Long.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getLong(nodePath, key, 0L);
        }
        return this.getPreferencesService().getString(nodePath, key);
    }

    private Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    private String getKey(IObjectDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Preference qualifier = (Preference)descriptor.getQualifier(Preference.class);
        return qualifier.value();
    }

    private String getNodePath(IObjectDescriptor descriptor, Class<?> requestingObject) {
        if (descriptor == null) {
            return null;
        }
        Preference qualifier = (Preference)descriptor.getQualifier(Preference.class);
        String nodePath = qualifier.nodePath();
        if (nodePath == null || nodePath.length() == 0) {
            if (requestingObject == null) {
                return null;
            }
            nodePath = FrameworkUtil.getBundle(requestingObject).getSymbolicName();
        }
        return nodePath;
    }

    private EPreferenceService getPreferencesService() {
        return this.preferenceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(String nodePath, IRequestor requestor) {
        PrefInjectionListener listener2;
        if (requestor == null) {
            return;
        }
        Map<String, List<PrefInjectionListener>> map = this.listenerCache;
        synchronized (map) {
            if (this.listenerCache.containsKey(nodePath)) {
                for (PrefInjectionListener listener2 : this.listenerCache.get(nodePath)) {
                    IRequestor previousRequestor = listener2.getRequestor();
                    if (!previousRequestor.equals(requestor)) continue;
                    return;
                }
            }
        }
        EPreference node = this.getPreferencesService().getNode(nodePath);
        listener2 = new PrefInjectionListener(node, requestor);
        node.addChangeListener(listener2);
        Map<String, List<PrefInjectionListener>> map2 = this.listenerCache;
        synchronized (map2) {
            if (this.listenerCache.containsKey(nodePath)) {
                this.listenerCache.get(nodePath).add(listener2);
            } else {
                ArrayList<PrefInjectionListener> listeningRequestors = new ArrayList<PrefInjectionListener>();
                listeningRequestors.add(listener2);
                this.listenerCache.put(nodePath, listeningRequestors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        Map<String, List<PrefInjectionListener>> map = this.listenerCache;
        synchronized (map) {
            for (List<PrefInjectionListener> listeners : this.listenerCache.values()) {
                if (listeners == null) continue;
                for (PrefInjectionListener listener : listeners) {
                    listener.stopListening();
                }
            }
            this.listenerCache.clear();
        }
    }

    @PreDestroy
    void shutdown() {
        this.removeAllListeners();
    }

    private static class PrefInjectionListener
    implements EPreferenceListener {
        private final IRequestor requestor;
        private final EPreference node;

        public PrefInjectionListener(EPreference node, IRequestor requestor) {
            this.node = node;
            this.requestor = requestor;
        }

        @Override
        public void preferenceChange() {
            if (!this.requestor.isValid()) {
                this.node.removeChangeListener(this);
                return;
            }
            this.requestor.resolveArguments(false);
            this.requestor.execute();
        }

        public IRequestor getRequestor() {
            return this.requestor;
        }

        public void stopListening() {
            this.node.removeChangeListener(this);
        }
    }

    public static class WrappedPreference
    implements IEclipsePreferences {
        private EPreference node;

        public WrappedPreference(EPreference node) {
            this.node = node;
        }

        public String absolutePath() {
            return null;
        }

        public String[] childrenNames() throws BackingStoreException {
            return null;
        }

        public void clear() throws BackingStoreException {
        }

        public void flush() throws BackingStoreException {
        }

        public String get(String arg0, String arg1) {
            return null;
        }

        public boolean getBoolean(String arg0, boolean arg1) {
            return false;
        }

        public byte[] getByteArray(String arg0, byte[] arg1) {
            return null;
        }

        public double getDouble(String arg0, double arg1) {
            return 0.0;
        }

        public float getFloat(String arg0, float arg1) {
            return 0.0f;
        }

        public int getInt(String arg0, int arg1) {
            return 0;
        }

        public long getLong(String arg0, long arg1) {
            return 0L;
        }

        public String[] keys() throws BackingStoreException {
            return null;
        }

        public String name() {
            return null;
        }

        public boolean nodeExists(String arg0) throws BackingStoreException {
            return false;
        }

        public Preferences parent() {
            return null;
        }

        public void put(String arg0, String arg1) {
        }

        public void putBoolean(String arg0, boolean arg1) {
        }

        public void putByteArray(String arg0, byte[] arg1) {
        }

        public void putDouble(String arg0, double arg1) {
        }

        public void putFloat(String arg0, float arg1) {
        }

        public void putInt(String arg0, int arg1) {
        }

        public void putLong(String arg0, long arg1) {
        }

        public void remove(String arg0) {
        }

        public void sync() throws BackingStoreException {
        }

        public void accept(IPreferenceNodeVisitor arg0) throws BackingStoreException {
        }

        public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener arg0) {
        }

        public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener arg0) {
        }

        public Preferences node(String arg0) {
            return null;
        }

        public void removeNode() throws BackingStoreException {
        }

        public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener arg0) {
        }

        public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener arg0) {
        }
    }
}

