/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.InetAddressPattern;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConditionalHandler
extends Handler.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalHandler.class);
    private final IncludeExclude<String> _methods = new IncludeExclude();
    private final IncludeExclude<String> _pathSpecs = new IncludeExclude(PathSpecSet.class);
    private final IncludeExcludeSet<Predicate<Request>, Request> _predicates = new IncludeExcludeSet(PredicateSet.class);
    private Predicate<Request> _handlePredicate;

    private ConditionalHandler() {
        this(false, null);
    }

    private ConditionalHandler(Handler nextHandler) {
        this(false, nextHandler);
    }

    private ConditionalHandler(boolean dynamic, Handler nextHandler) {
        super(dynamic, nextHandler);
    }

    public void clear() {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._methods.clear();
        this._pathSpecs.clear();
        this._predicates.clear();
    }

    IncludeExclude<String> getMethods() {
        return this._methods;
    }

    IncludeExclude<String> getPathSpecs() {
        return this._pathSpecs;
    }

    IncludeExcludeSet<Predicate<Request>, Request> getPredicates() {
        return this._predicates;
    }

    public void includeMethod(String ... methods) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._methods.include((Object[])methods);
    }

    public void excludeMethod(String ... methods) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._methods.exclude((Object[])methods);
    }

    public void include(PathSpec ... paths) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        for (PathSpec p : paths) {
            ((PathSpecSet)this._pathSpecs.getIncluded()).add(p);
        }
    }

    public void exclude(PathSpec ... paths) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        for (PathSpec p : paths) {
            ((PathSpecSet)this._pathSpecs.getExcluded()).add(p);
        }
    }

    public void includePath(String ... paths) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._pathSpecs.include((Object[])paths);
    }

    public void excludePath(String ... paths) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._pathSpecs.exclude((Object[])paths);
    }

    public void include(InetAddressPattern ... patterns) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        for (InetAddressPattern p : patterns) {
            this._predicates.include((Object)new InetAddressPatternPredicate(p));
        }
    }

    public void includeInetAddressPattern(String ... patterns) {
        for (String p : patterns) {
            this.include(InetAddressPattern.from((String)p));
        }
    }

    public void exclude(InetAddressPattern ... patterns) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        for (InetAddressPattern p : patterns) {
            this._predicates.exclude((Object)new InetAddressPatternPredicate(p));
        }
    }

    public void excludeInetAddressPattern(String ... patterns) {
        for (String p : patterns) {
            this.exclude(InetAddressPattern.from((String)p));
        }
    }

    @SafeVarargs
    public final void include(Predicate<Request> ... predicates) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        for (Predicate<Request> p : predicates) {
            if (p instanceof MethodPredicate) {
                MethodPredicate methodPredicate = (MethodPredicate)p;
                this.includeMethod(methodPredicate._method);
                continue;
            }
            if (p instanceof PathSpecPredicate) {
                PathSpecPredicate pathSpecPredicate = (PathSpecPredicate)p;
                this.include(pathSpecPredicate._pathSpec);
                continue;
            }
            this._predicates.include(p);
        }
    }

    @SafeVarargs
    public final void exclude(Predicate<Request> ... predicates) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        for (Predicate<Request> p : predicates) {
            if (p instanceof MethodPredicate) {
                MethodPredicate methodPredicate = (MethodPredicate)p;
                this.excludeMethod(methodPredicate._method);
                continue;
            }
            if (p instanceof PathSpecPredicate) {
                PathSpecPredicate pathSpecPredicate = (PathSpecPredicate)p;
                this.exclude(pathSpecPredicate._pathSpec);
                continue;
            }
            this._predicates.exclude(p);
        }
    }

    private boolean testMethods(Request request) {
        return this._methods.test((Object)request.getMethod());
    }

    private boolean testPathSpecs(Request request) {
        return this._pathSpecs.test((Object)Request.getPathInContext(request));
    }

    private boolean testPredicates(Request request) {
        return this._predicates.test((Object)request);
    }

    @Override
    protected void doStart() throws Exception {
        this._handlePredicate = TypeUtil.truePredicate();
        if (!this._methods.isEmpty()) {
            this._handlePredicate = this._handlePredicate.and(this::testMethods);
        }
        if (!this._pathSpecs.isEmpty()) {
            this._handlePredicate = this._handlePredicate.and(this::testPathSpecs);
        }
        if (!this._predicates.isEmpty()) {
            this._handlePredicate = this._handlePredicate.and(this::testPredicates);
        }
        super.doStart();
    }

    @Override
    public final boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (this._handlePredicate.test(request)) {
            return this.onConditionsMet(request, response, callback);
        }
        return this.onConditionsNotMet(request, response, callback);
    }

    protected abstract boolean onConditionsMet(Request var1, Response var2, Callback var3) throws Exception;

    protected abstract boolean onConditionsNotMet(Request var1, Response var2, Callback var3) throws Exception;

    protected boolean nextHandler(Request request, Response response, Callback callback) throws Exception {
        return super.handle(request, response, callback);
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{new DumpableCollection("included methods", (Collection)this._methods.getIncluded()), new DumpableCollection("included paths", (Collection)this._pathSpecs.getIncluded()), new DumpableCollection("included predicates", (Collection)this._predicates.getIncluded()), new DumpableCollection("excluded methods", (Collection)this._methods.getExcluded()), new DumpableCollection("excluded paths", (Collection)this._pathSpecs.getExcluded()), new DumpableCollection("excluded predicates", (Collection)this._predicates.getExcluded())});
    }

    public static Predicate<Request> from(String connectorName, String inetAddressPattern, String method, String pathSpec) {
        return ConditionalHandler.from(connectorName, InetAddressPattern.from((String)inetAddressPattern), method, pathSpec == null ? null : PathSpec.from((String)pathSpec));
    }

    public static Predicate<Request> from(String connectorName, InetAddressPattern inetAddressPattern, String method, PathSpec pathSpec) {
        Predicate<Request> predicate = TypeUtil.truePredicate();
        if (connectorName != null) {
            predicate = predicate.and(new ConnectorPredicate(connectorName));
        }
        if (inetAddressPattern != null) {
            predicate = predicate.and(new InetAddressPatternPredicate(inetAddressPattern));
        }
        if (method != null) {
            predicate = predicate.and(new MethodPredicate(method));
        }
        if (pathSpec != null) {
            predicate = predicate.and(new PathSpecPredicate(pathSpec));
        }
        return predicate;
    }

    public static class PredicateSet
    extends AbstractSet<Predicate<Request>>
    implements Set<Predicate<Request>>,
    Predicate<Request> {
        private final ArrayList<Predicate<Request>> _predicates = new ArrayList();

        @Override
        public boolean add(Predicate<Request> predicate) {
            if (this._predicates.contains(predicate)) {
                return false;
            }
            return this._predicates.add(predicate);
        }

        @Override
        public boolean remove(Object o) {
            return this._predicates.remove(o);
        }

        @Override
        public Iterator<Predicate<Request>> iterator() {
            return this._predicates.iterator();
        }

        @Override
        public int size() {
            return this._predicates.size();
        }

        @Override
        public boolean test(Request request) {
            if (request == null) {
                return false;
            }
            for (Predicate<Request> predicate : this._predicates) {
                if (!predicate.test(request)) continue;
                return true;
            }
            return false;
        }
    }

    public static class InetAddressPatternPredicate
    implements Predicate<Request> {
        private final InetAddressPattern _pattern;

        public static InetAddress getInetAddress(SocketAddress socketAddress) {
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                if (inetSocketAddress.isUnresolved()) {
                    try {
                        return InetAddress.getByName(inetSocketAddress.getHostString());
                    }
                    catch (UnknownHostException e) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("ignored", (Throwable)e);
                        }
                        return null;
                    }
                }
                return inetSocketAddress.getAddress();
            }
            return null;
        }

        public InetAddressPatternPredicate(InetAddressPattern pattern) {
            this._pattern = pattern;
        }

        @Override
        public boolean test(Request request) {
            return this._pattern.test((Object)InetAddressPatternPredicate.getInetAddress(request.getConnectionMetaData().getRemoteSocketAddress()));
        }

        public int hashCode() {
            return this._pattern.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (!(other instanceof InetAddressPatternPredicate)) return false;
            InetAddressPatternPredicate inetAddressPatternPredicate = (InetAddressPatternPredicate)other;
            if (!this._pattern.equals((Object)inetAddressPatternPredicate._pattern)) return false;
            return true;
        }

        public String toString() {
            return "%s@%x{%s}".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this._pattern);
        }
    }

    public static class MethodPredicate
    implements Predicate<Request> {
        private final String _method;

        public MethodPredicate(String method) {
            this._method = Objects.requireNonNull(method);
        }

        @Override
        public boolean test(Request request) {
            return this._method.equals(request.getMethod());
        }

        public int hashCode() {
            return this._method.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof MethodPredicate)) return false;
            MethodPredicate other = (MethodPredicate)obj;
            if (!this._method.equals(other._method)) return false;
            return true;
        }

        public String toString() {
            return String.format("%s@%x{%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this._method);
        }
    }

    public static class PathSpecPredicate
    implements Predicate<Request> {
        private final PathSpec _pathSpec;

        public PathSpecPredicate(PathSpec pathSpec) {
            this._pathSpec = Objects.requireNonNull(pathSpec);
        }

        @Override
        public boolean test(Request request) {
            return this._pathSpec.matches(Request.getPathInContext(request));
        }

        public int hashCode() {
            return this._pathSpec.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof PathSpecPredicate)) return false;
            PathSpecPredicate other = (PathSpecPredicate)obj;
            if (!this._pathSpec.equals((Object)other._pathSpec)) return false;
            return true;
        }

        public String toString() {
            return String.format("%s@%x{%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this._pathSpec);
        }
    }

    public static class ConnectorPredicate
    implements Predicate<Request> {
        private final String _connector;

        public ConnectorPredicate(String connector) {
            this._connector = Objects.requireNonNull(connector);
        }

        @Override
        public boolean test(Request request) {
            return this._connector.equals(request.getConnectionMetaData().getConnector().getName());
        }

        public int hashCode() {
            return this._connector.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof ConnectorPredicate)) return false;
            ConnectorPredicate other = (ConnectorPredicate)obj;
            if (!this._connector.equals(other._connector)) return false;
            return true;
        }

        public String toString() {
            return String.format("%s@%x{%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this._connector);
        }
    }

    public static class SkipNext
    extends ElseNext {
        public SkipNext() {
        }

        public SkipNext(Handler handler) {
            super(handler);
        }

        @Override
        protected boolean onConditionsMet(Request request, Response response, Callback callback) throws Exception {
            Handler handler = this.getHandler();
            if (!(handler instanceof Handler.Singleton)) {
                return false;
            }
            Handler.Singleton nextHandler = (Handler.Singleton)handler;
            Handler nextNext = nextHandler.getHandler();
            return nextNext != null && nextNext.handle(request, response, callback);
        }
    }

    public static class Reject
    extends ElseNext {
        private final int _status;

        public Reject() {
            this(null, 403);
        }

        public Reject(int status) {
            this(null, status);
        }

        public Reject(Handler handler) {
            this(handler, 403);
        }

        public Reject(Handler handler, int status) {
            super(handler);
            if (status < 200 || status > 999) {
                throw new IllegalArgumentException("bad status");
            }
            this._status = status;
        }

        @Override
        protected boolean onConditionsMet(Request request, Response response, Callback callback) throws Exception {
            Response.writeError(request, response, callback, this._status);
            return true;
        }
    }

    public static class DontHandle
    extends ElseNext {
        public DontHandle() {
        }

        public DontHandle(Handler handler) {
            super(handler);
        }

        @Override
        protected boolean onConditionsMet(Request request, Response response, Callback callback) throws Exception {
            return false;
        }
    }

    public static abstract class ElseNext
    extends ConditionalHandler {
        public ElseNext() {
            this((Handler)null);
        }

        public ElseNext(Handler handler) {
            super(handler);
        }

        @Override
        protected boolean onConditionsNotMet(Request request, Response response, Callback callback) throws Exception {
            return this.nextHandler(request, response, callback);
        }
    }

    public static abstract class Abstract
    extends ConditionalHandler {
        protected Abstract() {
        }

        protected Abstract(Handler nextHandler) {
            super(nextHandler);
        }

        protected Abstract(boolean dynamic, Handler nextHandler) {
            super(dynamic, nextHandler);
        }
    }
}

