/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.client;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameter;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.IRemoteCallableRequestType;

public class RemoteCallable
implements IRemoteCallable {
    protected String method;
    protected String resourcePath;
    protected IRemoteCallParameter[] defaultParameters;
    protected long defaultTimeout;
    protected IRemoteCallableRequestType requestType;

    public RemoteCallable(String method, String resourcePath, IRemoteCallParameter[] defaultParameters, IRemoteCallableRequestType requestType, long defaultTimeout) {
        this.method = method;
        Assert.isNotNull((Object)method);
        this.resourcePath = resourcePath;
        Assert.isNotNull((Object)resourcePath);
        this.defaultParameters = defaultParameters;
        this.requestType = requestType;
        this.defaultTimeout = defaultTimeout;
    }

    public RemoteCallable(String method, String resourcePath, IRemoteCallParameter[] defaultParameters, IRemoteCallableRequestType requestType) {
        this(method, resourcePath, defaultParameters, requestType, IRemoteCall.DEFAULT_TIMEOUT);
    }

    public String getMethod() {
        return this.method;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public IRemoteCallParameter[] getDefaultParameters() {
        return this.defaultParameters;
    }

    public IRemoteCallableRequestType getRequestType() {
        return this.requestType;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RemoteCallable[defaultParameters=");
        buffer.append(this.defaultParameters != null ? Arrays.asList(this.defaultParameters) : null);
        buffer.append(", defaultTimeout=");
        buffer.append(this.defaultTimeout);
        buffer.append(", method=");
        buffer.append(this.method);
        buffer.append(", requestType=");
        buffer.append(this.requestType);
        buffer.append(", resourcePath=");
        buffer.append(this.resourcePath);
        buffer.append("]");
        return buffer.toString();
    }
}

