/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.ui.model.provider;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.discovery.ui.model.ModelPlugin;
import org.eclipse.ecf.discovery.ui.model.provider.ModelItemProviderAdapterFactory;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;

public class DiscoveryEditingDomainProvider
implements IEditingDomainProvider {
    public static DiscoveryEditingDomainProvider eINSTANCE = new DiscoveryEditingDomainProvider();
    private AdapterFactoryEditingDomain editingDomain;
    private ComposedAdapterFactory adapterFactory;
    private BasicCommandStack commandStack;

    public void load() {
        this.adapterFactory = new ComposedAdapterFactory();
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ModelItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        this.commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)this.commandStack, new HashMap());
        URI resourceURI = URI.createURI((String)"service://");
        try {
            this.getEditingDomain().getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            this.getEditingDomain().getResourceSet().getResource(resourceURI, false);
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void addCommandStackListener(CommandStackListener csl) {
        this.commandStack.addCommandStackListener(csl);
    }

    public void removeCommandStackListener(CommandStackListener csl) {
        this.commandStack.removeCommandStackListener(csl);
    }

    public ComposedAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void save() {
        for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
            if (resource.getContents().isEmpty() || this.editingDomain.isReadOnly(resource)) continue;
            try {
                resource.save(Collections.EMPTY_MAP);
            }
            catch (UnsupportedOperationException e) {
                ModelPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.discovery.model", "Saving " + resource.toString() + " isn't supported yet"));
            }
            catch (IOException e) {
                ModelPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.discovery.model", e.getMessage(), (Throwable)e));
            }
        }
    }
}

