/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.internal.presence.PresencePlugin;
import org.eclipse.ecf.presence.IPresence;

public class Presence
implements IPresence {
    private static final long serialVersionUID = 3906369346107618354L;
    protected IPresence.Type type;
    protected IPresence.Mode mode;
    protected String status;
    protected Map properties;
    protected byte[] pictureData;

    public Presence() {
        this(IPresence.Type.AVAILABLE);
    }

    public Presence(IPresence.Type type) {
        this(type, null, IPresence.Mode.AVAILABLE);
    }

    public Presence(IPresence.Type type, String status, IPresence.Mode mode, Map props, byte[] picture) {
        this.type = type == null ? IPresence.Type.AVAILABLE : type;
        this.status = status;
        this.mode = mode == null ? IPresence.Mode.AVAILABLE : mode;
        this.properties = props == null ? new HashMap() : props;
        this.pictureData = picture == null ? new byte[]{} : picture;
    }

    public Presence(IPresence.Type type, String status, IPresence.Mode mode, Map props) {
        this(type, status, mode, props, null);
    }

    public Presence(IPresence.Type type, String status, IPresence.Mode mode) {
        this(type, status, mode, null);
    }

    @Override
    public IPresence.Mode getMode() {
        return this.mode;
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public IPresence.Type getType() {
        return this.type;
    }

    public Object getAdapter(Class adapter) {
        IAdapterManager adapterManager = PresencePlugin.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    @Override
    public byte[] getPictureData() {
        return this.pictureData;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Presence[");
        sb.append("type=").append(this.type).append(";");
        sb.append("mode=").append(this.mode).append(";");
        sb.append("status=").append(this.status).append(";");
        sb.append("props=").append(this.properties).append(";");
        sb.append("picture=").append(this.pictureData).append("]");
        return sb.toString();
    }
}

