/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.nonvisual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.nonvisual.CollectorObjectInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;

public class ItemCollectorObjectInfo
extends CollectorObjectInfo {
    private final ItemCollectorObjectInfo m_this = this;
    protected final LinkedList<ObjectInfo> m_items = new LinkedList();

    public ItemCollectorObjectInfo(AstEditor editor, String caption) throws Exception {
        super(editor, caption);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.addBroadcastListener(new ObjectEventListener(){

            public void childRemoveAfter(ObjectInfo parent, ObjectInfo child) throws Exception {
                ItemCollectorObjectInfo.this.m_this.removeItem(child);
            }
        });
    }

    @Override
    public List<ObjectInfo> getItems() {
        ArrayList<ObjectInfo> list = new ArrayList<ObjectInfo>();
        list.addAll(this.m_items);
        return Collections.unmodifiableList(list);
    }

    @Override
    public void addItem(ObjectInfo item) throws Exception {
        this.addItem(this.m_items.size(), item);
    }

    @Override
    protected void addItem(int index, ObjectInfo item) throws Exception {
        if (item != null && !this.m_items.contains(item)) {
            this.m_items.add(index, item);
            item.putArbitraryValue((Object)"CONTAINER_OBJECT", (Object)this);
        }
    }

    @Override
    protected void removeItem(ObjectInfo item) throws Exception {
        boolean removed = this.m_items.remove(item);
        if (((Object)((Object)this.m_this)).equals(item.getArbitraryValue((Object)"CONTAINER_OBJECT"))) {
            item.removeArbitraryValue((Object)"CONTAINER_OBJECT");
        }
        if (this.isRemoveOnEmpty() && this.m_items.isEmpty() && removed) {
            this.getParent().removeChild((ObjectInfo)this.m_this);
        }
    }
}

