/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.InitializeException;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.ThrowingFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Strings;
import io.github.toolfactory.narcissus.Narcissus;
import java.util.Map;
import sun.misc.Unsafe;

public interface AllocateInstanceFunction
extends ThrowingFunction<Class<?>, Object, Throwable> {

    public static interface Native
    extends AllocateInstanceFunction {

        public static class ForJava7
        implements Native {
            public ForJava7(Map<Object, Object> context) throws InitializeException {
                this.checkNativeEngine();
            }

            protected void checkNativeEngine() throws InitializeException {
                if (!Narcissus.libraryLoaded) {
                    throw new InitializeException(Strings.compile("Could not initialize the native engine {}", Narcissus.class.getName()));
                }
            }

            @Override
            public Object apply(Class<?> cls) {
                return Narcissus.allocateInstance(cls);
            }
        }
    }

    public static class ForJava7
    implements AllocateInstanceFunction {
        final Unsafe unsafe;

        public ForJava7(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.unsafe = (Unsafe)functionProvider.getOrBuildObject(UnsafeSupplier.class, context).get();
        }

        @Override
        public Object apply(Class<?> input) throws InstantiationException {
            return this.unsafe.allocateInstance(input);
        }
    }
}

