/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Iterator;
import org.assertj.core.annotation.Beta;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.error.ShouldBeUnmodifiable;
import org.assertj.core.internal.Iterators;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractIteratorAssert<SELF extends AbstractIteratorAssert<SELF, ELEMENT>, ELEMENT>
extends AbstractAssert<SELF, Iterator<? extends ELEMENT>> {
    @VisibleForTesting
    Iterators iterators = Iterators.instance();

    protected AbstractIteratorAssert(Iterator<? extends ELEMENT> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF hasNext() {
        this.iterators.assertHasNext(this.info, (Iterator)this.actual);
        return (SELF)((AbstractIteratorAssert)this.myself);
    }

    public SELF isExhausted() {
        this.iterators.assertIsExhausted(this.info, (Iterator)this.actual);
        return (SELF)((AbstractIteratorAssert)this.myself);
    }

    public IterableAssert<ELEMENT> toIterable() {
        return new IterableAssert(IterableAssert.toIterable((Iterator)this.actual));
    }

    @Beta
    public SELF isUnmodifiable() {
        this.isNotNull();
        this.assertIsUnmodifiable();
        return (SELF)((AbstractIteratorAssert)this.myself);
    }

    private void assertIsUnmodifiable() {
        switch (((Iterator)this.actual).getClass().getName()) {
            case "java.util.Collections$EmptyIterator": 
            case "java.util.Collections$EmptyListIterator": {
                return;
            }
        }
        this.expectUnsupportedOperationException(((Iterator)this.actual)::remove, "Iterator.remove()");
    }

    private void expectUnsupportedOperationException(Runnable runnable, String method) {
        try {
            runnable.run();
            this.throwAssertionError(ShouldBeUnmodifiable.shouldBeUnmodifiable(method));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (RuntimeException e) {
            this.throwAssertionError(ShouldBeUnmodifiable.shouldBeUnmodifiable(method, e));
        }
    }
}

