package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link PortConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePortConfig.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutablePortConfig implements PortConfig {
  private final @Nullable String name;
  private final @Nullable String protocol;
  private final @Nullable Integer targetPort;
  private final @Nullable Integer publishedPort;
  private final @Nullable PortConfig.PortConfigPublishMode publishMode;

  private ImmutablePortConfig(
      @Nullable String name,
      @Nullable String protocol,
      @Nullable Integer targetPort,
      @Nullable Integer publishedPort,
      @Nullable PortConfig.PortConfigPublishMode publishMode) {
    this.name = name;
    this.protocol = protocol;
    this.targetPort = targetPort;
    this.publishedPort = publishedPort;
    this.publishMode = publishMode;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   * @return The value of the {@code protocol} attribute
   */
  @JsonProperty("Protocol")
  @Override
  public @Nullable String protocol() {
    return protocol;
  }

  /**
   * @return The value of the {@code targetPort} attribute
   */
  @JsonProperty("TargetPort")
  @Override
  public @Nullable Integer targetPort() {
    return targetPort;
  }

  /**
   * @return The value of the {@code publishedPort} attribute
   */
  @JsonProperty("PublishedPort")
  @Override
  public @Nullable Integer publishedPort() {
    return publishedPort;
  }

  /**
   * @return The value of the {@code publishMode} attribute
   */
  @JsonProperty("PublishMode")
  @Override
  public @Nullable PortConfig.PortConfigPublishMode publishMode() {
    return publishMode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PortConfig#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutablePortConfig withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutablePortConfig(value, this.protocol, this.targetPort, this.publishedPort, this.publishMode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PortConfig#protocol() protocol} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for protocol (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutablePortConfig withProtocol(@Nullable String value) {
    if (Objects.equals(this.protocol, value)) return this;
    return new ImmutablePortConfig(this.name, value, this.targetPort, this.publishedPort, this.publishMode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PortConfig#targetPort() targetPort} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetPort (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutablePortConfig withTargetPort(@Nullable Integer value) {
    if (Objects.equals(this.targetPort, value)) return this;
    return new ImmutablePortConfig(this.name, this.protocol, value, this.publishedPort, this.publishMode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PortConfig#publishedPort() publishedPort} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for publishedPort (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutablePortConfig withPublishedPort(@Nullable Integer value) {
    if (Objects.equals(this.publishedPort, value)) return this;
    return new ImmutablePortConfig(this.name, this.protocol, this.targetPort, value, this.publishMode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PortConfig#publishMode() publishMode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for publishMode (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutablePortConfig withPublishMode(@Nullable PortConfig.PortConfigPublishMode value) {
    if (this.publishMode == value) return this;
    return new ImmutablePortConfig(this.name, this.protocol, this.targetPort, this.publishedPort, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePortConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePortConfig
        && equalsByValue((ImmutablePortConfig) another);
  }

  private boolean equalsByValue(ImmutablePortConfig another) {
    return Objects.equals(name, another.name)
        && Objects.equals(protocol, another.protocol)
        && Objects.equals(targetPort, another.targetPort)
        && Objects.equals(publishedPort, another.publishedPort)
        && Objects.equals(publishMode, another.publishMode);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code protocol}, {@code targetPort}, {@code publishedPort}, {@code publishMode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(protocol);
    h += (h << 5) + Objects.hashCode(targetPort);
    h += (h << 5) + Objects.hashCode(publishedPort);
    h += (h << 5) + Objects.hashCode(publishMode);
    return h;
  }

  /**
   * Prints the immutable value {@code PortConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PortConfig{"
        + "name=" + name
        + ", protocol=" + protocol
        + ", targetPort=" + targetPort
        + ", publishedPort=" + publishedPort
        + ", publishMode=" + publishMode
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link PortConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PortConfig instance
   */
  public static ImmutablePortConfig copyOf(PortConfig instance) {
    if (instance instanceof ImmutablePortConfig) {
      return (ImmutablePortConfig) instance;
    }
    return ImmutablePortConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePortConfig ImmutablePortConfig}.
   * <pre>
   * ImmutablePortConfig.builder()
   *    .name(String | null) // nullable {@link PortConfig#name() name}
   *    .protocol(String | null) // nullable {@link PortConfig#protocol() protocol}
   *    .targetPort(Integer | null) // nullable {@link PortConfig#targetPort() targetPort}
   *    .publishedPort(Integer | null) // nullable {@link PortConfig#publishedPort() publishedPort}
   *    .publishMode(org.mandas.docker.client.messages.swarm.PortConfig.PortConfigPublishMode | null) // nullable {@link PortConfig#publishMode() publishMode}
   *    .build();
   * </pre>
   * @return A new ImmutablePortConfig builder
   */
  public static ImmutablePortConfig.Builder builder() {
    return new ImmutablePortConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePortConfig ImmutablePortConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements PortConfig.Builder {
    private String name;
    private String protocol;
    private Integer targetPort;
    private Integer publishedPort;
    private PortConfig.PortConfigPublishMode publishMode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PortConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PortConfig instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String protocolValue = instance.protocol();
      if (protocolValue != null) {
        protocol(protocolValue);
      }
      @Nullable Integer targetPortValue = instance.targetPort();
      if (targetPortValue != null) {
        targetPort(targetPortValue);
      }
      @Nullable Integer publishedPortValue = instance.publishedPort();
      if (publishedPortValue != null) {
        publishedPort(publishedPortValue);
      }
      @Nullable PortConfig.PortConfigPublishMode publishModeValue = instance.publishMode();
      if (publishModeValue != null) {
        publishMode(publishModeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PortConfig#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link PortConfig#protocol() protocol} attribute.
     * @param protocol The value for protocol (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Protocol")
    public final Builder protocol(@Nullable String protocol) {
      this.protocol = protocol;
      return this;
    }

    /**
     * Initializes the value for the {@link PortConfig#targetPort() targetPort} attribute.
     * @param targetPort The value for targetPort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("TargetPort")
    public final Builder targetPort(@Nullable Integer targetPort) {
      this.targetPort = targetPort;
      return this;
    }

    /**
     * Initializes the value for the {@link PortConfig#publishedPort() publishedPort} attribute.
     * @param publishedPort The value for publishedPort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("PublishedPort")
    public final Builder publishedPort(@Nullable Integer publishedPort) {
      this.publishedPort = publishedPort;
      return this;
    }

    /**
     * Initializes the value for the {@link PortConfig#publishMode() publishMode} attribute.
     * @param publishMode The value for publishMode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("PublishMode")
    public final Builder publishMode(@Nullable PortConfig.PortConfigPublishMode publishMode) {
      this.publishMode = publishMode;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePortConfig ImmutablePortConfig}.
     * @return An immutable instance of PortConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePortConfig build() {
      return new ImmutablePortConfig(name, protocol, targetPort, publishedPort, publishMode);
    }
  }
}
