/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.burningwave.core.Virtual;
import org.burningwave.core.classes.ClassSourceGenerator;
import org.burningwave.core.classes.JavaMemoryCompiler;
import org.burningwave.core.classes.TypeDeclarationSourceGenerator;
import org.burningwave.core.classes.UnitSourceGenerator;

class LoadOrBuildAndDefineConfigAbst<L extends LoadOrBuildAndDefineConfigAbst<L>> {
    Collection<UnitSourceGenerator> unitSourceGenerators = new HashSet<UnitSourceGenerator>();
    private Function<JavaMemoryCompiler.Compilation.Config, JavaMemoryCompiler.Compilation.Config> compilationConfigSupplier;
    private Collection<String> classRepositoriesWhereToSearchNotFoundClassesDuringLoading;
    private Collection<String> additionalClassRepositoriesWhereToSearchNotFoundClassesDuringLoading;
    private ClassLoader classLoader;
    private boolean useOneShotJavaCompiler;
    private boolean virtualizeClasses = true;

    @SafeVarargs
    LoadOrBuildAndDefineConfigAbst(UnitSourceGenerator ... unitsCode) {
        this(Arrays.asList(unitsCode));
    }

    @SafeVarargs
    LoadOrBuildAndDefineConfigAbst(Collection<UnitSourceGenerator> ... unitCodeCollections) {
        for (Collection<UnitSourceGenerator> unitsCode : unitCodeCollections) {
            this.unitSourceGenerators.addAll(unitsCode);
        }
        this.compilationConfigSupplier = compileConfig -> {
            for (UnitSourceGenerator unitCode : this.unitSourceGenerators) {
                unitCode.getAllClasses().entrySet().forEach(entry -> {
                    if (this.virtualizeClasses) {
                        ((ClassSourceGenerator)entry.getValue()).addConcretizedType(TypeDeclarationSourceGenerator.create(Virtual.class));
                    }
                });
            }
            return JavaMemoryCompiler.Compilation.Config.forUnitSourceGenerators(this.unitSourceGenerators);
        };
    }

    public L virtualizeClasses(boolean flag) {
        this.virtualizeClasses = flag;
        return (L)this;
    }

    public L modifyCompilationConfig(Consumer<JavaMemoryCompiler.Compilation.Config> compilationConfigModifier) {
        this.compilationConfigSupplier = this.compilationConfigSupplier.andThen(compileConfig -> {
            compilationConfigModifier.accept((JavaMemoryCompiler.Compilation.Config)compileConfig);
            return compileConfig;
        });
        return (L)this;
    }

    @SafeVarargs
    public final L setClassRepository(String ... classPaths) {
        return this.setClassRepositories(Arrays.asList(classPaths));
    }

    @SafeVarargs
    public final L setClassRepositories(Collection<String> ... classPathCollections) {
        this.modifyCompilationConfig(compileConfig -> compileConfig.setClassRepositories(classPathCollections));
        return this.setClassRepositoriesWhereToSearchNotFoundClasses(classPathCollections);
    }

    @SafeVarargs
    public final L addClassRepository(String ... classPaths) {
        return this.addClassRepositories(Arrays.asList(classPaths));
    }

    @SafeVarargs
    public final L addClassRepositories(Collection<String> ... classPathCollections) {
        this.modifyCompilationConfig(compileConfig -> compileConfig.addClassRepositories(classPathCollections));
        return this.addClassRepositoriesWhereToSearchNotFoundClasses(classPathCollections);
    }

    @SafeVarargs
    public final L setClassPaths(String ... classPaths) {
        return this.setClassPaths(Arrays.asList(classPaths));
    }

    @SafeVarargs
    public final L setClassPaths(Collection<String> ... classPathCollections) {
        this.modifyCompilationConfig(compileConfig -> compileConfig.setClassPaths(classPathCollections));
        return this.setClassRepositoriesWhereToSearchNotFoundClasses(classPathCollections);
    }

    @SafeVarargs
    public final L addClassPaths(String ... classPaths) {
        return this.addClassPaths(Arrays.asList(classPaths));
    }

    @SafeVarargs
    public final L addClassPaths(Collection<String> ... classPathCollections) {
        this.modifyCompilationConfig(compileConfig -> compileConfig.addClassPaths(classPathCollections));
        return this.addClassRepositoriesWhereToSearchNotFoundClasses(classPathCollections);
    }

    @SafeVarargs
    public final L setClassRepositoryWhereToSearchNotFoundClasses(String ... classPaths) {
        return this.setClassRepositoriesWhereToSearchNotFoundClasses(Arrays.asList(classPaths));
    }

    @SafeVarargs
    public final L setClassRepositoriesWhereToSearchNotFoundClasses(Collection<String> ... classRepositoryCollections) {
        return ((LoadOrBuildAndDefineConfigAbst)this.modifyCompilationConfig(compileConfig -> compileConfig.setClassRepositories(classRepositoryCollections))).setClassRepositoriesWhereToSearchNotFoundClassesDuringLoading(classRepositoryCollections);
    }

    @SafeVarargs
    public final L addClassRepositoryWhereToSearchNotFoundClasses(String ... classPaths) {
        return this.addClassRepositoriesWhereToSearchNotFoundClasses(Arrays.asList(classPaths));
    }

    @SafeVarargs
    public final L addClassRepositoriesWhereToSearchNotFoundClasses(Collection<String> ... classRepositoryCollections) {
        return ((LoadOrBuildAndDefineConfigAbst)this.modifyCompilationConfig(compileConfig -> compileConfig.addClassRepositories(classRepositoryCollections))).addClassRepositoriesWhereToSearchNotFoundClassesDuringLoading(classRepositoryCollections);
    }

    @SafeVarargs
    public final L setClassRepositoryWhereToSearchNotFoundClassesDuringLoading(String ... classPaths) {
        return this.setClassRepositoriesWhereToSearchNotFoundClassesDuringLoading(Arrays.asList(classPaths));
    }

    @SafeVarargs
    public final L setClassRepositoriesWhereToSearchNotFoundClassesDuringLoading(Collection<String> ... classPathCollections) {
        if (this.classRepositoriesWhereToSearchNotFoundClassesDuringLoading == null) {
            this.classRepositoriesWhereToSearchNotFoundClassesDuringLoading = new HashSet<String>();
        }
        for (Collection<String> classPathCollection : classPathCollections) {
            this.classRepositoriesWhereToSearchNotFoundClassesDuringLoading.addAll(classPathCollection);
        }
        return (L)this;
    }

    @SafeVarargs
    public final L addClassRepositoryWhereToSearchNotFoundClassesDuringLoading(String ... classPaths) {
        return this.addClassRepositoriesWhereToSearchNotFoundClassesDuringLoading(Arrays.asList(classPaths));
    }

    @SafeVarargs
    public final L addClassRepositoriesWhereToSearchNotFoundClassesDuringLoading(Collection<String> ... classPathCollections) {
        if (this.additionalClassRepositoriesWhereToSearchNotFoundClassesDuringLoading == null) {
            this.additionalClassRepositoriesWhereToSearchNotFoundClassesDuringLoading = new HashSet<String>();
        }
        for (Collection<String> classPathCollection : classPathCollections) {
            this.additionalClassRepositoriesWhereToSearchNotFoundClassesDuringLoading.addAll(classPathCollection);
        }
        return (L)this;
    }

    public L useClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return (L)this;
    }

    public L useOneShotJavaCompiler(boolean flag) {
        this.useOneShotJavaCompiler = flag;
        return (L)this;
    }

    Collection<String> getClassRepositoriesWhereToSearchNotFoundClassesDuringLoading() {
        return this.classRepositoriesWhereToSearchNotFoundClassesDuringLoading;
    }

    Collection<String> getAdditionalClassRepositoriesWhereToSearchNotFoundClassesDuringLoading() {
        return this.additionalClassRepositoriesWhereToSearchNotFoundClassesDuringLoading;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    boolean isUseOneShotJavaCompilerEnabled() {
        return this.useOneShotJavaCompiler;
    }

    Collection<String> getClassesName() {
        HashSet<String> classesName = new HashSet<String>();
        this.unitSourceGenerators.stream().forEach(unitCode -> unitCode.getAllClasses().entrySet().forEach(entry -> classesName.add((String)entry.getKey())));
        return classesName;
    }

    Supplier<JavaMemoryCompiler.Compilation.Config> getCompileConfigSupplier() {
        return () -> this.compilationConfigSupplier.apply(null);
    }

    boolean isVirtualizeClassesEnabled() {
        return this.virtualizeClasses;
    }
}

