/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.AttachedNetwork;
import org.mandas.docker.client.messages.NetworkSettings;
import org.mandas.docker.client.messages.PortBinding;

final class ImmutableNetworkSettings
implements NetworkSettings {
    @Nullable
    private final String ipAddress;
    @Nullable
    private final Integer ipPrefixLen;
    @Nullable
    private final String gateway;
    @Nullable
    private final String bridge;
    @Nullable
    private final Map<String, Map<String, String>> portMapping;
    @Nullable
    private final transient Map<String, List<PortBinding>> ports;
    @Nullable
    private final Map<String, List<PortBinding>> nullValuedPorts;
    @Nullable
    private final String macAddress;
    @Nullable
    private final Map<String, AttachedNetwork> networks;
    @Nullable
    private final String endpointId;
    @Nullable
    private final String sandboxId;
    @Nullable
    private final String sandboxKey;
    @Nullable
    private final Boolean hairpinMode;
    @Nullable
    private final String linkLocalIPv6Address;
    @Nullable
    private final Integer linkLocalIPv6PrefixLen;
    @Nullable
    private final String globalIPv6Address;
    @Nullable
    private final Integer globalIPv6PrefixLen;
    @Nullable
    private final String ipv6Gateway;

    private ImmutableNetworkSettings(@Nullable String ipAddress, @Nullable Integer ipPrefixLen, @Nullable String gateway, @Nullable String bridge, @Nullable Map<String, Map<String, String>> portMapping, @Nullable Map<String, List<PortBinding>> nullValuedPorts, @Nullable String macAddress, @Nullable Map<String, AttachedNetwork> networks, @Nullable String endpointId, @Nullable String sandboxId, @Nullable String sandboxKey, @Nullable Boolean hairpinMode, @Nullable String linkLocalIPv6Address, @Nullable Integer linkLocalIPv6PrefixLen, @Nullable String globalIPv6Address, @Nullable Integer globalIPv6PrefixLen, @Nullable String ipv6Gateway) {
        this.ipAddress = ipAddress;
        this.ipPrefixLen = ipPrefixLen;
        this.gateway = gateway;
        this.bridge = bridge;
        this.portMapping = portMapping;
        this.nullValuedPorts = nullValuedPorts;
        this.macAddress = macAddress;
        this.networks = networks;
        this.endpointId = endpointId;
        this.sandboxId = sandboxId;
        this.sandboxKey = sandboxKey;
        this.hairpinMode = hairpinMode;
        this.linkLocalIPv6Address = linkLocalIPv6Address;
        this.linkLocalIPv6PrefixLen = linkLocalIPv6PrefixLen;
        this.globalIPv6Address = globalIPv6Address;
        this.globalIPv6PrefixLen = globalIPv6PrefixLen;
        this.ipv6Gateway = ipv6Gateway;
        this.ports = NetworkSettings.super.ports();
    }

    @Override
    @JsonProperty(value="IPAddress")
    @Deprecated
    @Nullable
    public String ipAddress() {
        return this.ipAddress;
    }

    @Override
    @JsonProperty(value="IPPrefixLen")
    @Deprecated
    @Nullable
    public Integer ipPrefixLen() {
        return this.ipPrefixLen;
    }

    @Override
    @JsonProperty(value="Gateway")
    @Nullable
    public String gateway() {
        return this.gateway;
    }

    @Override
    @JsonProperty(value="Bridge")
    @Nullable
    public String bridge() {
        return this.bridge;
    }

    @Override
    @JsonProperty(value="PortMapping")
    @Nullable
    public Map<String, Map<String, String>> portMapping() {
        return this.portMapping;
    }

    @Override
    @JsonProperty(value="ports")
    @JsonIgnore
    @Nullable
    public Map<String, List<PortBinding>> ports() {
        return this.ports;
    }

    @Override
    @JsonProperty(value="Ports")
    @Nullable
    public Map<String, List<PortBinding>> nullValuedPorts() {
        return this.nullValuedPorts;
    }

    @Override
    @JsonProperty(value="MacAddress")
    @Deprecated
    @Nullable
    public String macAddress() {
        return this.macAddress;
    }

    @Override
    @JsonProperty(value="Networks")
    @Nullable
    public Map<String, AttachedNetwork> networks() {
        return this.networks;
    }

    @Override
    @JsonProperty(value="EndpointID")
    @Nullable
    public String endpointId() {
        return this.endpointId;
    }

    @Override
    @JsonProperty(value="SandboxID")
    @Nullable
    public String sandboxId() {
        return this.sandboxId;
    }

    @Override
    @JsonProperty(value="SandboxKey")
    @Nullable
    public String sandboxKey() {
        return this.sandboxKey;
    }

    @Override
    @JsonProperty(value="HairpinMode")
    @Deprecated
    @Nullable
    public Boolean hairpinMode() {
        return this.hairpinMode;
    }

    @Override
    @JsonProperty(value="LinkLocalIPv6Address")
    @Deprecated
    @Nullable
    public String linkLocalIPv6Address() {
        return this.linkLocalIPv6Address;
    }

    @Override
    @JsonProperty(value="LinkLocalIPv6PrefixLen")
    @Deprecated
    @Nullable
    public Integer linkLocalIPv6PrefixLen() {
        return this.linkLocalIPv6PrefixLen;
    }

    @Override
    @JsonProperty(value="GlobalIPv6Address")
    @Nullable
    public String globalIPv6Address() {
        return this.globalIPv6Address;
    }

    @Override
    @JsonProperty(value="GlobalIPv6PrefixLen")
    @Nullable
    public Integer globalIPv6PrefixLen() {
        return this.globalIPv6PrefixLen;
    }

    @Override
    @JsonProperty(value="IPv6Gateway")
    @Nullable
    public String ipv6Gateway() {
        return this.ipv6Gateway;
    }

    @Deprecated
    public final ImmutableNetworkSettings withIpAddress(@Nullable String value) {
        if (Objects.equals(this.ipAddress, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(value, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    @Deprecated
    public final ImmutableNetworkSettings withIpPrefixLen(@Nullable Integer value) {
        if (Objects.equals(this.ipPrefixLen, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, value, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    public final ImmutableNetworkSettings withGateway(@Nullable String value) {
        if (Objects.equals(this.gateway, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, value, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    public final ImmutableNetworkSettings withBridge(@Nullable String value) {
        if (Objects.equals(this.bridge, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, value, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    public final ImmutableNetworkSettings withPortMapping(@Nullable Map<String, ? extends Map<String, String>> entries) {
        if (this.portMapping == entries) {
            return this;
        }
        Map<String, Map<String, String>> newValue = entries == null ? null : ImmutableNetworkSettings.createUnmodifiableMap(true, false, entries);
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, newValue, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    public final ImmutableNetworkSettings withNullValuedPorts(@Nullable Map<String, ? extends List<PortBinding>> entries) {
        if (this.nullValuedPorts == entries) {
            return this;
        }
        Map<String, List<PortBinding>> newValue = entries == null ? null : ImmutableNetworkSettings.createUnmodifiableMap(false, false, entries);
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, newValue, this.macAddress, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    @Deprecated
    public final ImmutableNetworkSettings withMacAddress(@Nullable String value) {
        if (Objects.equals(this.macAddress, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, value, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    public final ImmutableNetworkSettings withNetworks(@Nullable Map<String, ? extends AttachedNetwork> entries) {
        if (this.networks == entries) {
            return this;
        }
        Map<String, AttachedNetwork> newValue = entries == null ? null : ImmutableNetworkSettings.createUnmodifiableMap(true, false, entries);
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, newValue, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    public final ImmutableNetworkSettings withEndpointId(@Nullable String value) {
        if (Objects.equals(this.endpointId, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, value, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    public final ImmutableNetworkSettings withSandboxId(@Nullable String value) {
        if (Objects.equals(this.sandboxId, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, value, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    public final ImmutableNetworkSettings withSandboxKey(@Nullable String value) {
        if (Objects.equals(this.sandboxKey, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, this.sandboxId, value, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    @Deprecated
    public final ImmutableNetworkSettings withHairpinMode(@Nullable Boolean value) {
        if (Objects.equals(this.hairpinMode, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, value, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    @Deprecated
    public final ImmutableNetworkSettings withLinkLocalIPv6Address(@Nullable String value) {
        if (Objects.equals(this.linkLocalIPv6Address, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, value, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    @Deprecated
    public final ImmutableNetworkSettings withLinkLocalIPv6PrefixLen(@Nullable Integer value) {
        if (Objects.equals(this.linkLocalIPv6PrefixLen, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, value, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    public final ImmutableNetworkSettings withGlobalIPv6Address(@Nullable String value) {
        if (Objects.equals(this.globalIPv6Address, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, value, this.globalIPv6PrefixLen, this.ipv6Gateway);
    }

    public final ImmutableNetworkSettings withGlobalIPv6PrefixLen(@Nullable Integer value) {
        if (Objects.equals(this.globalIPv6PrefixLen, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, value, this.ipv6Gateway);
    }

    public final ImmutableNetworkSettings withIpv6Gateway(@Nullable String value) {
        if (Objects.equals(this.ipv6Gateway, value)) {
            return this;
        }
        return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.nullValuedPorts, this.macAddress, this.networks, this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkSettings && this.equalTo(0, (ImmutableNetworkSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableNetworkSettings another) {
        return Objects.equals(this.ipAddress, another.ipAddress) && Objects.equals(this.ipPrefixLen, another.ipPrefixLen) && Objects.equals(this.gateway, another.gateway) && Objects.equals(this.bridge, another.bridge) && Objects.equals(this.portMapping, another.portMapping) && Objects.equals(this.ports, another.ports) && Objects.equals(this.nullValuedPorts, another.nullValuedPorts) && Objects.equals(this.macAddress, another.macAddress) && Objects.equals(this.networks, another.networks) && Objects.equals(this.endpointId, another.endpointId) && Objects.equals(this.sandboxId, another.sandboxId) && Objects.equals(this.sandboxKey, another.sandboxKey) && Objects.equals(this.hairpinMode, another.hairpinMode) && Objects.equals(this.linkLocalIPv6Address, another.linkLocalIPv6Address) && Objects.equals(this.linkLocalIPv6PrefixLen, another.linkLocalIPv6PrefixLen) && Objects.equals(this.globalIPv6Address, another.globalIPv6Address) && Objects.equals(this.globalIPv6PrefixLen, another.globalIPv6PrefixLen) && Objects.equals(this.ipv6Gateway, another.ipv6Gateway);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.ipAddress);
        h += (h << 5) + Objects.hashCode(this.ipPrefixLen);
        h += (h << 5) + Objects.hashCode(this.gateway);
        h += (h << 5) + Objects.hashCode(this.bridge);
        h += (h << 5) + Objects.hashCode(this.portMapping);
        h += (h << 5) + Objects.hashCode(this.ports);
        h += (h << 5) + Objects.hashCode(this.nullValuedPorts);
        h += (h << 5) + Objects.hashCode(this.macAddress);
        h += (h << 5) + Objects.hashCode(this.networks);
        h += (h << 5) + Objects.hashCode(this.endpointId);
        h += (h << 5) + Objects.hashCode(this.sandboxId);
        h += (h << 5) + Objects.hashCode(this.sandboxKey);
        h += (h << 5) + Objects.hashCode(this.hairpinMode);
        h += (h << 5) + Objects.hashCode(this.linkLocalIPv6Address);
        h += (h << 5) + Objects.hashCode(this.linkLocalIPv6PrefixLen);
        h += (h << 5) + Objects.hashCode(this.globalIPv6Address);
        h += (h << 5) + Objects.hashCode(this.globalIPv6PrefixLen);
        h += (h << 5) + Objects.hashCode(this.ipv6Gateway);
        return h;
    }

    public String toString() {
        return "NetworkSettings{ipAddress=" + this.ipAddress + ", ipPrefixLen=" + this.ipPrefixLen + ", gateway=" + this.gateway + ", bridge=" + this.bridge + ", portMapping=" + this.portMapping + ", ports=" + this.ports + ", nullValuedPorts=" + this.nullValuedPorts + ", macAddress=" + this.macAddress + ", networks=" + this.networks + ", endpointId=" + this.endpointId + ", sandboxId=" + this.sandboxId + ", sandboxKey=" + this.sandboxKey + ", hairpinMode=" + this.hairpinMode + ", linkLocalIPv6Address=" + this.linkLocalIPv6Address + ", linkLocalIPv6PrefixLen=" + this.linkLocalIPv6PrefixLen + ", globalIPv6Address=" + this.globalIPv6Address + ", globalIPv6PrefixLen=" + this.globalIPv6PrefixLen + ", ipv6Gateway=" + this.ipv6Gateway + "}";
    }

    public static ImmutableNetworkSettings copyOf(NetworkSettings instance) {
        if (instance instanceof ImmutableNetworkSettings) {
            return (ImmutableNetworkSettings)instance;
        }
        return ImmutableNetworkSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements NetworkSettings.Builder {
        private String ipAddress;
        private Integer ipPrefixLen;
        private String gateway;
        private String bridge;
        private Map<String, Map<String, String>> portMapping = null;
        private Map<String, List<PortBinding>> nullValuedPorts = null;
        private String macAddress;
        private Map<String, AttachedNetwork> networks = null;
        private String endpointId;
        private String sandboxId;
        private String sandboxKey;
        private Boolean hairpinMode;
        private String linkLocalIPv6Address;
        private Integer linkLocalIPv6PrefixLen;
        private String globalIPv6Address;
        private Integer globalIPv6PrefixLen;
        private String ipv6Gateway;

        private Builder() {
        }

        public final Builder from(NetworkSettings instance) {
            String ipv6GatewayValue;
            Integer globalIPv6PrefixLenValue;
            String globalIPv6AddressValue;
            Integer linkLocalIPv6PrefixLenValue;
            String linkLocalIPv6AddressValue;
            Boolean hairpinModeValue;
            String sandboxKeyValue;
            String sandboxIdValue;
            String endpointIdValue;
            Map<String, AttachedNetwork> networksValue;
            String macAddressValue;
            Map<String, List<PortBinding>> nullValuedPortsValue;
            Map<String, Map<String, String>> portMappingValue;
            String bridgeValue;
            String gatewayValue;
            Integer ipPrefixLenValue;
            Objects.requireNonNull(instance, "instance");
            String ipAddressValue = instance.ipAddress();
            if (ipAddressValue != null) {
                this.ipAddress(ipAddressValue);
            }
            if ((ipPrefixLenValue = instance.ipPrefixLen()) != null) {
                this.ipPrefixLen(ipPrefixLenValue);
            }
            if ((gatewayValue = instance.gateway()) != null) {
                this.gateway(gatewayValue);
            }
            if ((bridgeValue = instance.bridge()) != null) {
                this.bridge(bridgeValue);
            }
            if ((portMappingValue = instance.portMapping()) != null) {
                this.putAllPortMapping(portMappingValue);
            }
            if ((nullValuedPortsValue = instance.nullValuedPorts()) != null) {
                this.putAllNullValuedPorts(nullValuedPortsValue);
            }
            if ((macAddressValue = instance.macAddress()) != null) {
                this.macAddress(macAddressValue);
            }
            if ((networksValue = instance.networks()) != null) {
                this.putAllNetworks(networksValue);
            }
            if ((endpointIdValue = instance.endpointId()) != null) {
                this.endpointId(endpointIdValue);
            }
            if ((sandboxIdValue = instance.sandboxId()) != null) {
                this.sandboxId(sandboxIdValue);
            }
            if ((sandboxKeyValue = instance.sandboxKey()) != null) {
                this.sandboxKey(sandboxKeyValue);
            }
            if ((hairpinModeValue = instance.hairpinMode()) != null) {
                this.hairpinMode(hairpinModeValue);
            }
            if ((linkLocalIPv6AddressValue = instance.linkLocalIPv6Address()) != null) {
                this.linkLocalIPv6Address(linkLocalIPv6AddressValue);
            }
            if ((linkLocalIPv6PrefixLenValue = instance.linkLocalIPv6PrefixLen()) != null) {
                this.linkLocalIPv6PrefixLen(linkLocalIPv6PrefixLenValue);
            }
            if ((globalIPv6AddressValue = instance.globalIPv6Address()) != null) {
                this.globalIPv6Address(globalIPv6AddressValue);
            }
            if ((globalIPv6PrefixLenValue = instance.globalIPv6PrefixLen()) != null) {
                this.globalIPv6PrefixLen(globalIPv6PrefixLenValue);
            }
            if ((ipv6GatewayValue = instance.ipv6Gateway()) != null) {
                this.ipv6Gateway(ipv6GatewayValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="IPAddress")
        @Deprecated
        public final Builder ipAddress(@Nullable String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        @Override
        @JsonProperty(value="IPPrefixLen")
        @Deprecated
        public final Builder ipPrefixLen(@Nullable Integer ipPrefixLen) {
            this.ipPrefixLen = ipPrefixLen;
            return this;
        }

        @Override
        @JsonProperty(value="Gateway")
        public final Builder gateway(@Nullable String gateway) {
            this.gateway = gateway;
            return this;
        }

        @Override
        @JsonProperty(value="Bridge")
        public final Builder bridge(@Nullable String bridge) {
            this.bridge = bridge;
            return this;
        }

        public final Builder addPortMapping(String key, Map<String, String> value) {
            if (this.portMapping == null) {
                this.portMapping = new LinkedHashMap<String, Map<String, String>>();
            }
            this.portMapping.put(Objects.requireNonNull(key, "portMapping key"), Objects.requireNonNull(value, value == null ? "portMapping value for key: " + key : null));
            return this;
        }

        public final Builder addPortMapping(Map.Entry<String, ? extends Map<String, String>> entry) {
            Map<String, String> v;
            if (this.portMapping == null) {
                this.portMapping = new LinkedHashMap<String, Map<String, String>>();
            }
            String k = entry.getKey();
            this.portMapping.put(Objects.requireNonNull(k, "portMapping key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "portMapping value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="PortMapping")
        public final Builder portMapping(@Nullable Map<String, ? extends Map<String, String>> entries) {
            if (entries == null) {
                this.portMapping = null;
                return this;
            }
            this.portMapping = new LinkedHashMap<String, Map<String, String>>();
            return this.putAllPortMapping(entries);
        }

        public final Builder putAllPortMapping(Map<String, ? extends Map<String, String>> entries) {
            if (this.portMapping == null) {
                this.portMapping = new LinkedHashMap<String, Map<String, String>>();
            }
            for (Map.Entry<String, ? extends Map<String, String>> e : entries.entrySet()) {
                Map<String, String> v;
                String k = e.getKey();
                this.portMapping.put(Objects.requireNonNull(k, "portMapping key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "portMapping value for key: " + k : null));
            }
            return this;
        }

        public final Builder addNullValuedPort(String key, List<PortBinding> value) {
            if (this.nullValuedPorts == null) {
                this.nullValuedPorts = new LinkedHashMap<String, List<PortBinding>>();
            }
            this.nullValuedPorts.put(key, value);
            return this;
        }

        public final Builder addNullValuedPort(Map.Entry<String, ? extends List<PortBinding>> entry) {
            if (this.nullValuedPorts == null) {
                this.nullValuedPorts = new LinkedHashMap<String, List<PortBinding>>();
            }
            String k = entry.getKey();
            List<PortBinding> v = entry.getValue();
            this.nullValuedPorts.put(k, v);
            return this;
        }

        @Override
        @JsonProperty(value="Ports")
        public final Builder nullValuedPorts(@Nullable Map<String, ? extends List<PortBinding>> entries) {
            if (entries == null) {
                this.nullValuedPorts = null;
                return this;
            }
            this.nullValuedPorts = new LinkedHashMap<String, List<PortBinding>>();
            return this.putAllNullValuedPorts(entries);
        }

        public final Builder putAllNullValuedPorts(Map<String, ? extends List<PortBinding>> entries) {
            if (this.nullValuedPorts == null) {
                this.nullValuedPorts = new LinkedHashMap<String, List<PortBinding>>();
            }
            for (Map.Entry<String, ? extends List<PortBinding>> e : entries.entrySet()) {
                String k = e.getKey();
                List<PortBinding> v = e.getValue();
                this.nullValuedPorts.put(k, v);
            }
            return this;
        }

        @Override
        @JsonProperty(value="MacAddress")
        @Deprecated
        public final Builder macAddress(@Nullable String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final Builder addNetwork(String key, AttachedNetwork value) {
            if (this.networks == null) {
                this.networks = new LinkedHashMap<String, AttachedNetwork>();
            }
            this.networks.put(Objects.requireNonNull(key, "networks key"), Objects.requireNonNull(value, value == null ? "networks value for key: " + key : null));
            return this;
        }

        public final Builder addNetwork(Map.Entry<String, ? extends AttachedNetwork> entry) {
            AttachedNetwork v;
            if (this.networks == null) {
                this.networks = new LinkedHashMap<String, AttachedNetwork>();
            }
            String k = entry.getKey();
            this.networks.put(Objects.requireNonNull(k, "networks key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "networks value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="Networks")
        public final Builder networks(@Nullable Map<String, ? extends AttachedNetwork> entries) {
            if (entries == null) {
                this.networks = null;
                return this;
            }
            this.networks = new LinkedHashMap<String, AttachedNetwork>();
            return this.putAllNetworks(entries);
        }

        public final Builder putAllNetworks(Map<String, ? extends AttachedNetwork> entries) {
            if (this.networks == null) {
                this.networks = new LinkedHashMap<String, AttachedNetwork>();
            }
            for (Map.Entry<String, ? extends AttachedNetwork> e : entries.entrySet()) {
                AttachedNetwork v;
                String k = e.getKey();
                this.networks.put(Objects.requireNonNull(k, "networks key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "networks value for key: " + k : null));
            }
            return this;
        }

        @Override
        @JsonProperty(value="EndpointID")
        public final Builder endpointId(@Nullable String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        @Override
        @JsonProperty(value="SandboxID")
        public final Builder sandboxId(@Nullable String sandboxId) {
            this.sandboxId = sandboxId;
            return this;
        }

        @Override
        @JsonProperty(value="SandboxKey")
        public final Builder sandboxKey(@Nullable String sandboxKey) {
            this.sandboxKey = sandboxKey;
            return this;
        }

        @Override
        @JsonProperty(value="HairpinMode")
        @Deprecated
        public final Builder hairpinMode(@Nullable Boolean hairpinMode) {
            this.hairpinMode = hairpinMode;
            return this;
        }

        @Override
        @JsonProperty(value="LinkLocalIPv6Address")
        @Deprecated
        public final Builder linkLocalIPv6Address(@Nullable String linkLocalIPv6Address) {
            this.linkLocalIPv6Address = linkLocalIPv6Address;
            return this;
        }

        @Override
        @JsonProperty(value="LinkLocalIPv6PrefixLen")
        @Deprecated
        public final Builder linkLocalIPv6PrefixLen(@Nullable Integer linkLocalIPv6PrefixLen) {
            this.linkLocalIPv6PrefixLen = linkLocalIPv6PrefixLen;
            return this;
        }

        @Override
        @JsonProperty(value="GlobalIPv6Address")
        public final Builder globalIPv6Address(@Nullable String globalIPv6Address) {
            this.globalIPv6Address = globalIPv6Address;
            return this;
        }

        @Override
        @JsonProperty(value="GlobalIPv6PrefixLen")
        public final Builder globalIPv6PrefixLen(@Nullable Integer globalIPv6PrefixLen) {
            this.globalIPv6PrefixLen = globalIPv6PrefixLen;
            return this;
        }

        @Override
        @JsonProperty(value="IPv6Gateway")
        public final Builder ipv6Gateway(@Nullable String ipv6Gateway) {
            this.ipv6Gateway = ipv6Gateway;
            return this;
        }

        @Override
        public ImmutableNetworkSettings build() {
            return new ImmutableNetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping == null ? null : ImmutableNetworkSettings.createUnmodifiableMap(false, false, this.portMapping), this.nullValuedPorts == null ? null : ImmutableNetworkSettings.createUnmodifiableMap(false, false, this.nullValuedPorts), this.macAddress, this.networks == null ? null : ImmutableNetworkSettings.createUnmodifiableMap(false, false, this.networks), this.endpointId, this.sandboxId, this.sandboxKey, this.hairpinMode, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipv6Gateway);
        }
    }
}

