/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.nonvisual;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.AssociationObjects;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.generation.GenerationUtils;
import org.eclipse.wb.internal.core.model.generation.statement.PureFlatStatementGenerator;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGenerator;
import org.eclipse.wb.internal.core.model.generation.statement.lazy.LazyStatementGenerator;
import org.eclipse.wb.internal.core.model.nonvisual.JavadocNonVisualBeanInfo;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanInfo;
import org.eclipse.wb.internal.core.model.presentation.DefaultObjectPresentation;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.variable.AbstractSimpleVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldInitializerVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.description.LazyVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.VariableSupportDescription;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;

public final class NonVisualBeanContainerInfo
extends ObjectInfo {
    public static NonVisualBeanContainerInfo get(JavaInfo root) throws Exception {
        NonVisualBeanContainerInfo container = NonVisualBeanContainerInfo.find(root);
        if (container != null) {
            return container;
        }
        container = new NonVisualBeanContainerInfo();
        root.addChild(container);
        return container;
    }

    public static NonVisualBeanContainerInfo find(JavaInfo rootInfo) {
        for (ObjectInfo child : rootInfo.getChildren()) {
            if (!(child instanceof NonVisualBeanContainerInfo)) continue;
            return (NonVisualBeanContainerInfo)child;
        }
        return null;
    }

    public static NonVisualBeanInfo getNonVisualInfo(ASTNode creationNode) throws Exception {
        BodyDeclaration member = AstNodeUtils.getEnclosingNode(creationNode, BodyDeclaration.class);
        if (member != null) {
            return JavadocNonVisualBeanInfo.getNonVisualBeanInfo(member);
        }
        return null;
    }

    public static void add(JavaInfo root, JavaInfo bean, Point location) throws Exception {
        StatementGenerator statementGenerator;
        AbstractSimpleVariableSupport variableSupport;
        VariableSupportDescription variableDescription = GenerationUtils.getVariableDescription(root);
        if (variableDescription == LazyVariableDescription.INSTANCE) {
            variableSupport = new LazyVariableSupport(bean);
            statementGenerator = LazyStatementGenerator.INSTANCE;
        } else {
            variableSupport = new FieldInitializerVariableSupport(bean);
            statementGenerator = PureFlatStatementGenerator.INSTANCE;
        }
        JavaInfoUtils.add(bean, variableSupport, statementGenerator, AssociationObjects.nonVisual(), root, null);
        root.removeChild(bean);
        BodyDeclaration member = AstNodeUtils.getEnclosingNode(bean.getCreationSupport().getNode(), BodyDeclaration.class);
        JavadocNonVisualBeanInfo nonVisualInfo = new JavadocNonVisualBeanInfo(member);
        nonVisualInfo.setJavaInfo(bean);
        ((NonVisualBeanInfo)nonVisualInfo).moveLocation(location);
        NonVisualBeanContainerInfo.get(root).addChild(bean);
        if (bean.getVariableSupport() instanceof LazyVariableSupport) {
            LazyVariableSupport lazyVariable = (LazyVariableSupport)bean.getVariableSupport();
            ExecutionFlowDescription flowDescription = JavaInfoUtils.getState(bean).getFlowDescription();
            flowDescription.addStartMethod(lazyVariable.m_accessor);
        }
    }

    public String toString() {
        return "{NonVisualBeans}";
    }

    public IObjectPresentation getPresentation() {
        return new DefaultObjectPresentation(this){

            public String getText() throws Exception {
                return "(non-visual beans)";
            }

            public ImageDescriptor getIcon() throws Exception {
                return DesignerPlugin.getImageDescriptor((String)"components/non_visual_beans_container.gif");
            }
        };
    }

    public boolean canDelete() {
        return false;
    }

    public void delete() throws Exception {
    }
}

