/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.model.property.editor.AbstractListPropertyEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public final class ExpressionListPropertyEditor
extends AbstractListPropertyEditor {
    protected String[] m_expressions;
    protected String[] m_conditions;
    protected String[] m_titles;
    protected String m_functions;
    protected Object[] m_compiled;
    protected static final String USER_functions = "functions";
    private static final String DEF_functions = StringUtils.join((Object[])new String[]{"def isType(t, c) {", "  if (c is String) {", "    return ReflectionUtils.isSuccessorOf(t, c);", "  } else {", "    return c.isAssignableFrom(v);", "  }", "};", "def isValueType(c) {", "  if (value == null) {", "    return false;", "  } else {", "    return isType(value.getClass(),c);", "  }", "};"}, (String)"\n");

    @Override
    protected int getCount() {
        return this.m_compiled.length;
    }

    @Override
    protected int getValueIndex(Object value) {
        int i = 0;
        while (i < this.getCount()) {
            TreeMap<String, Object> variables = new TreeMap<String, Object>();
            variables.put("value", value);
            this.setVariables(variables, i);
            if (((Boolean)MVEL.executeExpression((Object)this.m_compiled[i], variables)).booleanValue()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void setVariables(Map<String, Object> variables, int conditionIndex) {
    }

    @Override
    protected String getTitle(int index) {
        return this.m_titles[index];
    }

    @Override
    protected String getExpression(int index) throws Exception {
        return this.m_expressions[index];
    }

    @Override
    public void configure(EditorState state, Map<String, Object> parameters) throws Exception {
        this.initializeParameters(parameters);
        this.prepareParameters(state);
        Assert.isTrue((this.m_expressions.length == this.m_conditions.length && this.m_expressions.length == this.m_titles.length ? 1 : 0) != 0, (String)"Count of expressions/conditions/titles should be same in %s", (Object[])new Object[]{parameters});
        this.compileConditions();
    }

    private void initializeParameters(Map<String, Object> parameters) {
        this.m_expressions = ExpressionListPropertyEditor.getParameterAsArray(parameters, "expressions");
        this.m_conditions = ExpressionListPropertyEditor.getParameterAsArray(parameters, "conditions");
        this.m_titles = ExpressionListPropertyEditor.getParameterAsArray(parameters, "titles", true);
        if (parameters.containsKey(USER_functions)) {
            Object functions = parameters.get(USER_functions);
            if (functions instanceof String) {
                this.m_functions = (String)functions;
            }
        } else {
            this.m_functions = "";
        }
    }

    private void prepareParameters(EditorState state) throws ClassNotFoundException {
        if (this.m_titles == null || this.m_titles.length < 1) {
            this.m_titles = new String[this.m_expressions.length];
            int i = 0;
            while (i < this.m_expressions.length) {
                this.m_titles[i] = this.m_expressions[i];
                ++i;
            }
        }
    }

    private void compileConditions() {
        ParserContext parseContext = ExpressionListPropertyEditor.getParseContext();
        this.m_compiled = new Object[this.m_conditions.length];
        int i = 0;
        while (i < this.m_conditions.length) {
            String expression = DEF_functions + this.m_functions + this.m_conditions[i];
            this.m_compiled[i] = MVEL.compileExpression((String)expression, (ParserContext)parseContext);
            ++i;
        }
    }

    private static ParserContext getParseContext() {
        ParserContext context = new ParserContext();
        context.addImport("ReflectionUtils", ReflectionUtils.class);
        return context;
    }
}

