/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.accessor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IAccessibleExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IExposableExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipTextProvider;
import org.eclipse.wb.internal.core.utils.jdt.core.JavaDocUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public class AccessorUtils {
    private AccessorUtils() {
    }

    public static IAccessibleExpressionAccessor IAccessibleExpressionAccessor_forMethod(final Method method) {
        return new IAccessibleExpressionAccessor(){

            @Override
            public boolean isAccessible(JavaInfo javaInfo) {
                return Modifier.isPublic(method.getModifiers()) || javaInfo.getCreationSupport() instanceof ThisCreationSupport;
            }
        };
    }

    public static IAccessibleExpressionAccessor IAccessibleExpressionAccessor_forField(final Field field) {
        return new IAccessibleExpressionAccessor(){

            @Override
            public boolean isAccessible(JavaInfo javaInfo) {
                return Modifier.isPublic(field.getModifiers()) || javaInfo.getCreationSupport() instanceof ThisCreationSupport;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static IExposableExpressionAccessor getExposableExpressionAccessor(Property property) throws Exception {
        Property property2 = property;
        if (property2 instanceof GenericPropertyImpl) {
            void genericProperty;
            GenericPropertyImpl genericPropertyImpl = (GenericPropertyImpl)property2;
            GenericPropertyImpl cfr_ignored_0 = (GenericPropertyImpl)property2;
            for (ExpressionAccessor accessor : genericProperty.getAccessors()) {
                IExposableExpressionAccessor exposableAccessor = accessor.getAdapter(IExposableExpressionAccessor.class);
                if (exposableAccessor == null) continue;
                return exposableAccessor;
            }
        }
        return null;
    }

    public static PropertyTooltipProvider PropertyTooltipProvider_forMethod(final Method method) {
        final String methodSignature = ReflectionUtils.getMethodSignature((Method)method);
        return new PropertyTooltipTextProvider(){

            protected String getText(Property property) throws Exception {
                IJavaProject javaProject = (IJavaProject)property.getAdapter(IJavaProject.class);
                String javaDocText = JavaDocUtils.getTooltip(javaProject, method.getDeclaringClass().getName(), methodSignature);
                if (javaDocText == null) {
                    return property.getTitle();
                }
                return javaDocText;
            }
        };
    }

    public static PropertyTooltipProvider PropertyTooltipProvider_forField(final Field field) {
        return new PropertyTooltipTextProvider(){

            protected String getText(Property property) throws Exception {
                IJavaProject javaProject = (IJavaProject)property.getAdapter(IJavaProject.class);
                IType findType = javaProject.findType(field.getDeclaringClass().getName());
                String javaDocText = JavaDocUtils.getTooltip((IMember)findType.getField(field.getName()));
                if (javaDocText == null) {
                    return property.getTitle();
                }
                return javaDocText;
            }
        };
    }
}

