/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.eval;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.eval.evaluators.InvocationEvaluator;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;

public final class AstEvaluationEngine {
    public static final Object UNKNOWN = new Object();

    public static Object evaluate(final EvaluationContext context, final Expression expression) throws Exception {
        try {
            return AstEvaluationEngine.evaluate0(context, expression);
        }
        catch (Throwable e) {
            Object result = ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<Object>(){

                public Object runObject() throws Exception {
                    return context.evaluationFailed(expression, e);
                }
            }, (Object)UNKNOWN);
            if (result != UNKNOWN) {
                return result;
            }
            throw new Error(context.getSource((ASTNode)expression), e);
        }
    }

    public static Object createClassInstanceCreationDirectly(EvaluationContext context, ClassInstanceCreation creation) throws Exception {
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((Expression)creation);
        String typeQualifiedName = AstNodeUtils.getFullyQualifiedName(typeBinding, true);
        return new InvocationEvaluator().evaluate(context, (Expression)creation, typeBinding, typeQualifiedName);
    }

    public static Object createAnonymousInstance(EvaluationContext context, IMethodBinding methodBinding, Object[] argumentValues) throws Exception {
        return InvocationEvaluator.createAnonymousInstance(context, methodBinding, argumentValues);
    }

    public static String getUserStackTrace(Throwable e) {
        e = DesignerExceptionUtils.getRootCause((Throwable)e);
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
        stackTrace = StringUtils.substringBefore((String)stackTrace, (String)"at org.eclipse.wb.");
        stackTrace = StringUtils.substringBefore((String)stackTrace, (String)"at sun.reflect.");
        stackTrace = StringUtils.stripEnd((String)stackTrace, null);
        return stackTrace;
    }

    /*
     * WARNING - void declaration
     */
    private static Object evaluate0(EvaluationContext context, Expression expression) throws Exception {
        Object value = context.evaluate(expression);
        if (value != UNKNOWN) {
            context.evaluationSuccessful(expression, value);
            return value;
        }
        if (expression instanceof NullLiteral) {
            context.evaluationSuccessful(expression, null);
            return null;
        }
        Expression expression2 = expression;
        if (expression2 instanceof ParenthesizedExpression) {
            void parenthesizedExpression;
            value = (ParenthesizedExpression)expression2;
            ParenthesizedExpression cfr_ignored_0 = (ParenthesizedExpression)expression2;
            Object value2 = AstEvaluationEngine.evaluate(context, parenthesizedExpression.getExpression());
            context.evaluationSuccessful(expression, value2);
            return value2;
        }
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(expression);
        String typeQualifiedName = AstNodeUtils.getFullyQualifiedName(typeBinding, false);
        for (IExpressionEvaluator evaluator : context.getEvaluators()) {
            Object value3 = evaluator.evaluate(context, expression, typeBinding, typeQualifiedName);
            if (value3 == UNKNOWN) continue;
            context.evaluationSuccessful(expression, value3);
            return value3;
        }
        List evaluators = ExternalFactoriesHelper.getElementsInstances(IExpressionEvaluator.class, (String)"org.eclipse.wb.core.expressionEvaluators", (String)"evaluator");
        for (IExpressionEvaluator evaluator : evaluators) {
            Object value4 = evaluator.evaluate(context, expression, typeBinding, typeQualifiedName);
            if (value4 == UNKNOWN) continue;
            context.evaluationSuccessful(expression, value4);
            return value4;
        }
        throw new DesignerException(300, new String[]{context.getSource((ASTNode)expression)});
    }
}

