/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.index;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.INamespace;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.index2.IElementResolver;
import org.eclipse.dltk.internal.core.MethodParameterInfo;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.core.SourceMethodUtils;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.index.IPHPDocAwareElement;
import org.eclipse.php.internal.core.index.PHPIndexingVisitor;
import org.eclipse.php.internal.core.model.IncludeField;

public class PHPElementResolver
implements IElementResolver {
    private static final char SPLIT_CHAR = ';';
    private static final char SEPARATOR_CHAR = ',';
    private static final char RETURN_TYPE_CHAR = ':';
    private static final String[] EMPTY = new String[0];

    public IModelElement resolve(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule) {
        int occurrenceCount = 1;
        String metadataToDecode = null;
        if (metadata != null) {
            String[] split = StringUtils.split((String)metadata, (char)';');
            if (split.length >= 1) {
                try {
                    occurrenceCount = Integer.parseInt(split[0]);
                }
                catch (NumberFormatException e) {
                    Logger.logException(e);
                }
            }
            if (split.length >= 2) {
                metadataToDecode = split[1];
            }
        }
        Object parentElement = (ModelElement)sourceModule;
        if ("<f>".equals(parent)) {
            parent = null;
        }
        if ("<g>".equals(qualifier)) {
            qualifier = null;
        }
        if (qualifier != null) {
            parentElement = new IndexType((ModelElement)parentElement, qualifier, 2048, 0, 0, 0, 0, null, doc, occurrenceCount);
        }
        if (parent != null) {
            parentElement = new SourceType(parentElement, parent);
        }
        String[] superClassNames = null;
        switch (elementType) {
            case 10: {
                if (metadataToDecode != null) {
                    superClassNames = StringUtils.split((String)metadataToDecode, (char)',');
                }
                assert (qualifier == null);
                return new IndexType((ModelElement)parentElement, elementName, flags, offset, length, nameOffset, nameLength, superClassNames, doc, occurrenceCount);
            }
            case 7: {
                if (metadataToDecode != null) {
                    superClassNames = StringUtils.split((String)metadataToDecode, (char)',');
                }
                return new IndexType((ModelElement)parentElement, elementName, flags, offset, length, nameOffset, nameLength, superClassNames, doc, 1);
            }
            case 9: {
                String[] parameters = EMPTY;
                String returnType = null;
                if (metadataToDecode != null && metadataToDecode.length() > 1) {
                    if (metadataToDecode.charAt(0) == ':') {
                        returnType = null;
                        metadataToDecode = metadataToDecode.substring(1);
                    } else if (metadataToDecode.charAt(metadataToDecode.length() - 1) == ':') {
                        returnType = metadataToDecode.substring(0, metadataToDecode.length() - 1);
                        metadataToDecode = null;
                    } else {
                        String[] decoded = StringUtils.split((String)metadataToDecode, (char)':');
                        if (decoded.length == 2) {
                            metadataToDecode = decoded[1];
                            returnType = decoded[0];
                        }
                    }
                    if (metadataToDecode != null) {
                        parameters = StringUtils.split((String)metadataToDecode, (char)',');
                    }
                }
                return new IndexMethod((ModelElement)parentElement, elementName, returnType, flags, offset, length, nameOffset, nameLength, parameters, doc, 1);
            }
            case 8: {
                return new IndexField((ModelElement)parentElement, elementName, flags, offset, length, nameOffset, nameLength, doc, 1);
            }
            case 12: {
                return new IncludeField((ModelElement)parentElement, metadataToDecode);
            }
        }
        Logger.log(2, String.valueOf(PHPElementResolver.class.getName()) + ": Unsupported element type (" + elementType + ")");
        return null;
    }

    protected static Map<String, String> decodeDocInfo(String doc) {
        if (doc == null) {
            return null;
        }
        HashMap<String, String> info = new HashMap<String, String>();
        StringTokenizer tok = new StringTokenizer(doc, ";");
        while (tok.hasMoreTokens()) {
            String key = tok.nextToken();
            String value = null;
            int i = key.indexOf(58);
            if (i != -1) {
                value = key.substring(i + 1);
                key = key.substring(0, i);
            }
            info.put(key, value);
        }
        return info;
    }

    private static class IndexField
    extends SourceField
    implements IPHPDocAwareElement {
        private int flags;
        private ISourceRange sourceRange;
        private ISourceRange nameRange;
        private String doc;

        public IndexField(ModelElement parent, String name, int flags, int offset, int length, int nameOffset, int nameLength, String doc, int occurrenceCount) {
            super(parent, name);
            this.flags = flags;
            this.sourceRange = new SourceRange(offset, length);
            this.nameRange = new SourceRange(nameOffset, nameLength);
            this.doc = doc;
            this.occurrenceCount = occurrenceCount;
        }

        public int getFlags() throws ModelException {
            return this.flags;
        }

        public ISourceRange getNameRange() throws ModelException {
            return this.nameRange;
        }

        public ISourceRange getSourceRange() throws ModelException {
            return this.sourceRange;
        }

        @Override
        public boolean isDeprecated() {
            return PHPFlags.isDeprecated(this.flags);
        }

        @Override
        public String[] getReturnTypes() {
            return null;
        }

        public INamespace getNamespace() throws ModelException {
            return null;
        }

        public String getType() throws ModelException {
            String types;
            Map<String, String> info = PHPElementResolver.decodeDocInfo(this.doc);
            if (info != null && (types = info.get("v")) != null) {
                types = types.replace('.', '|');
                return types;
            }
            return null;
        }
    }

    private static class IndexMethod
    extends SourceMethod
    implements IPHPDocAwareElement {
        private int flags;
        private ISourceRange sourceRange;
        private ISourceRange nameRange;
        private String returnType;
        private IParameter[] parameters;
        private String doc;

        public IndexMethod(ModelElement parent, String name, String returnType, int flags, int offset, int length, int nameOffset, int nameLength, String[] parameterNames, String doc, int occurrenceCount) {
            super(parent, name);
            this.returnType = returnType;
            this.flags = flags;
            this.sourceRange = new SourceRange(offset, length);
            this.nameRange = new SourceRange(nameOffset, nameLength);
            this.parameters = new IParameter[0];
            if (parameterNames != null) {
                this.parameters = new IParameter[parameterNames.length];
                int i = 0;
                while (i < parameterNames.length) {
                    String[] values = parameterNames[i].split("\\@");
                    if (values.length == 1) {
                        this.parameters[i] = new MethodParameterInfo(values[0]);
                    } else {
                        String type = values[0];
                        if ("#".equals(type)) {
                            type = null;
                        }
                        if (type != null) {
                            type = type.replace('.', '|');
                        }
                        String param = values[1];
                        String defaultValue = values[2];
                        if ("#".equals(defaultValue)) {
                            defaultValue = null;
                        }
                        if (defaultValue != null) {
                            defaultValue = PHPIndexingVisitor.decodeValue(defaultValue);
                        }
                        int modifiers = 0;
                        if (values.length == 4) {
                            try {
                                modifiers = Integer.parseInt(values[3]);
                            }
                            catch (NumberFormatException e) {
                                Logger.logException(e);
                            }
                        }
                        this.parameters[i] = new MethodParameterInfo(param, type, defaultValue, modifiers);
                    }
                    ++i;
                }
            }
            this.doc = doc;
            this.occurrenceCount = occurrenceCount;
        }

        public int getFlags() throws ModelException {
            return this.flags;
        }

        public ISourceRange getNameRange() throws ModelException {
            return super.getNameRange();
        }

        public ISourceRange getSourceRange() throws ModelException {
            return this.sourceRange;
        }

        public IParameter[] getParameters() throws ModelException {
            return this.parameters;
        }

        public String[] getParameterNames() throws ModelException {
            return SourceMethodUtils.getParameterNames((IParameter[])this.parameters);
        }

        public boolean isConstructor() throws ModelException {
            return (this.flags & 0x100000) != 0;
        }

        @Override
        public boolean isDeprecated() {
            return PHPFlags.isDeprecated(this.flags);
        }

        @Override
        public String[] getReturnTypes() {
            String types;
            if (this.returnType != null) {
                return new String[]{this.returnType};
            }
            Map<String, String> info = PHPElementResolver.decodeDocInfo(this.doc);
            if (info != null && (types = info.get("r")) != null) {
                String[] returnTypes = types.split(",");
                int i = 0;
                while (i < returnTypes.length) {
                    returnTypes[i] = returnTypes[i].replaceAll("~", ",");
                    ++i;
                }
                return returnTypes;
            }
            return null;
        }

        public INamespace getNamespace() throws ModelException {
            return null;
        }
    }

    private static class IndexType
    extends SourceType
    implements IPHPDocAwareElement {
        private int flags;
        private ISourceRange sourceRange;
        private ISourceRange nameRange;
        private String[] superClassNames;
        private String doc;

        public IndexType(ModelElement parent, String name, int flags, int offset, int length, int nameOffset, int nameLength, String[] superClassNames, String doc, int occurrenceCount) {
            super(parent, name);
            this.flags = flags;
            this.sourceRange = new SourceRange(offset, length);
            this.nameRange = new SourceRange(nameOffset, nameLength);
            this.superClassNames = superClassNames;
            this.doc = doc;
            this.occurrenceCount = occurrenceCount;
        }

        public int getFlags() throws ModelException {
            return this.flags;
        }

        public ISourceRange getNameRange() throws ModelException {
            return super.getNameRange();
        }

        public ISourceRange getSourceRange() throws ModelException {
            return this.sourceRange;
        }

        public String[] getSuperClasses() throws ModelException {
            return this.superClassNames;
        }

        @Override
        public boolean isDeprecated() {
            return PHPFlags.isDeprecated(this.flags);
        }

        @Override
        public String[] getReturnTypes() {
            return null;
        }

        public INamespace getNamespace() throws ModelException {
            return null;
        }
    }
}

