/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.ui.types;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.server.ui.Activator;
import org.eclipse.php.internal.server.ui.types.ServerTypeDescriptor;
import org.eclipse.php.server.core.types.IServerType;
import org.eclipse.php.server.ui.types.IServerTypeDescriptor;

public class ServerTypesDescriptorRegistry {
    private static Map<String, IServerTypeDescriptor> descriptors = null;
    protected static final String PROP_ID = "descriptor";
    public static final String EXTENSION_POINT_ID = String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".serverTypeDescriptor";
    private static ServerTypesDescriptorRegistry instance;

    public static final synchronized IServerTypeDescriptor getDescriptor(IServerType serverType) {
        Map<String, IServerTypeDescriptor> descriptors = ServerTypesDescriptorRegistry.getDescriptors();
        if (serverType == null || serverType.getId() == null) {
            return descriptors.get("org.eclipse.php.server.core.genericServerType");
        }
        return descriptors.get(serverType.getId());
    }

    private static final Map<String, IServerTypeDescriptor> getDescriptors() {
        if (descriptors == null) {
            descriptors = ServerTypesDescriptorRegistry.getDefault().readFromExtensionPoint();
        }
        return descriptors;
    }

    private static ServerTypesDescriptorRegistry getDefault() {
        if (instance == null) {
            instance = new ServerTypesDescriptorRegistry();
        }
        return instance;
    }

    private Map<String, IServerTypeDescriptor> readFromExtensionPoint() {
        IConfigurationElement[] configurationElements;
        HashMap<String, IServerTypeDescriptor> descriptors = new HashMap<String, IServerTypeDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ServerTypeDescriptor descriptor = new ServerTypeDescriptor(element);
            descriptors.put(descriptor.getServerTypeId(), descriptor);
            ++n2;
        }
        return descriptors;
    }
}

