/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTNodes;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.language.PHPVariables;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;

public class SuperGlobalHighlighting
extends AbstractSemanticHighlighting {
    @Override
    public AbstractSemanticApply getSemanticApply() {
        return new SuperGlobalApply();
    }

    @Override
    protected void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(true).setDefaultTextColor(127, 0, 85).setBoldByDefault(true);
    }

    public String getDisplayName() {
        return Messages.SuperGlobalHighlighting_0;
    }

    protected class SuperGlobalApply
    extends AbstractSemanticApply {
        protected SuperGlobalApply() {
        }

        public boolean visit(Variable var) {
            if (this.isSuperGlobal(var)) {
                SuperGlobalHighlighting.this.highlight((ASTNode)var);
            }
            return true;
        }

        public boolean visit(SingleFieldDeclaration singleFieldDeclaration) {
            if (singleFieldDeclaration.getValue() != null) {
                singleFieldDeclaration.getValue().accept((Visitor)this);
            }
            return false;
        }

        public boolean visit(StaticFieldAccess staticMember) {
            staticMember.getClassName().accept((Visitor)this);
            return false;
        }

        private boolean isSuperGlobal(Variable var) {
            if ((var.isDollared() || ASTNodes.isQuotedDollaredCurlied((Variable)var)) && var.getName() instanceof Identifier) {
                String name = "$" + ((Identifier)var.getName()).getName();
                return PHPVariables.isVariable((String)name, (PHPVersion)var.getAST().apiLevel());
            }
            return false;
        }
    }
}

