/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.evaluation.types.SimpleType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.internal.core.typeinference.PHPClassType;

public class PHPSimpleTypes {
    private static final Map<String, TypeInfo> SIMPLE_TYPES;
    @NonNull
    public static final IEvaluatedType NUMBER;
    @NonNull
    public static final IEvaluatedType BOOLEAN;
    @NonNull
    public static final IEvaluatedType STRING;
    @NonNull
    public static final IEvaluatedType OBJECT;
    @NonNull
    public static final IEvaluatedType RESOURCE;
    @NonNull
    public static final IEvaluatedType ARRAY;
    @NonNull
    public static final IEvaluatedType VOID;
    @NonNull
    public static final IEvaluatedType NULL;
    @NonNull
    public static final IEvaluatedType MIXED;
    @NonNull
    public static final IEvaluatedType CALLABLE;
    @NonNull
    public static final IEvaluatedType ITERABLE;

    static {
        NUMBER = new SimpleType(1);
        BOOLEAN = new SimpleType(5);
        STRING = new SimpleType(0);
        OBJECT = new PHPClassType("object");
        RESOURCE = new PHPClassType("resource");
        ARRAY = new MultiTypeType(){

            public final void addType(IEvaluatedType type) {
            }

            public final List<IEvaluatedType> getTypes() {
                return Collections.unmodifiableList(super.getTypes());
            }

            public final String getTypeName() {
                return "array";
            }
        };
        VOID = new SimpleType(6);
        NULL = new SimpleType(8);
        MIXED = new PHPClassType("mixed");
        CALLABLE = new PHPClassType("callable");
        ITERABLE = new PHPClassType("iterable");
        SIMPLE_TYPES = new HashMap<String, TypeInfo>();
        SIMPLE_TYPES.put("array", new TypeInfo(ARRAY, PHPVersion.PHP5));
        SIMPLE_TYPES.put("bool", new TypeInfo(BOOLEAN, PHPVersion.PHP7_0));
        SIMPLE_TYPES.put("boolean", new TypeInfo(BOOLEAN, null));
        SIMPLE_TYPES.put("int", new TypeInfo(NUMBER, PHPVersion.PHP7_0));
        SIMPLE_TYPES.put("integer", new TypeInfo(NUMBER, null));
        SIMPLE_TYPES.put("float", new TypeInfo(NUMBER, PHPVersion.PHP7_0));
        SIMPLE_TYPES.put("double", new TypeInfo(NUMBER, null));
        SIMPLE_TYPES.put("number", new TypeInfo(NUMBER, null));
        SIMPLE_TYPES.put("string", new TypeInfo(STRING, PHPVersion.PHP7_0));
        SIMPLE_TYPES.put("resource", new TypeInfo(RESOURCE, null));
        SIMPLE_TYPES.put("object", new TypeInfo(OBJECT, PHPVersion.PHP7_2));
        SIMPLE_TYPES.put("void", new TypeInfo(VOID, PHPVersion.PHP7_1));
        SIMPLE_TYPES.put("null", new TypeInfo(NULL, null));
        SIMPLE_TYPES.put("mixed", new TypeInfo(MIXED, null));
        SIMPLE_TYPES.put("callable", new TypeInfo(CALLABLE, PHPVersion.PHP5_4));
        SIMPLE_TYPES.put("callback", new TypeInfo(CALLABLE, null));
        SIMPLE_TYPES.put("iterable", new TypeInfo(ITERABLE, PHPVersion.PHP7_1));
    }

    @Nullable
    public static IEvaluatedType fromString(@Nullable String type) {
        if (type == null) {
            return null;
        }
        TypeInfo typeInfo = SIMPLE_TYPES.get(type.toLowerCase());
        if (typeInfo != null) {
            return typeInfo.type;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static IEvaluatedType fromStringCS(@Nullable String type) {
        if (type == null) {
            return null;
        }
        TypeInfo typeInfo = SIMPLE_TYPES.get(type);
        if (typeInfo != null) {
            return typeInfo.type;
        }
        return null;
    }

    @Deprecated
    public static boolean isSimpleTypeCS(@Nullable String type) {
        if (type == null) {
            return false;
        }
        return SIMPLE_TYPES.containsKey(type);
    }

    public static boolean isSimpleType(@Nullable String type) {
        if (type == null) {
            return false;
        }
        return SIMPLE_TYPES.containsKey(type.toLowerCase());
    }

    public static boolean isHintable(@Nullable String name, @Nullable PHPVersion phpVersion) {
        if (name == null) {
            return false;
        }
        TypeInfo typeInfo = SIMPLE_TYPES.get(name.toLowerCase());
        if (typeInfo != null) {
            return typeInfo.isHintable(phpVersion);
        }
        return false;
    }

    private static TypeInfo findInfo(@Nullable IEvaluatedType type) {
        if (type == null) {
            return null;
        }
        for (TypeInfo info : SIMPLE_TYPES.values()) {
            if (!info.type.equals(type)) continue;
            return info;
        }
        return null;
    }

    public static boolean isSimpleType(@Nullable IEvaluatedType type) {
        return PHPSimpleTypes.findInfo(type) != null;
    }

    public static boolean isHintable(@Nullable IEvaluatedType type, @Nullable PHPVersion phpVersion) {
        TypeInfo info = PHPSimpleTypes.findInfo(type);
        if (info != null) {
            return info.isHintable(phpVersion);
        }
        return false;
    }

    private static class TypeInfo {
        public IEvaluatedType type;
        public PHPVersion hintableSince;

        public TypeInfo(@NonNull IEvaluatedType type, @Nullable PHPVersion hintableSince) {
            this.type = type;
            this.hintableSince = hintableSince;
        }

        public boolean isHintable() {
            return this.hintableSince != null;
        }

        public boolean isHintable(@Nullable PHPVersion phpVersion) {
            if (!this.isHintable()) {
                return false;
            }
            if (phpVersion == null) {
                return true;
            }
            return this.hintableSince == phpVersion || this.hintableSince.isLessThan(phpVersion);
        }
    }
}

