/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.model;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDataReadMemoryInfo;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIExpressionManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIMemoryManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIRegisterManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIVariableManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIMemory;
import org.eclipse.ptp.debug.core.pdi.model.IPDIMemoryBlock;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDataWriteMemoryRequest;
import org.eclipse.ptp.internal.debug.core.ExtFormat;
import org.eclipse.ptp.internal.debug.core.pdi.SessionObject;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;

public class MemoryBlock
extends SessionObject
implements IPDIMemoryBlock {
    private IPDIDataReadMemoryInfo mem;
    private int fWordSize;
    private BigInteger pStartAddress;
    private byte[] cBytes;
    private int[] badOffsets;
    private final boolean fIsLittleEndian;
    String expression;
    boolean frozen;

    public MemoryBlock(IPDISession session, TaskSet tasks, String exp, int wordSize, boolean isLittle, IPDIDataReadMemoryInfo info) {
        super(session, tasks);
        this.expression = exp;
        this.fWordSize = wordSize;
        this.frozen = true;
        this.fIsLittleEndian = isLittle;
        this.setDataReadMemoryInfo(info);
    }

    @Override
    public byte[] getBytes() throws PDIException {
        return this.cBytes;
    }

    @Override
    public IPDIDataReadMemoryInfo getDataReadMemoryInfo() {
        return this.mem;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public synchronized byte getFlags(int offset) {
        if (offset < 0 || (long)offset >= this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.badOffsets == null) {
            this.badOffsets = this.getBadOffsets(this.mem);
        }
        if (this.badOffsets != null) {
            int[] nArray = this.badOffsets;
            int n = this.badOffsets.length;
            int n2 = 0;
            while (n2 < n) {
                int badOffset = nArray[n2];
                if (badOffset == offset) {
                    return 0;
                }
                ++n2;
            }
        }
        return 2;
    }

    @Override
    public long getLength() {
        try {
            return this.getBytes().length;
        }
        catch (PDIException pDIException) {
            return this.mem.getTotalBytes();
        }
    }

    @Override
    public BigInteger getStartAddress() {
        return this.pStartAddress;
    }

    @Override
    public int getWordSize() {
        return this.fWordSize;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public void refresh() throws PDIException {
        IPDIMemoryManager mgr = this.session.getMemoryManager();
        BigInteger[] addresses = mgr.update(this, null);
        if (addresses.length > 0) {
            IPDIMemoryBlock[] blocks;
            IPDIMemoryBlock[] iPDIMemoryBlockArray = blocks = mgr.getMemoryBlocks(this.getTasks());
            int n = blocks.length;
            int n2 = 0;
            while (n2 < n) {
                IPDIMemoryBlock block2 = iPDIMemoryBlockArray[n2];
                MemoryBlock block = (MemoryBlock)block2;
                if (!block.equals(this) && block.contains(addresses)) {
                    mgr.update(block, null);
                }
                ++n2;
            }
        }
    }

    @Override
    public void setDataReadMemoryInfo(IPDIDataReadMemoryInfo m) {
        this.pStartAddress = ExtFormat.getBigInteger(m.getAddress());
        this.cBytes = this.getBytes(m);
        this.mem = m;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    @Override
    public void setValue(long offset, byte[] bytes) throws PDIException {
        IPDIVariableManager varMgr;
        IPDIExpressionManager expMgr;
        if (offset >= this.getLength() || offset + (long)bytes.length > this.getLength()) {
            throw new PDIException(this.getTasks(), Messages.MemoryBlock_0);
        }
        int i = 0;
        while (i < bytes.length) {
            long l = new Byte(bytes[i]).longValue() & 0xFFL;
            String value = "0x" + Long.toHexString(l);
            IPDIDataWriteMemoryRequest request = this.session.getRequestFactory().getDataWriteMemoryRequest(this.getTasks(), offset + (long)i, this.expression, 0, 1, value);
            this.session.getEventRequestManager().addEventRequest(request);
            request.waitUntilCompleted(this.getTasks());
            ++i;
        }
        this.refresh();
        IPDIRegisterManager regMgr = this.session.getRegisterManager();
        if (regMgr.isAutoUpdate()) {
            regMgr.update(this.getTasks());
        }
        if ((expMgr = this.session.getExpressionManager()).isAutoUpdate()) {
            expMgr.update(this.getTasks());
        }
        if ((varMgr = this.session.getVariableManager()).isAutoUpdate()) {
            varMgr.update(this.getTasks());
        }
    }

    private boolean contains(BigInteger addr) {
        BigInteger start = this.getStartAddress();
        long length = this.getLength();
        return start.compareTo(addr) <= 0 && addr.compareTo(start.add(BigInteger.valueOf(length))) <= 0;
    }

    private boolean contains(BigInteger[] adds) {
        BigInteger[] bigIntegerArray = adds;
        int n = adds.length;
        int n2 = 0;
        while (n2 < n) {
            BigInteger add = bigIntegerArray[n2];
            if (this.contains(add)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int[] getBadOffsets(IPDIDataReadMemoryInfo m) {
        IPDIMemory[] miMem;
        int[] offsets = new int[]{};
        if (m == null) {
            return offsets;
        }
        IPDIMemory[] iPDIMemoryArray = miMem = m.getMemories();
        int n = miMem.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIMemory element = iPDIMemoryArray[n2];
            int[] data = element.getBadOffsets();
            if (data.length > 0) {
                int olen = offsets.length;
                int[] newOffsets = new int[olen + data.length];
                System.arraycopy(offsets, 0, newOffsets, 0, olen);
                System.arraycopy(data, 0, newOffsets, olen, data.length);
                offsets = newOffsets;
            }
            ++n2;
        }
        return offsets;
    }

    private byte[] getBytes(IPDIDataReadMemoryInfo m) {
        IPDIMemory[] miMem;
        byte[] bytes = new byte[]{};
        if (m == null) {
            return bytes;
        }
        IPDIMemory[] iPDIMemoryArray = miMem = m.getMemories();
        int n = miMem.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIMemory element = iPDIMemoryArray[n2];
            long[] data = element.getData();
            if (data != null && data.length > 0) {
                long[] lArray = data;
                int n3 = data.length;
                int n4 = 0;
                while (n4 < n3) {
                    long element2 = lArray[n4];
                    byte[] bs = this.longToBytes(element2);
                    int blen = bytes.length;
                    byte[] newBytes = new byte[blen + bs.length];
                    System.arraycopy(bytes, 0, newBytes, 0, blen);
                    System.arraycopy(bs, 0, newBytes, blen, bs.length);
                    bytes = newBytes;
                    ++n4;
                }
            }
            ++n2;
        }
        return bytes;
    }

    private byte[] longToBytes(long v) {
        int count = 1;
        long value = v;
        count = 1;
        while ((value /= 256L) > 0L) {
            ++count;
        }
        if (this.fWordSize != count) {
            this.fWordSize = count;
        }
        byte[] bytes = new byte[count];
        if (this.fIsLittleEndian) {
            int i = count - 1;
            while (i >= 0) {
                int shift = i * count;
                bytes[i] = (byte)(v >>> shift & 0xFFL);
                --i;
            }
        } else {
            int i = 0;
            while (i < count) {
                int shift = (count - i - 1) * count;
                bytes[i] = (byte)(v >>> shift & 0xFFL);
                ++i;
            }
        }
        return bytes;
    }
}

