/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.validator;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.compiler.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ArrayVariableReference;
import org.eclipse.php.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.Comment;
import org.eclipse.php.core.compiler.ast.nodes.ConditionalExpression;
import org.eclipse.php.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.core.compiler.ast.nodes.InfixExpression;
import org.eclipse.php.core.compiler.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPVariableKind;
import org.eclipse.php.core.compiler.ast.nodes.ReferenceExpression;
import org.eclipse.php.core.compiler.ast.nodes.ReflectionArrayVariableReference;
import org.eclipse.php.core.compiler.ast.nodes.ReflectionVariableReference;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.compiler.ast.nodes.StaticStatement;
import org.eclipse.php.core.compiler.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.core.compiler.ast.validator.IValidatorExtension;
import org.eclipse.php.core.compiler.ast.validator.IValidatorVisitor;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPProblemIdentifier;
import org.eclipse.php.internal.core.compiler.ast.validator.Messages;
import org.eclipse.php.internal.core.language.PHPVariables;

public class VariableValidator
implements IValidatorExtension {
    private IBuildContext context;
    private IValidatorVisitor validator;
    private String[] globals = null;
    private List<VarComment> varCommentList;
    private List<PHPDocBlock> docBlocks;
    private Deque<Scope> scopes = new ArrayDeque<Scope>();
    private Deque<Operation> operations = new ArrayDeque<Operation>();
    private Scope current;
    private int depth = 0;
    private Deque<Integer> classDeclarations = new ArrayDeque<Integer>();
    private int inClassDecl = -1;
    private static final String THIS_VAR = "$this";
    private static final char DOLLAR = '$';
    private static final char AMP = '&';
    private static final String COMPACT = "compact";

    @Override
    public void init(IBuildContext buildContext, IValidatorVisitor validator) {
        this.context = buildContext;
        this.validator = validator;
    }

    @Override
    public void visit(ASTNode s) throws Exception {
        if (s instanceof PHPModuleDeclaration) {
            s.traverse((ASTVisitor)new VariableValidatorVisitor());
        }
    }

    @Override
    public void endvisit(ASTNode s) throws Exception {
    }

    @Override
    public boolean isSupported(IBuildContext buildContext) {
        return true;
    }

    @Override
    public boolean skipProblem(int start, int end, String message, IProblemIdentifier id) {
        return false;
    }

    @Override
    public boolean skipProblem(ASTNode node, String message, IProblemIdentifier id) {
        return false;
    }

    private class DocVariable
    extends Variable {
        public DocVariable(Comment varComment) {
            super(varComment.sourceStart(), varComment.sourceEnd());
            this.setInitialized(this.start);
        }
    }

    private class ImportedVariable
    extends Variable {
        public Variable parent;

        ImportedVariable(Variable variable) {
            this.parent = variable;
            this.start = variable.start;
            this.end = variable.end;
        }

        ImportedVariable(ASTNode node) {
            this.parent = new Variable(node);
            this.start = this.parent.start;
            this.end = this.parent.end;
        }

        @Override
        public int used() {
            return this.parent.used();
        }

        @Override
        public void setUsed(int used) {
            this.parent.setUsed(used);
        }

        @Override
        public int initialized() {
            return this.parent.initialized();
        }

        @Override
        public void setInitialized(int init) {
            this.parent.setInitialized(init);
        }

        @Override
        public void addAddress(ASTNode node) {
            this.parent.addAddress(node);
        }
    }

    private static enum Operation {
        ASSIGN,
        USE,
        USE_FIELD;

    }

    private class Scope {
        public Map<String, Variable> variables = new HashMap<String, Variable>();
        public int start;
        public int end;

        public Scope(int start, int end) {
            this.start = start;
            this.end = end;
        }

        void copy(Scope scope) {
            for (Map.Entry<String, Variable> entry : scope.variables.entrySet()) {
                this.variables.put(entry.getKey(), new ImportedVariable(entry.getValue()));
            }
        }

        boolean contains(String name, int offset) {
            if (this.variables.containsKey(name)) {
                return true;
            }
            for (VarComment varComment : VariableValidator.this.varCommentList) {
                if (varComment.sourceStart() > offset || this.end < varComment.sourceStart() || !varComment.getVariableReference().getName().equals(name)) continue;
                this.variables.put(name, new DocVariable(varComment));
                return true;
            }
            for (PHPDocBlock block : VariableValidator.this.docBlocks) {
                if (block.sourceStart() > offset || this.end < block.sourceStart()) continue;
                PHPDocTag[] pHPDocTagArray = block.getTags(PHPDocTag.TagKind.VAR);
                int n = pHPDocTagArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PHPDocTag tag = pHPDocTagArray[n2];
                    if (tag.isValidVarTag() && tag.getVariableReference() != null && tag.getVariableReference().getName().equals(name)) {
                        this.variables.put(name, new DocVariable(block));
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    private class Variable {
        public int start;
        public int end;
        private int initialized = -1;
        private int used = -1;
        public TreeMap<Integer, Integer> other = new TreeMap();

        Variable() {
        }

        Variable(ASTNode node) {
            this.start = node.start();
            this.end = node.end();
        }

        Variable(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int initialized() {
            return this.initialized;
        }

        public void setInitialized(int init) {
            this.initialized = init;
        }

        public int used() {
            return this.used;
        }

        public void setUsed(int used) {
            this.used = used;
        }

        public void addAddress(ASTNode node) {
            this.other.put(node.start(), node.end());
        }

        public void addAddress(int start, int end) {
            this.other.put(start, end);
        }
    }

    private class VariableValidatorVisitor
    extends PHPASTVisitor {
        private VariableValidatorVisitor() {
        }

        public boolean visit(ModuleDeclaration s) throws Exception {
            PHPModuleDeclaration module = (PHPModuleDeclaration)s;
            this.pushScope(0, module.end());
            List<VarComment> varComments = module.getVarComments();
            VariableValidator.this.varCommentList = new ArrayList(module.getVarComments().size());
            VariableValidator.this.varCommentList.addAll(varComments);
            Collections.sort(VariableValidator.this.varCommentList, new Comparator<VarComment>(){

                @Override
                public int compare(VarComment o1, VarComment o2) {
                    return o2.sourceStart() - o1.sourceStart();
                }
            });
            VariableValidator.this.docBlocks = new ArrayList(module.getPHPDocBlocks().size());
            VariableValidator.this.docBlocks.addAll(module.getPHPDocBlocks());
            Collections.sort(VariableValidator.this.docBlocks, new Comparator<PHPDocBlock>(){

                @Override
                public int compare(PHPDocBlock o1, PHPDocBlock o2) {
                    return o2.sourceStart() - o1.sourceStart();
                }
            });
            return true;
        }

        public boolean endvisit(ModuleDeclaration s) throws Exception {
            this.popScope();
            return false;
        }

        @Override
        public boolean visit(PHPMethodDeclaration node) throws Exception {
            if (node.isAbstract() || node.getBody() == null) {
                return false;
            }
            this.pushScope(node.sourceStart(), node.sourceEnd());
            for (Object o : node.getArguments()) {
                if (!(o instanceof FormalParameter)) continue;
                VariableReference parameterName = ((FormalParameter)((Object)o)).getParameterName();
                ImportedVariable v = new ImportedVariable((ASTNode)parameterName);
                ((Variable)v).setInitialized(((FormalParameter)((Object)o)).start());
                ((VariableValidator)VariableValidator.this).current.variables.put(parameterName.getName(), v);
            }
            if (VariableValidator.this.inClassDecl + 1 == VariableValidator.this.depth && !node.isStatic()) {
                ImportedVariable v = new ImportedVariable((ASTNode)node);
                ((Variable)v).setInitialized(node.start());
                ((VariableValidator)VariableValidator.this).current.variables.put(VariableValidator.THIS_VAR, v);
            }
            if (node.getBody() != null) {
                node.getBody().traverse((ASTVisitor)this);
            }
            this.popScope();
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean visit(LambdaFunctionDeclaration decl) throws Exception {
            Scope prev = VariableValidator.this.current;
            this.pushScope(decl.sourceStart(), decl.sourceEnd());
            for (FormalParameter formalParameter : decl.getArguments()) {
                if (!(formalParameter instanceof FormalParameter)) continue;
                VariableReference parameterName = formalParameter.getParameterName();
                ImportedVariable v = new ImportedVariable((ASTNode)parameterName);
                ((Variable)v).setInitialized(formalParameter.start());
                ((VariableValidator)VariableValidator.this).current.variables.put(parameterName.getName(), v);
            }
            if (decl.getLexicalVars() != null) {
                for (Expression expression : decl.getLexicalVars()) {
                    void var3_8;
                    if (expression instanceof ReferenceExpression) {
                        Expression expression2 = ((ReferenceExpression)expression).getVariable();
                    }
                    if (!(var3_8 instanceof VariableReference)) continue;
                    String name = ((VariableReference)var3_8).getName();
                    if (prev.contains(name, var3_8.sourceStart())) {
                        ((VariableValidator)VariableValidator.this).current.variables.put(name, new ImportedVariable(prev.variables.get(name)));
                        continue;
                    }
                    VariableValidator.this.validator.reportProblem((ASTNode)var3_8, NLS.bind((String)Messages.VariableValidator_IsUndefined, (Object)name), PHPProblemIdentifier.UndefinedVariable, ProblemSeverity.WARNING);
                }
            }
            if (VariableValidator.this.inClassDecl < VariableValidator.this.depth && prev.contains(VariableValidator.THIS_VAR, 0)) {
                ((VariableValidator)VariableValidator.this).current.variables.put(VariableValidator.THIS_VAR, prev.variables.get(VariableValidator.THIS_VAR));
            }
            if (decl.getBody() != null) {
                decl.getBody().traverse((ASTVisitor)this);
            }
            this.popScope();
            return false;
        }

        @Override
        public boolean visit(PHPCallExpression ex) throws Exception {
            VariableValidator.this.operations.push(Operation.USE);
            if (ex.getReceiver() == null && ex.getCallName() != null && ex.getCallName().getName().equals(VariableValidator.COMPACT) && ex.getArgs() != null) {
                for (ASTNode node : ex.getArgs().getChilds()) {
                    if (!(node instanceof Scalar) || ((Scalar)node).getScalarType() != 2) continue;
                    String name = String.valueOf('$') + ASTUtils.stripQuotes(((Scalar)node).getValue());
                    if (!VariableValidator.this.current.contains(name, node.sourceStart())) continue;
                    ((VariableValidator)VariableValidator.this).current.variables.get(name).setUsed(node.start());
                }
            }
            return super.visit(ex);
        }

        @Override
        public boolean endvisit(PHPCallExpression ex) throws Exception {
            VariableValidator.this.operations.pop();
            return super.endvisit(ex);
        }

        private void endScope(Scope scope) {
            for (Map.Entry<String, Variable> entry : scope.variables.entrySet()) {
                Variable value = entry.getValue();
                if (value.used() >= 0 || value instanceof ImportedVariable || value instanceof DocVariable) continue;
                String mess = NLS.bind((String)Messages.VariableValidator_IsNeverUsed, (Object)entry.getKey());
                VariableValidator.this.validator.reportProblem(value.start, value.end, mess, PHPProblemIdentifier.UnusedVariable, ProblemSeverity.WARNING);
            }
        }

        @Override
        public boolean visit(NamespaceDeclaration s) throws Exception {
            this.pushScope(s.sourceStart(), s.sourceEnd());
            return true;
        }

        @Override
        public boolean endvisit(NamespaceDeclaration s) throws Exception {
            this.popScope();
            return false;
        }

        @Override
        public boolean visit(ForEachStatement s) throws Exception {
            if (s.getExpression() != null) {
                s.getExpression().traverse((ASTVisitor)this);
            }
            VariableValidator.this.operations.push(Operation.ASSIGN);
            if (s.getKey() != null) {
                s.getKey().traverse((ASTVisitor)this);
            }
            if (s.getValue() != null) {
                s.getValue().traverse((ASTVisitor)this);
            }
            VariableValidator.this.operations.pop();
            if (s.getStatement() != null) {
                s.getStatement().traverse((ASTVisitor)this);
            }
            return false;
        }

        private String getName(String name) {
            if (name.length() > 0 && name.charAt(0) == '&') {
                name = name.substring(1);
            }
            return name;
        }

        @Override
        public boolean visit(VariableReference s) throws Exception {
            String name = this.getName(s.getName());
            if (name.charAt(0) != '$' || this.isSuperGlobal(name)) {
                return false;
            }
            if (s.getVariableKind() == PHPVariableKind.GLOBAL && this.isGlobal(name)) {
                return false;
            }
            if (s.getVariableKind() != PHPVariableKind.LOCAL && s.getVariableKind() != PHPVariableKind.GLOBAL && s.getVariableKind() != PHPVariableKind.UNKNOWN) {
                return false;
            }
            this.check(name, s.start(), s.end());
            return true;
        }

        @Override
        public boolean visit(StaticStatement s) throws Exception {
            VariableValidator.this.operations.push(Operation.ASSIGN);
            for (Expression expression : s.getExpressions()) {
                expression.traverse((ASTVisitor)this);
            }
            VariableValidator.this.operations.pop();
            return false;
        }

        protected void check(String name, int start, int end) {
            VariableValidator.this.current.contains(name, start);
            Variable var = ((VariableValidator)VariableValidator.this).current.variables.get(name);
            if (this.isInit()) {
                if (var == null) {
                    var = new Variable(start, end);
                    ((VariableValidator)VariableValidator.this).current.variables.put(name, var);
                } else {
                    var.addAddress(start, end);
                }
                if (var.initialized() < 0) {
                    var.setInitialized(start);
                }
            }
            if (var == null) {
                VariableValidator.this.validator.reportProblem(start, end, NLS.bind((String)Messages.VariableValidator_IsUndefined, (Object)name), PHPProblemIdentifier.UndefinedVariable, ProblemSeverity.WARNING);
            } else if (!this.isInit()) {
                var.setUsed(start);
            }
        }

        @Override
        public boolean visit(ArrayVariableReference s) throws Exception {
            String name = this.getName(s.getName());
            if (name.charAt(0) != '$' || this.isSuperGlobal(name) || s.getVariableKind() == PHPVariableKind.GLOBAL && this.isGlobal(name)) {
                if (s.getIndex() != null) {
                    VariableValidator.this.operations.push(Operation.USE);
                    s.getIndex().traverse((ASTVisitor)this);
                    VariableValidator.this.operations.pop();
                }
                return false;
            }
            this.check(name, s.start(), s.start() + s.getName().length());
            if (s.getIndex() != null) {
                VariableValidator.this.operations.push(Operation.USE);
                s.getIndex().traverse((ASTVisitor)this);
                VariableValidator.this.operations.pop();
            }
            return false;
        }

        @Override
        public boolean visit(ReflectionArrayVariableReference s) throws Exception {
            Scalar name;
            if (s.getExpression() instanceof Scalar && (name = (Scalar)s.getExpression()).getScalarType() == 2) {
                String dolarName = String.valueOf('$') + name.getValue();
                this.check(dolarName, name.start(), name.end());
            }
            VariableValidator.this.operations.push(Operation.USE);
            return true;
        }

        @Override
        public boolean endvisit(ReflectionArrayVariableReference s) throws Exception {
            VariableValidator.this.operations.pop();
            return super.endvisit(s);
        }

        @Override
        public boolean visit(ReflectionVariableReference s) throws Exception {
            Scalar name;
            if (s.getExpression() instanceof Scalar && VariableValidator.this.operations.peekFirst() != Operation.USE_FIELD && (name = (Scalar)s.getExpression()).getScalarType() == 2) {
                String dolarName = String.valueOf('$') + ASTUtils.stripQuotes(name.getValue());
                this.check(dolarName, name.start(), name.end());
            }
            VariableValidator.this.operations.push(Operation.USE);
            return true;
        }

        @Override
        public boolean endvisit(ReflectionVariableReference s) throws Exception {
            VariableValidator.this.operations.pop();
            return super.endvisit(s);
        }

        @Override
        public boolean visit(FieldAccess s) throws Exception {
            if (s.getDispatcher() != null) {
                VariableValidator.this.operations.push(Operation.USE);
                s.getDispatcher().traverse((ASTVisitor)this);
                VariableValidator.this.operations.pop();
            }
            if (s.getField() != null) {
                VariableValidator.this.operations.push(Operation.USE_FIELD);
                s.getField().traverse((ASTVisitor)this);
                VariableValidator.this.operations.pop();
            }
            return false;
        }

        @Override
        public boolean visit(StaticFieldAccess s) throws Exception {
            if (s.getDispatcher() != null) {
                VariableValidator.this.operations.push(Operation.USE);
                s.getDispatcher().traverse((ASTVisitor)this);
                VariableValidator.this.operations.pop();
            }
            if (s.getField() != null) {
                if (s.getField() instanceof ArrayVariableReference) {
                    ArrayVariableReference ref = (ArrayVariableReference)s.getField();
                    if (ref.getIndex() != null) {
                        VariableValidator.this.operations.push(Operation.USE);
                        ref.getIndex().traverse((ASTVisitor)this);
                        VariableValidator.this.operations.pop();
                    }
                } else if (!(s.getField() instanceof VariableReference)) {
                    s.getField().traverse((ASTVisitor)this);
                }
            }
            return false;
        }

        @Override
        public boolean visit(CatchClause s) throws Exception {
            Scope prev = VariableValidator.this.current;
            this.pushScope(s.sourceStart(), s.sourceEnd());
            VariableValidator.this.current.copy(prev);
            try {
                if (s.getVariable() != null) {
                    Variable v = new Variable((ASTNode)s.getVariable());
                    v.setInitialized(s.start());
                    v.setUsed(s.start());
                    ((VariableValidator)VariableValidator.this).current.variables.put(s.getVariable().getName(), v);
                }
                if (s.getStatement() != null) {
                    s.getStatement().traverse((ASTVisitor)this);
                }
            }
            finally {
                this.popScope();
            }
            return false;
        }

        @Override
        public boolean visit(Assignment s) throws Exception {
            VariableValidator.this.operations.push(Operation.USE);
            s.getValue().traverse((ASTVisitor)this);
            VariableValidator.this.operations.pop();
            VariableValidator.this.operations.push(Operation.ASSIGN);
            s.getVariable().traverse((ASTVisitor)this);
            VariableValidator.this.operations.pop();
            return false;
        }

        private boolean isInit() {
            return !VariableValidator.this.operations.isEmpty() && VariableValidator.this.operations.peekFirst() == Operation.ASSIGN;
        }

        @Override
        public boolean visit(GlobalStatement s) throws Exception {
            for (Expression expression : s.getVariables()) {
                if (expression instanceof VariableReference) {
                    Scope parentScope;
                    VariableReference ref = (VariableReference)expression;
                    if (VariableValidator.this.scopes.size() > 1 && (parentScope = (Scope)VariableValidator.this.scopes.peekLast()).contains(ref.getName(), ref.sourceStart())) {
                        ((VariableValidator)VariableValidator.this).current.variables.put(ref.getName(), new ImportedVariable(parentScope.variables.get(ref.getName())));
                        continue;
                    }
                    Variable var = ((VariableValidator)VariableValidator.this).current.variables.get(ref.getName());
                    if (var == null) {
                        var = new Variable((ASTNode)ref);
                        ((VariableValidator)VariableValidator.this).current.variables.put(ref.getName(), var);
                    }
                    if (var.initialized >= 0) continue;
                    var.initialized = ref.start();
                    continue;
                }
                VariableValidator.this.operations.push(Operation.ASSIGN);
                expression.traverse((ASTVisitor)this);
                VariableValidator.this.operations.pop();
            }
            return false;
        }

        private void enterType() {
            VariableValidator.this.inClassDecl = VariableValidator.this.depth;
            VariableValidator.this.classDeclarations.push(VariableValidator.this.depth);
        }

        private void exitType() {
            VariableValidator.this.classDeclarations.pop();
            VariableValidator.this.inClassDecl = VariableValidator.this.classDeclarations.isEmpty() ? -1 : (Integer)VariableValidator.this.classDeclarations.peekFirst();
        }

        @Override
        public boolean visit(ClassDeclaration s) throws Exception {
            if (s.isInterface()) {
                return false;
            }
            this.enterType();
            return true;
        }

        @Override
        public boolean endvisit(ClassDeclaration s) throws Exception {
            this.exitType();
            return false;
        }

        @Override
        public boolean visit(TraitDeclaration s) throws Exception {
            this.enterType();
            return true;
        }

        @Override
        public boolean endvisit(TraitDeclaration s) throws Exception {
            this.exitType();
            return false;
        }

        @Override
        public boolean visit(AnonymousClassDeclaration s) throws Exception {
            this.enterType();
            return true;
        }

        @Override
        public boolean endvisit(AnonymousClassDeclaration s) throws Exception {
            this.exitType();
            return false;
        }

        @Override
        public boolean visit(InfixExpression s) throws Exception {
            VariableValidator.this.operations.push(Operation.USE);
            return true;
        }

        @Override
        public boolean endvisit(InfixExpression s) throws Exception {
            VariableValidator.this.operations.pop();
            return false;
        }

        @Override
        public boolean visit(ConditionalExpression s) throws Exception {
            VariableValidator.this.operations.push(Operation.USE);
            return true;
        }

        @Override
        public boolean endvisit(ConditionalExpression s) throws Exception {
            VariableValidator.this.operations.pop();
            return false;
        }

        private Scope pushScope(int start, int end) {
            VariableValidator.this.current = new Scope(start, end);
            VariableValidator.this.scopes.push(VariableValidator.this.current);
            VariableValidator variableValidator = VariableValidator.this;
            variableValidator.depth = variableValidator.depth + 1;
            return (Scope)VariableValidator.this.scopes.peekFirst();
        }

        private Scope popScope() {
            Scope tmp = (Scope)VariableValidator.this.scopes.pop();
            this.endScope(tmp);
            if (!VariableValidator.this.scopes.isEmpty()) {
                VariableValidator.this.current = (Scope)VariableValidator.this.scopes.peekFirst();
            } else {
                VariableValidator.this.current = null;
            }
            VariableValidator variableValidator = VariableValidator.this;
            variableValidator.depth = variableValidator.depth - 1;
            return tmp;
        }

        private boolean isSuperGlobal(String name) {
            if ("$GLOBALS".equals(name)) {
                return true;
            }
            if (!name.startsWith("$_")) {
                return false;
            }
            return this.isGlobal(name);
        }

        private boolean isGlobal(String name) {
            if (VariableValidator.this.globals == null) {
                VariableValidator.this.globals = PHPVariables.getVariables(VariableValidator.this.validator.getPHPVersion());
            }
            String[] stringArray = VariableValidator.this.globals;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String global = stringArray[n2];
                if (global.equals(name)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

