/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.integration.console.basic;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.libra.framework.editor.core.IOSGiFrameworkConsole;
import org.eclipse.libra.framework.editor.integration.internal.IntegrationPlugin;

public abstract class AbstractBasicOSGiFrameworkConsole
implements IOSGiFrameworkConsole,
IStreamListener {
    private StringBuilder result;

    protected abstract IStreamsProxy getProxy() throws CoreException;

    public synchronized String executeCommand(String command) throws CoreException {
        this.result = new StringBuilder();
        try {
            IStreamsProxy proxy = this.getProxy();
            proxy.getOutputStreamMonitor().addListener((IStreamListener)this);
            proxy.write(String.valueOf(command) + "\n");
        }
        catch (IOException e) {
            throw new CoreException(IntegrationPlugin.newErrorStatus(e));
        }
        long startTime = System.currentTimeMillis();
        int size = 0;
        do {
            size = this.result.length();
            try {
                this.wait(10L);
            }
            catch (InterruptedException e) {
                throw new CoreException(IntegrationPlugin.newErrorStatus(e));
            }
        } while (this.result.length() == 0 && System.currentTimeMillis() - startTime < 5000L || this.result.length() > size);
        return this.result.toString();
    }

    public synchronized void streamAppended(String text, IStreamMonitor monitor) {
        this.result.append(text);
    }
}

