/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath.IClasspathImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath.JarImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath.SrcImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageElement;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageRoot;

public final class ClasspathImageRoot
implements IImageRoot {
    private final IJavaProject m_project;
    private final IClasspathImageContainer[] m_containers;

    public ClasspathImageRoot(String id, IJavaProject project) {
        this.m_project = project;
        ArrayList containers = Lists.newArrayList();
        try {
            IPackageFragmentRoot[] roots = this.m_project.getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                try {
                    if (root.isArchive()) {
                        JarImageContainer jarContainer = new JarImageContainer(id, root);
                        if (!jarContainer.isEmpty()) {
                            containers.add(jarContainer);
                        }
                    } else {
                        SrcImageContainer srcContainer = new SrcImageContainer(id, root);
                        if (!srcContainer.isEmpty()) {
                            containers.add(srcContainer);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_containers = containers.toArray(new IClasspathImageContainer[containers.size()]);
    }

    public void dispose() {
        IClasspathImageContainer[] iClasspathImageContainerArray = this.m_containers;
        int n = this.m_containers.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathImageContainer container = iClasspathImageContainerArray[n2];
            container.dispose();
            ++n2;
        }
    }

    public IClasspathImageContainer[] elements() {
        return this.m_containers;
    }

    public Object[] getSelectionPath(Object data) {
        if (data instanceof String) {
            String path = (String)data;
            if (!path.startsWith("/")) {
                return null;
            }
            path = path.substring(1);
            Path pathObject = new Path(path);
            String packageName = pathObject.removeLastSegments(1).toPortableString().replace('/', '.');
            String resourceName = pathObject.lastSegment();
            IClasspathImageContainer[] iClasspathImageContainerArray = this.m_containers;
            int n = this.m_containers.length;
            int n2 = 0;
            while (n2 < n) {
                IImageContainer[] packageContainers;
                IClasspathImageContainer rootContainer = iClasspathImageContainerArray[n2];
                IImageContainer[] iImageContainerArray = packageContainers = rootContainer.elements();
                int n3 = packageContainers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IImageContainer packageContainer = iImageContainerArray[n4];
                    if (packageContainer.getName().equals(packageName)) {
                        IImageElement[] elements;
                        IImageElement[] iImageElementArray = elements = packageContainer.elements();
                        int n5 = elements.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IImageElement element = iImageElementArray[n6];
                            if (element.getName().equals(resourceName)) {
                                return new Object[]{rootContainer, packageContainer, element};
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }
}

