/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.console;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.libra.framework.editor.core.IOSGiFrameworkConsole;
import org.eclipse.libra.framework.editor.ui.internal.AbstractBundleEditorPage;
import org.eclipse.libra.framework.editor.ui.internal.EditorUIPlugin;
import org.eclipse.libra.framework.editor.ui.internal.SearchTextHistory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.browser.ImageResource;
import org.eclipse.wst.server.ui.ServerUICore;

public class ServerConsoleEditorPage
extends AbstractBundleEditorPage {
    private Text commandText;
    private StyledText manifestText;
    private IToolBarManager toolBarManager;
    private Action backAction;
    private Action forwardAction;
    private Action refreshAction;
    private final SearchTextHistory history = new SearchTextHistory();

    protected void createBundleContent(Composite parent) {
        this.mform = new ManagedForm(parent);
        this.setManagedForm((IManagedForm)this.mform);
        this.sform = this.mform.getForm();
        FormToolkit toolkit = this.mform.getToolkit();
        this.sform.setText("Server Console");
        this.sform.setImage(ServerUICore.getLabelProvider().getImage((Object)this.getServer()));
        this.sform.setExpandHorizontal(true);
        this.sform.setExpandVertical(true);
        toolkit.decorateFormHeading(this.sform.getForm());
        Composite body = this.sform.getBody();
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 6;
        layout.marginTop = 6;
        layout.marginRight = 6;
        body.setLayout((Layout)layout);
        Section manifestSection = toolkit.createSection(this.sform.getBody(), 384);
        manifestSection.setText("Commands");
        manifestSection.setDescription("Execute commands on server.");
        layout = new GridLayout();
        manifestSection.setLayout((Layout)layout);
        manifestSection.setLayoutData((Object)new GridData(1808));
        Composite manifestComposite = toolkit.createComposite((Composite)manifestSection);
        layout = new GridLayout();
        layout.marginLeft = 6;
        layout.marginTop = 6;
        layout.numColumns = 3;
        manifestComposite.setLayoutData((Object)new GridData(1808));
        manifestComposite.setLayout((Layout)layout);
        manifestSection.setClient((Control)manifestComposite);
        Label commandLabel = toolkit.createLabel(manifestComposite, "Command:");
        commandLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)commandLabel);
        this.commandText = toolkit.createText(manifestComposite, "", 384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.commandText);
        this.commandText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' || e.character == '\n') {
                    ServerConsoleEditorPage.this.history.add(ServerConsoleEditorPage.this.commandText.getText());
                    String cmdLine = ServerConsoleEditorPage.this.commandText.getText();
                    ServerConsoleEditorPage.this.executeCommand(cmdLine);
                } else if (e.keyCode == 0x1000001) {
                    String command = ServerConsoleEditorPage.this.history.back();
                    ServerConsoleEditorPage.this.commandText.setText(command);
                    ServerConsoleEditorPage.this.commandText.setSelection(command.length());
                    e.doit = false;
                } else if (e.keyCode == 0x1000002) {
                    String command = ServerConsoleEditorPage.this.history.forward();
                    ServerConsoleEditorPage.this.commandText.setText(command);
                    ServerConsoleEditorPage.this.commandText.setSelection(command.length());
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Button commandButton = toolkit.createButton(manifestComposite, "Execute", 8);
        commandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerConsoleEditorPage.this.history.add(ServerConsoleEditorPage.this.commandText.getText());
                String cmdLine = ServerConsoleEditorPage.this.commandText.getText();
                ServerConsoleEditorPage.this.executeCommand(cmdLine);
            }
        });
        Button clearButton = toolkit.createButton(manifestComposite, "Clear", 8);
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerConsoleEditorPage.this.manifestText.setText("");
            }
        });
        this.manifestText = new StyledText(manifestComposite, 2818);
        this.manifestText.setWordWrap(false);
        this.manifestText.setFont(JFaceResources.getTextFont());
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        this.manifestText.setLayoutData((Object)data);
        Label helpLabel = toolkit.createLabel(manifestComposite, "Type 'help' to get a list of supported commands.");
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)helpLabel);
        this.toolBarManager = this.sform.getToolBarManager();
        this.backAction = new Action("Back"){

            public void run() {
                ServerConsoleEditorPage.this.commandText.setText(ServerConsoleEditorPage.this.history.back());
                String cmdLine = ServerConsoleEditorPage.this.commandText.getText();
                ServerConsoleEditorPage.this.executeCommand(cmdLine);
            }
        };
        this.backAction.setImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_ELCL_NAV_BACKWARD"));
        this.backAction.setHoverImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_CLCL_NAV_BACKWARD"));
        this.backAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_DLCL_NAV_BACKWARD"));
        this.backAction.setEnabled(false);
        this.toolBarManager.add((IAction)this.backAction);
        this.forwardAction = new Action("Forward"){

            public void run() {
                ServerConsoleEditorPage.this.commandText.setText(ServerConsoleEditorPage.this.history.forward());
                String cmdLine = ServerConsoleEditorPage.this.commandText.getText();
                ServerConsoleEditorPage.this.executeCommand(cmdLine);
            }
        };
        this.forwardAction.setImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_ELCL_NAV_FORWARD"));
        this.forwardAction.setHoverImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_CLCL_NAV_FORWARD"));
        this.forwardAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor((String)"IMG_DLCL_NAV_FORWARD"));
        this.forwardAction.setEnabled(false);
        this.toolBarManager.add((IAction)this.forwardAction);
        this.refreshAction = new Action("Refresh from server", ImageResource.getImageDescriptor((String)"IMG_ELCL_NAV_REFRESH")){

            public void run() {
                String cmdLine = ServerConsoleEditorPage.this.history.current();
                if (cmdLine != null) {
                    ServerConsoleEditorPage.this.executeCommand(cmdLine);
                }
            }
        };
        this.toolBarManager.add((IAction)this.refreshAction);
        this.sform.updateToolBar();
    }

    private void executeCommand(String cmdLine) {
        this.clearStatus();
        IOSGiFrameworkConsole console = (IOSGiFrameworkConsole)this.getServer().getOriginal().loadAdapter(IOSGiFrameworkConsole.class, null);
        if (console == null) {
            IStatus status = EditorUIPlugin.newErrorStatus("Console editor part is not integrated with the runtime.");
            EditorUIPlugin.log(status);
            this.setStatus(status);
        }
        try {
            String result = console.executeCommand(cmdLine);
            this.manifestText.append("osgi> " + cmdLine + "\n");
            this.manifestText.append(String.valueOf(result) + "\n");
            this.forwardAction.setEnabled(this.history.canForward());
            this.backAction.setEnabled(this.history.canBack());
            this.toolBarManager.update(true);
            this.manifestText.setTopIndex(this.manifestText.getLineCount() - 1);
        }
        catch (CoreException e) {
            EditorUIPlugin.log(e);
            this.setStatus(EditorUIPlugin.newErrorStatus("Failed to execute command. See Error Log for details."));
        }
        this.commandText.setText("");
    }
}

