/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.style.impl;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.StringComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.AbstractStylePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.SubStylePropertyImpl;
import org.eclipse.wb.internal.core.model.property.editor.style.actions.RadioStyleAction;

public final class EnumerationStylePropertyImpl
extends SubStylePropertyImpl {
    private final long[] m_values;
    private final String[] m_sValues;
    private final long m_flagsClearMask;
    private final long m_enumClearMask;

    public EnumerationStylePropertyImpl(AbstractStylePropertyEditor editor, String title, long[] values, String[] sValues, int clearMask) {
        super(editor, title);
        this.m_values = values;
        this.m_sValues = sValues;
        this.m_flagsClearMask = clearMask;
        this.m_enumClearMask = ~clearMask;
    }

    public PropertyEditor createEditor() {
        return new StringComboPropertyEditor(this.m_sValues);
    }

    public long getFlag(String sFlag) {
        int index = ArrayUtils.indexOf((Object[])this.m_sValues, (Object)sFlag);
        return index != -1 ? this.m_values[index] : 0L;
    }

    public String getFlagValue(Property property) throws Exception {
        long value = this.getStyleValue(property) & this.m_flagsClearMask;
        int index = ArrayUtils.indexOf((long[])this.m_values, (long)value);
        return index != -1 ? this.m_sValues[index] : null;
    }

    public Object getValue(Property property) throws Exception {
        return this.getFlagValue(property);
    }

    public void setValue(Property property, Object value) throws Exception {
        long style = this.getStyleValue(property) & this.m_enumClearMask;
        if (value != Property.UNKNOWN_VALUE) {
            String sValue = (String)value;
            style |= this.m_values[ArrayUtils.indexOf((Object[])this.m_sValues, (Object)sValue)];
        }
        this.setStyleValue(property, style);
    }

    public void contributeActions(Property property, IMenuManager manager) throws Exception {
        manager.add((IContributionItem)new Separator());
        long style = this.getStyleValue(property) & this.m_flagsClearMask;
        int i = 0;
        while (i < this.m_values.length) {
            RadioStyleAction action = new RadioStyleAction(property, this, this.m_sValues[i]);
            if (this.m_values[i] == style) {
                action.setChecked(true);
            }
            manager.add((IAction)action);
            ++i;
        }
    }
}

